/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.storage.actions.workspace;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.customization.properties.Activator;
import org.eclipse.papyrus.customization.properties.messages.Messages;
import org.eclipse.papyrus.customization.properties.storage.actions.ContextStorageActionUtil;
import org.eclipse.papyrus.customization.properties.storage.actions.IContextCopyAction;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.properties.catalog.PropertiesURIHandler;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.util.PropertiesUtil;

public class WorkspaceContextCopyAction
implements IContextCopyAction {
    public String getLabel() {
        return Messages.CustomizationDialog_copyToWorkspace;
    }

    public String getToolTip() {
        return Messages.CustomizationDialog_createNewCopyByCopy;
    }

    public Context copy(Context source, String targetName, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Context result = null;
        try {
            try {
                IPath targetDirectoryPath = org.eclipse.papyrus.views.properties.Activator.getDefault().getPreferencesPath().append("/" + targetName);
                File targetDirectory = targetDirectoryPath.toFile();
                if (targetDirectory.exists()) {
                    throw new IOException("A context with this name already exists");
                }
                URI targetModelUri = URI.createFileURI((String)(String.valueOf(targetDirectory.toString()) + "/" + targetName + ".ctx"));
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Context sourceContext = (Context)EMFHelper.loadEMFModel((ResourceSet)resourceSet, (URI)source.eResource().getURI());
                IStatus copyResult = this.copyAll(sourceContext, new File(targetDirectory, String.valueOf(targetName) + ".ctx"), (IProgressMonitor)sub.newChild(1, 0));
                if (copyResult.isOK()) {
                    result = ConfigurationManager.getInstance().getContext(targetModelUri);
                    result.setName(targetName);
                    result.setPrototype(source);
                    result.eResource().save(Collections.EMPTY_MAP);
                } else if (copyResult.getSeverity() != 8) {
                    throw new CoreException(copyResult);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.customization.properties", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        finally {
            sub.done();
        }
        return result;
    }

    private IStatus copyAll(Context source, File target, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextStorageActionUtil.initializeCopy(source, (IProgressMonitor)sub.newChild(10));
        return this.doCopy(source, target, (IProgressMonitor)sub.newChild(90));
    }

    private IStatus doCopy(Context source, File target, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        File targetDirectory = target.getParentFile();
        String targetName = target.getName();
        try {
            Resource sourceResource = source.eResource();
            targetDirectory.mkdirs();
            int filesToCopy = sourceResource.getResourceSet().getResources().size();
            LinkedList<Context> contexts = new LinkedList<Context>();
            for (Context context : PropertiesUtil.getDependencies((Context)source)) {
                if (!ContextStorageActionUtil.isRelative(sourceResource, context.eResource())) continue;
                contexts.add(context);
                for (Tab tab : context.getTabs()) {
                    filesToCopy += tab.getSections().size();
                }
            }
            monitor.beginTask(String.valueOf(Messages.CopyContextAction_Copying) + source.getName() + Messages.CopyContextAction_To + targetName, filesToCopy);
            this.copy(sourceResource, target);
            monitor.worked(1);
            for (Resource resource : source.eResource().getResourceSet().getResources()) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (resource != sourceResource && ContextStorageActionUtil.isRelative(sourceResource, resource)) {
                    this.copy(resource, targetDirectory, (EObject)source, targetName);
                }
                monitor.worked(1);
            }
            for (Context context : contexts) {
                for (Tab tab : context.getTabs()) {
                    for (Section section : tab.getSections()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        this.copy(section.getSectionFile(), targetDirectory, source);
                        monitor.worked(1);
                    }
                }
            }
            monitor.done();
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
            result = new Status(4, "org.eclipse.papyrus.customization.properties", "An error occured during the copy of " + source.getName(), (Throwable)ex);
            monitor.done();
        }
        return result;
    }

    protected void copy(String xwtFileName, File targetDirectory, Context source) {
        File target = new File(targetDirectory, xwtFileName);
        PropertiesURIHandler uriHandler = new PropertiesURIHandler();
        URI sourceURI = URI.createURI((String)xwtFileName).resolve(source.eResource().getURI());
        if (uriHandler.canHandle(sourceURI)) {
            sourceURI = uriHandler.getConvertedURI(sourceURI);
        }
        try {
            URL netURL = new URL(sourceURI.toString());
            InputStream is = netURL.openStream();
            this.copy(is, target);
        }
        catch (MalformedURLException ex) {
            Activator.log.error((Throwable)ex);
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    protected void copy(Resource resource, File target) throws IOException {
        PropertiesURIHandler uriHandler = new PropertiesURIHandler();
        URI uri = resource.getURI();
        if (uriHandler.canHandle(uri)) {
            uri = uriHandler.getConvertedURI(uri);
        }
        this.copy(new URL(uri.toString()).openStream(), target);
    }

    private void copy(Resource resource, File directory, EObject source, String targetName) throws IOException {
        URI relativeURI = resource.getURI().deresolve(source.eResource().getURI());
        if (relativeURI.toString().equals("")) {
            relativeURI = URI.createURI((String)(String.valueOf(targetName) + ".ctx"));
        }
        File target = new File(directory, relativeURI.toString());
        this.copy(resource, target);
    }

    private void copy(InputStream source, File target) throws IOException {
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        FileWriter out = new FileWriter(target);
        try {
            int c;
            while ((c = source.read()) != -1) {
                out.write(c);
            }
        }
        finally {
            source.close();
            out.close();
        }
    }
}

