/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.runtime;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.DisplayUnit;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintEngine;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultConstraintEngine<E extends DisplayUnit>
implements ConstraintEngine<E> {
    protected final Set<Constraint> constraints = new LinkedHashSet<Constraint>();

    @Override
    public abstract void refresh();

    @Override
    public synchronized void addConstraint(ConstraintDescriptor descriptor) {
        Constraint constraint = ConstraintFactory.getInstance().createFromModel(descriptor);
        if (constraint != null) {
            this.constraints.add(constraint);
        }
    }

    @Override
    public synchronized Set<E> getDisplayUnits(ISelection forSelection) {
        HashSet result = new HashSet();
        if (!(forSelection instanceof IStructuredSelection)) {
            return result;
        }
        IStructuredSelection selection = (IStructuredSelection)forSelection;
        Set<Constraint> matchedConstraints = this.match(selection);
        return this.getDisplayUnits(matchedConstraints);
    }

    private Set<Constraint> match(IStructuredSelection selection) {
        LinkedHashSet<Constraint> matchedConstraints = new LinkedHashSet<Constraint>();
        if (selection.isEmpty()) {
            return matchedConstraints;
        }
        for (Constraint c : this.constraints) {
            if (!c.match(selection)) continue;
            matchedConstraints.add(c);
        }
        this.resolveConstraintConflicts(matchedConstraints);
        return matchedConstraints;
    }

    private void resolveConstraintConflicts(Set<Constraint> matchedConstraints) {
        HashSet<Constraint> constraintsSet = new HashSet<Constraint>(matchedConstraints);
        for (Constraint c : constraintsSet) {
            for (Constraint c2 : constraintsSet) {
                if (c == c2) continue;
                if (c.getDescriptor().getOverriddenConstraints().contains((Object)c2.getDescriptor())) {
                    matchedConstraints.remove(c2);
                    continue;
                }
                if (!c2.getDescriptor().isOverrideable() || !c.overrides(c2)) continue;
                matchedConstraints.remove(c2);
            }
        }
    }

    private Set<E> getDisplayUnits(Set<Constraint> matchedConstraints) {
        LinkedHashSet<DisplayUnit> displayUnits = new LinkedHashSet<DisplayUnit>();
        for (Constraint c : matchedConstraints) {
            displayUnits.add(c.getDescriptor().getDisplay());
        }
        return displayUnits;
    }
}

