/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.contentprovider.singlefolder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IAbstractPanelModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ITabFolderModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.singlefolder.SingleFolderModel;

public class SingleFolderContentProvider
implements ISashWindowsContentProvider,
IContentChangedProvider {
    private SingleFolderModel currentTabFolder;
    private ContentChangeListenerManager contentChangedListenerManager = new ContentChangeListenerManager();

    public SingleFolderContentProvider() {
        this.currentTabFolder = new SingleFolderModel(this);
    }

    public void addListener(IContentChangedListener listener) {
        this.contentChangedListenerManager.addContentChangedListener(listener);
    }

    public void removeListener(IContentChangedListener listener) {
        this.contentChangedListenerManager.removeContentChangedListener(listener);
    }

    protected void firePropertyChanged(IContentChangedListener.ContentEvent event) {
        this.contentChangedListenerManager.fireContentChanged(event);
    }

    public void addPage(Object newModel) {
        this.addPage((IPageModel)newModel);
    }

    public void addPage(Object newModel, int index) {
        this.addPage(index, (IPageModel)newModel);
    }

    public void addPage(IPageModel newModel) {
        this.currentTabFolder.addItem(newModel);
    }

    public void addPage(int index, IPageModel newModel) {
        this.currentTabFolder.addItem(index, newModel);
    }

    public void createFolder(ITabFolderModel tabFolder, int tabIndex, ITabFolderModel targetFolder, int side) {
    }

    public SingleFolderModel getRootModel() {
        return this.currentTabFolder;
    }

    public IAbstractPanelModel createChildSashModel(Object root) {
        return (IAbstractPanelModel)root;
    }

    public void removePage(Object page) {
        this.removePage((IPageModel)page);
    }

    public void removePage(int index) {
        this.currentTabFolder.removeTab(index);
    }

    public void removePage(IPageModel tabItem) {
        this.currentTabFolder.removeTab(tabItem);
    }

    public void removePage(ITabFolderModel parentFolder, int tabIndex) {
        this.removePage(tabIndex);
    }

    public ITabFolderModel getCurrentTabFolder() {
        return this.currentTabFolder;
    }

    public void setCurrentFolder(Object rawModel) {
    }

    public void movePage(ITabFolderModel folderModel, int oldIndex, int newIndex) {
        this.currentTabFolder.moveTab(oldIndex, newIndex);
    }

    public void movePage(ITabFolderModel srcFolderModel, int sourceIndex, ITabFolderModel targetFolderModel, int targetIndex) {
    }

    protected class ContentChangeListenerManager {
        private List<IContentChangedListener> listeners;

        protected ContentChangeListenerManager() {
        }

        public void addContentChangedListener(IContentChangedListener listener) {
            if (this.listeners == null) {
                this.createListeners();
            }
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }

        public void removeContentChangedListener(IContentChangedListener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(listener);
        }

        private void createListeners() {
            if (this.listeners == null) {
                this.listeners = new ArrayList<IContentChangedListener>();
            }
        }

        public void fireContentChanged(IContentChangedListener.ContentEvent event) {
            if (this.listeners == null) {
                return;
            }
            for (IContentChangedListener listener : this.listeners) {
                listener.contentChanged(event);
            }
        }
    }
}

