/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.contentoutline;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.contentoutline.IPapyrusContentOutlinePage;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageLifeCycleEventsListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedEditorDelegatedOutlinePage
extends Page
implements IPapyrusContentOutlinePage,
IPageLifeCycleEventsListener {
    private ISashWindowsContainer sashWindowsContainer;
    private PageBook sashEditorPageBook;
    private Map<IPage, OutlinePageRec> mapIPapyrusPageToOutlineRec = new HashMap<IPage, OutlinePageRec>();
    private OutlinePageRec activeRec;
    private OutlinePageRec defaultPageRec;

    @Override
    public void init(IMultiDiagramEditor multiEditor) {
        this.sashWindowsContainer = (ISashWindowsContainer)multiEditor.getAdapter(ISashWindowsContainer.class);
    }

    public void init(IPageSite pageSite) {
        IViewSite viewSite = NestedEditorDelegatedOutlinePage.getViewSite(pageSite);
        DelegatedPageSite delegatedPageSite = new DelegatedPageSite(viewSite, this);
        super.init((IPageSite)delegatedPageSite);
    }

    public void dispose() {
        this.activeRec = null;
        if (this.defaultPageRec != null) {
            this.defaultPageRec.contentOutlinePage.dispose();
            this.defaultPageRec.dispose();
            this.defaultPageRec = null;
        }
        ArrayList<OutlinePageRec> records = new ArrayList<OutlinePageRec>(this.mapIPapyrusPageToOutlineRec.values());
        for (OutlinePageRec rec : records) {
            this.removePage(rec);
        }
        this.sashWindowsContainer.removePageLifeCycleListener((IPageLifeCycleEventsListener)this);
        super.dispose();
    }

    protected void refreshGlobalActionHandlers() {
        SubActionBars bars = this.getSite().getActionBars();
        bars.clearGlobalActionHandlers();
        Map newActionHandlers = ((SubActionBars)this.activeRec.getPageSite().getActionBars()).getGlobalActionHandlers();
        if (newActionHandlers != null) {
            Set keys = newActionHandlers.entrySet();
            for (Map.Entry entry : keys) {
                bars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    public void createControl(Composite parent) {
        this.sashWindowsContainer.addPageLifeCycleListener((IPageLifeCycleEventsListener)this);
        this.sashEditorPageBook = new PageBook(parent, 2048);
        IContentOutlinePage defaultPage = this.createDefaultPage(this.sashEditorPageBook);
        this.defaultPageRec = new OutlinePageRec(null, defaultPage);
        this.preparePage(this.defaultPageRec);
        IPage activePage = this.sashWindowsContainer.getActiveSashWindowsPage();
        if (activePage != null) {
            OutlinePageRec rec = this.getOutlinePageRec(activePage);
            if (rec == null) {
                rec = this.createPage(activePage);
            }
            if (rec != null) {
                this.showOutlinePageRec(rec);
            } else {
                this.showOutlinePageRec(this.defaultPageRec);
            }
        } else {
            this.showOutlinePageRec(this.defaultPageRec);
        }
    }

    public Control getControl() {
        return this.sashEditorPageBook;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void pageChanged(IPage newPage) {
    }

    public void pageOpened(IPage page) {
        OutlinePageRec rec = this.getOutlinePageRec(page);
        if (rec == null) {
            rec = this.createPage(page);
        }
        if (rec != null) {
            this.showOutlinePageRec(rec);
        } else {
            this.showOutlinePageRec(this.defaultPageRec);
        }
    }

    public void pageClosed(IPage papyrusPage) {
        OutlinePageRec rec;
        if (this.activeRec != null && this.activeRec.papyrusPage == papyrusPage) {
            this.showOutlinePageRec(this.defaultPageRec);
        }
        if ((rec = this.getOutlinePageRec(papyrusPage)) != null) {
            this.removePage(rec);
        }
    }

    public void pageActivated(IPage page) {
        OutlinePageRec rec = this.getOutlinePageRec(page);
        if (rec == null) {
            rec = this.createPage(page);
        }
        if (rec != null) {
            this.showOutlinePageRec(rec);
        } else {
            this.showOutlinePageRec(this.defaultPageRec);
        }
    }

    public void pageDeactivated(IPage page) {
    }

    public void pageAboutToBeOpened(IPage page) {
    }

    public void pageAboutToBeClosed(IPage page) {
    }

    protected IContentOutlinePage createDefaultPage(PageBook book) {
        MessageOutlinePage page = new MessageOutlinePage();
        this.initPage(page);
        page.createControl((Composite)book);
        return page;
    }

    protected OutlinePageRec createPage(IPage papyrusPage) {
        OutlinePageRec rec = this.doCreatePage(papyrusPage);
        if (rec != null) {
            this.mapIPapyrusPageToOutlineRec.put(papyrusPage, rec);
            this.preparePage(rec);
        }
        return rec;
    }

    protected void preparePage(OutlinePageRec rec) {
        IPageSite site = null;
        if (!this.doesPageExist(rec.contentOutlinePage) && rec.contentOutlinePage instanceof IPageBookViewPage) {
            site = ((IPageBookViewPage)rec.contentOutlinePage).getSite();
            rec.setPageSite(site);
        }
    }

    protected void initPage(IPageBookViewPage page) {
        try {
            IPageSite site = super.getSite();
            page.init((IPageSite)new PageSite(NestedEditorDelegatedOutlinePage.getViewSite(site)));
        }
        catch (PartInitException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected static IViewSite getViewSite(IPageSite site) {
        if (site instanceof IViewSite) {
            return (IViewSite)site;
        }
        if (site instanceof PageSite) {
            try {
                Field parentSiteField = PageSite.class.getDeclaredField("parentSite");
                parentSiteField.setAccessible(true);
                Object parentSite = parentSiteField.get(site);
                if (parentSite instanceof IViewSite) {
                    return (IViewSite)parentSite;
                }
            }
            catch (SecurityException e) {
                Activator.log.error((Throwable)e);
            }
            catch (NoSuchFieldException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    protected OutlinePageRec doCreatePage(IPage papyrusPage) {
        IEditorPart part;
        Object obj;
        if (papyrusPage instanceof IEditorPage && (obj = NestedEditorDelegatedOutlinePage.getAdapter(part = ((IEditorPage)papyrusPage).getIEditorPart(), IContentOutlinePage.class, false)) instanceof IContentOutlinePage) {
            IContentOutlinePage page = (IContentOutlinePage)obj;
            if (page instanceof IPageBookViewPage) {
                this.initPage((IPageBookViewPage)page);
            }
            page.createControl((Composite)this.getPageBook());
            return new OutlinePageRec(papyrusPage, page);
        }
        return null;
    }

    public DelegatedPageSite getSite() {
        return (DelegatedPageSite)super.getSite();
    }

    protected void doDestroyPage(IPage papyrusPage, OutlinePageRec rec) {
        IContentOutlinePage contentOutlinePage = rec.contentOutlinePage;
        contentOutlinePage.dispose();
        rec.dispose();
    }

    protected Collection<OutlinePageRec> getAllPages() {
        return this.mapIPapyrusPageToOutlineRec.values();
    }

    protected boolean doesPageExist(IContentOutlinePage page) {
        return this.mapIPapyrusPageToOutlineRec.containsKey(page);
    }

    protected IPage getCurrentContributingPage() {
        if (this.activeRec == null) {
            return null;
        }
        return this.activeRec.papyrusPage;
    }

    public IContentOutlinePage getCurrentOutlinePage() {
        if (this.activeRec == null) {
            return null;
        }
        return this.activeRec.contentOutlinePage;
    }

    protected IPageSite getPageSite(IPage page) {
        OutlinePageRec rec = this.getOutlinePageRec(page);
        if (rec != null) {
            return rec.getPageSite();
        }
        return null;
    }

    public IContentOutlinePage getDefaultOutlinePage() {
        return this.defaultPageRec.contentOutlinePage;
    }

    protected PageBook getPageBook() {
        return this.sashEditorPageBook;
    }

    protected OutlinePageRec getOutlinePageRec(IPage papyrusPage) {
        return this.mapIPapyrusPageToOutlineRec.get(papyrusPage);
    }

    protected OutlinePageRec getPageRec(IContentOutlinePage contentOutlinePage) {
        for (OutlinePageRec rec : this.mapIPapyrusPageToOutlineRec.values()) {
            if (rec.contentOutlinePage != contentOutlinePage) continue;
            return rec;
        }
        return null;
    }

    protected void removePage(OutlinePageRec rec) {
        this.mapIPapyrusPageToOutlineRec.remove(rec.papyrusPage);
        Control control = rec.contentOutlinePage.getControl();
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
        this.doDestroyPage(rec.papyrusPage, rec);
        IPageSite site = rec.getPageSite();
        if (site instanceof PageSite) {
            ((SubActionBars)((PageSite)site).getActionBars()).deactivate();
            ((SubActionBars)((PageSite)site).getActionBars()).dispose();
        }
    }

    public void setFocus() {
        if (this.sashEditorPageBook != null) {
            this.sashEditorPageBook.setFocus();
        }
        if (this.activeRec != null) {
            this.activeRec.contentOutlinePage.setFocus();
        }
    }

    protected void showOutlinePageRec(OutlinePageRec pageRec) {
        if (this.activeRec == pageRec) {
            return;
        }
        if (this.activeRec != null && pageRec != null && this.activeRec.contentOutlinePage == pageRec.contentOutlinePage) {
            this.activeRec = pageRec;
            return;
        }
        this.activeRec = pageRec;
        Control pageControl = this.activeRec.contentOutlinePage.getControl();
        if (pageControl != null && !pageControl.isDisposed()) {
            PageSite pageSite = (PageSite)this.activeRec.getPageSite();
            this.sashEditorPageBook.showPage(pageControl);
            this.getSite().setActivePageSite(pageSite);
        }
    }

    public static Object getAdapter(Object sourceObject, Class<?> adapter, boolean activatePlugins) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull(adapter);
        if (sourceObject == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            Assert.isTrue((boolean)adapter.isInstance(result2));
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = activatePlugins ? Platform.getAdapterManager().loadAdapter(sourceObject, adapter.getName()) : Platform.getAdapterManager().getAdapter(sourceObject, adapter)) != null) {
            return result;
        }
        return null;
    }

    protected static class DelegatedPageSite
    extends PageSite {
        protected PageSite activePageSite;
        private NestedEditorDelegatedOutlinePage nestedEditorDelegatedOutlinePage;

        public DelegatedPageSite(IViewSite parentViewSite, NestedEditorDelegatedOutlinePage nestedEditorDelegatedOutlinePage) {
            super(parentViewSite);
            this.nestedEditorDelegatedOutlinePage = nestedEditorDelegatedOutlinePage;
        }

        public void setActivePageSite(PageSite activePageSite) {
            if (this.activePageSite != null) {
                this.getActionBars().deactivate();
                this.getActionBars().clearGlobalActionHandlers();
                this.getActionBars().updateActionBars();
                activePageSite.deactivate();
            }
            this.activePageSite = activePageSite;
            if (this.activePageSite != null) {
                activePageSite.activate();
                this.getActionBars().activate();
                this.getActionBars().updateActionBars();
            }
        }

        public PageSite getActivePageSite() {
            return this.activePageSite;
        }

        public SubActionBars getActionBars() {
            if (this.activePageSite != null) {
                return (SubActionBars)this.activePageSite.getActionBars();
            }
            return (SubActionBars)super.getActionBars();
        }

        public void deactivate() {
            if (this.activePageSite != null) {
                this.activePageSite.deactivate();
            }
            for (OutlinePageRec rec : this.nestedEditorDelegatedOutlinePage.getAllPages()) {
                IPageSite site = rec.getPageSite();
                IActionBars bars = site.getActionBars();
                if (!(bars instanceof SubActionBars)) continue;
                SubActionBars subActionBars = (SubActionBars)bars;
                subActionBars.deactivate();
                subActionBars.clearGlobalActionHandlers();
                subActionBars.updateActionBars();
            }
            super.deactivate();
        }

        public void activate() {
            for (OutlinePageRec rec : this.nestedEditorDelegatedOutlinePage.getAllPages()) {
                IPageSite site = rec.getPageSite();
                IActionBars bars = site.getActionBars();
                if (!(bars instanceof SubActionBars)) continue;
                SubActionBars subActionBars = (SubActionBars)bars;
                subActionBars.deactivate();
                subActionBars.clearGlobalActionHandlers();
                subActionBars.updateActionBars();
            }
            if (this.activePageSite != null) {
                this.activePageSite.activate();
                this.getActionBars().activate();
                this.getActionBars().updateActionBars();
            }
            super.activate();
        }
    }

    protected static class MessageOutlinePage
    implements IContentOutlinePage,
    IPageBookViewPage {
        private Text label;
        private IPageSite site;

        protected MessageOutlinePage() {
        }

        public void createControl(Composite parent) {
            this.label = new Text(parent, 0);
            this.label.setText("No outline for this editor");
        }

        public void dispose() {
            if (this.label != null && this.label.isDisposed()) {
                this.label.dispose();
                this.label = null;
            }
        }

        public Control getControl() {
            return this.label;
        }

        public void setActionBars(IActionBars actionBars) {
        }

        public void setFocus() {
            if (this.label != null && this.label.isDisposed()) {
                this.label.setFocus();
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return null;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }

        public IPageSite getSite() {
            return this.site;
        }

        public void init(IPageSite site) throws PartInitException {
            this.site = site;
        }
    }

    protected static class OutlinePageRec {
        public Object subActionBars;
        public IPage papyrusPage;
        public IContentOutlinePage contentOutlinePage;
        public IPageSite pageSite;

        public OutlinePageRec(IPage papyrusPage, IContentOutlinePage contentOutlinePage) {
            this.papyrusPage = papyrusPage;
            this.contentOutlinePage = contentOutlinePage;
        }

        public void setPageSite(IPageSite pageSite) {
            this.pageSite = pageSite;
        }

        public IPageSite getPageSite() {
            return this.pageSite;
        }

        public void dispose() {
            this.papyrusPage = null;
            this.contentOutlinePage = null;
            this.pageSite = null;
        }
    }
}

