/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.extension.ExtensionException;
import org.eclipse.papyrus.infra.core.extension.ExtensionUtils;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.IModelSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;

public class ModelsReader
extends ExtensionUtils {
    public static final String LOAD_AFTER_ELEMENT_NAME = "loadAfter";
    public static final String UNLOAD_BEFORE_ELEMENT_NAME = "unloadBefore";
    public static final String DEPENDENCY_ELEMENT_NAME = "dependency";
    public static final String EXTENSION_POINT_NAME = "model";
    public static final String MODEL_ELEMENT_NAME = "model";
    public static final String MODEL_SNIPPET_ELEMENT_NAME = "modelSnippet";
    public static final String MODEL_SET_SNIPPET_ELEMENT_NAME = "modelSetSnippet";
    private static final String CLASSNAME_ATTRIBUTE = "classname";
    public static final String IDENTIFIER_ATTRIBUTE_NAME = "identifier";
    protected String extensionPointNamespace;

    public ModelsReader() {
        this("org.eclipse.papyrus.infra.core");
    }

    public ModelsReader(String extensionPointNamespace) {
        this.extensionPointNamespace = extensionPointNamespace;
    }

    public void readModel(ModelSet modelSet) {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointNamespace, "model");
        this.addDeclaredModels(configElements, modelSet);
        this.addDeclaredModelSetSnippets(configElements, modelSet);
    }

    private void addDeclaredModels(IConfigurationElement[] configElements, ModelSet modelSet) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                if ("model".equals(ele.getName())) {
                    IModel model = this.instanciateModel(ele);
                    modelSet.registerModel(model);
                    this.addDeclaredModelSnippet(ele, model);
                    this.addDeclaredDependencies(ele, model);
                    Activator.log.debug("model loaded: '" + model.getClass().getName() + "'");
                }
            }
            catch (ExtensionException e) {
                Activator.log.error("Problems occur while instanciating model", (Throwable)e);
            }
            ++n2;
        }
    }

    private void addDeclaredModelSetSnippets(IConfigurationElement[] configElements, ModelSet modelSet) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                if (MODEL_SET_SNIPPET_ELEMENT_NAME.equals(ele.getName())) {
                    IModelSetSnippet snippet = this.instanciateModelSetSnippet(ele);
                    modelSet.addModelSetSnippet(snippet);
                    Activator.log.debug("modelSet snippet added: '" + ((Object)((Object)modelSet)).getClass().getName() + "().add(" + snippet.getClass().getName() + ")'");
                }
            }
            catch (ExtensionException e) {
                Activator.log.error("Problems occur while instanciating snippet", (Throwable)e);
            }
            ++n2;
        }
    }

    private IModel instanciateModel(IConfigurationElement ele) throws ExtensionException {
        IModel model;
        Class<?> modelInstance = this.parseClass(ele, CLASSNAME_ATTRIBUTE, "model");
        try {
            model = (IModel)modelInstance.newInstance();
        }
        catch (InstantiationException e) {
            throw new ExtensionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionException(e);
        }
        return model;
    }

    private IModelSnippet instanciateModelSnippet(IConfigurationElement ele) throws ExtensionException {
        IModelSnippet snippet;
        Class<?> modelInstance = this.parseClass(ele, CLASSNAME_ATTRIBUTE, MODEL_SNIPPET_ELEMENT_NAME);
        try {
            snippet = (IModelSnippet)modelInstance.newInstance();
        }
        catch (InstantiationException e) {
            throw new ExtensionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionException(e);
        }
        return snippet;
    }

    private IModelSetSnippet instanciateModelSetSnippet(IConfigurationElement ele) throws ExtensionException {
        IModelSetSnippet snippet;
        Class<?> modelInstance = this.parseClass(ele, CLASSNAME_ATTRIBUTE, MODEL_SET_SNIPPET_ELEMENT_NAME);
        try {
            snippet = (IModelSetSnippet)modelInstance.newInstance();
        }
        catch (InstantiationException e) {
            throw new ExtensionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExtensionException(e);
        }
        return snippet;
    }

    private void addDeclaredModelSnippet(IConfigurationElement parentElement, IModel model) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = parentElement.getChildren(MODEL_SNIPPET_ELEMENT_NAME);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                IModelSnippet snippet = this.instanciateModelSnippet(ele);
                model.addModelSnippet(snippet);
                Activator.log.debug("model snippet added: '" + model.getClass().getName() + "().add(" + snippet.getClass().getName() + ")'");
            }
            catch (ExtensionException e) {
                Activator.log.error("Problems occur while instanciating model snippet", (Throwable)e);
            }
            ++n2;
        }
    }

    protected void addDeclaredDependencies(IConfigurationElement modelConfigurationElement, IModel model) {
        IConfigurationElement[] dependencyElements = modelConfigurationElement.getChildren(DEPENDENCY_ELEMENT_NAME);
        ArrayList<String> afterLoadModelIdentifiers = null;
        ArrayList<String> unloadBeforeModelIdentifiers = null;
        IConfigurationElement[] iConfigurationElementArray = dependencyElements;
        int n = dependencyElements.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier;
            IConfigurationElement dependencyElement = iConfigurationElementArray[n2];
            IConfigurationElement[] loadAfterElements = dependencyElement.getChildren(LOAD_AFTER_ELEMENT_NAME);
            IConfigurationElement[] unloadBeforeElements = dependencyElement.getChildren(UNLOAD_BEFORE_ELEMENT_NAME);
            IConfigurationElement[] iConfigurationElementArray2 = loadAfterElements;
            int n3 = loadAfterElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement loadAfterElement = iConfigurationElementArray2[n4];
                identifier = loadAfterElement.getAttribute(IDENTIFIER_ATTRIBUTE_NAME);
                if (identifier != null && identifier.length() > 0) {
                    if (afterLoadModelIdentifiers == null) {
                        afterLoadModelIdentifiers = new ArrayList<String>();
                    }
                    afterLoadModelIdentifiers.add(identifier);
                }
                ++n4;
            }
            iConfigurationElementArray2 = unloadBeforeElements;
            n3 = unloadBeforeElements.length;
            n4 = 0;
            while (n4 < n3) {
                IConfigurationElement unloadBeforeElement = iConfigurationElementArray2[n4];
                identifier = unloadBeforeElement.getAttribute(IDENTIFIER_ATTRIBUTE_NAME);
                if (identifier != null && identifier.length() > 0) {
                    if (unloadBeforeModelIdentifiers == null) {
                        unloadBeforeModelIdentifiers = new ArrayList<String>();
                    }
                    unloadBeforeModelIdentifiers.add(identifier);
                }
                ++n4;
            }
            ++n2;
        }
        model.setAfterLoadModelDependencies(afterLoadModelIdentifiers);
        model.setBeforeUnloadDependencies(unloadBeforeModelIdentifiers);
    }
}

