/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.core.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.core.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.infra.core.lifecycleevents.ISaveEventListener;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUpdateService
implements IService,
IPartListener {
    protected ServicesRegistry registry;
    protected ModelSet modelSet;
    static int[] handledTypes = new int[]{1, 4, 2};
    protected boolean isSaving;
    Runnable postSaveRunnable = new Runnable(){

        public void run() {
            ResourceUpdateService.this.isSaving = false;
        }
    };
    private final ISaveEventListener preSaveListener = new ISaveEventListener(){

        public void doSaveAs(DoSaveEvent event) {
            ResourceUpdateService.this.isSaving = true;
        }

        public void doSave(DoSaveEvent event) {
            ResourceUpdateService.this.isSaving = true;
        }
    };
    private final ISaveEventListener postSaveListener = new ISaveEventListener(){

        public void doSaveAs(DoSaveEvent event) {
            Display.getDefault().asyncExec(ResourceUpdateService.this.postSaveRunnable);
        }

        public void doSave(DoSaveEvent event) {
            Display.getDefault().asyncExec(ResourceUpdateService.this.postSaveRunnable);
        }
    };
    protected static final int CLOSE_WITHOUT_SAVE = 0;
    protected static final int SAVE_AND_CLOSE = 1;
    protected static final int IGNORE = 2;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected Collection<Resource> changedResources = new ArrayList<Resource>();
                    protected Collection<Resource> removedResources = new ArrayList<Resource>();

                    ResourceDeltaVisitor() {
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            if (delta.getKind() == 2 || delta.getKind() == 4) {
                                URI resourceURI = URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true);
                                Resource resource = (this).ResourceUpdateService.this.modelSet.getResource(resourceURI, false);
                                if (resource == null) {
                                    URI pluginURI = URI.createPlatformPluginURI((String)delta.getFullPath().toString(), (boolean)true);
                                    resource = (this).ResourceUpdateService.this.modelSet.getResource(pluginURI, false);
                                }
                                if (resource != null) {
                                    if (delta.getKind() == 2) {
                                        this.removedResources.add(resource);
                                    } else {
                                        delta.getFlags();
                                        if ((delta.getFlags() & 0x100) != 0 && !(this).ResourceUpdateService.this.isSaving) {
                                            this.changedResources.add(resource);
                                        }
                                    }
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    ResourceUpdateService.this.handleResourcesRemoved(visitor.getRemovedResources());
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    ResourceUpdateService.this.handleResourceChanged(visitor.getChangedResources());
                }
            }
            catch (CoreException exception) {
                Activator.log.error((Throwable)exception);
            }
        }
    };

    @Override
    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    @Override
    public void startService() throws ServiceException {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        this.modelSet = this.registry.getService(ModelSet.class);
        this.registry.getService(ILifeCycleEventsProvider.class).addAboutToDoSaveListener(this.preSaveListener);
        this.registry.getService(ILifeCycleEventsProvider.class).addPostDoSaveListener(this.postSaveListener);
    }

    @Override
    public void disposeService() throws ServiceException {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.modelSet = null;
    }

    protected void closeEditor() {
        this.closeEditor(false, false);
    }

    protected void closeEditor(final boolean save, final boolean reopen) {
        try {
            final IMultiDiagramEditor editor = this.registry.getService(IMultiDiagramEditor.class);
            if (editor != null) {
                Runnable closeEditorRunnable = new Runnable(){

                    public void run() {
                        if (!PlatformUI.isWorkbenchRunning()) {
                            return;
                        }
                        final IWorkbenchPage page = editor.getSite().getPage();
                        final IEditorInput currentInput = editor.getEditorInput();
                        final String editorId = editor.getSite().getId();
                        if (save) {
                            editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                        page.closeEditor((IEditorPart)editor, save);
                        if (reopen) {
                            Display.getCurrent().asyncExec(new Runnable(){

                                public void run() {
                                    if (!PlatformUI.isWorkbenchRunning()) {
                                        return;
                                    }
                                    try {
                                        IDE.openEditor((IWorkbenchPage)page, (IEditorInput)currentInput, (String)editorId);
                                    }
                                    catch (PartInitException ex) {
                                        Activator.log.error((Throwable)ex);
                                    }
                                }
                            });
                        }
                    }
                };
                editor.getSite().getShell().getDisplay().asyncExec(closeEditorRunnable);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    protected void handleResourcesRemoved(Collection<Resource> emfResources) {
        try {
            if (!this.registry.getService(ISaveAndDirtyService.class).isDirty()) {
                this.closeEditor();
                return;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (this.isAllReadOnly(emfResources)) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Shell parentShell = Display.getCurrent().getActiveShell();
                    MessageDialog dialog = new MessageDialog(parentShell, "Resources changed", null, "Some resources used by '" + ResourceUpdateService.this.modelSet.getURIWithoutExtension().lastSegment() + "' have been removed. Note: all these resources are loaded in read-only mode and won't be overriden if you choose to save. Unsaved changes will be lost.", 3, new String[]{"Close editor", "Save and close", "Ignore"}, 1);
                    switch (dialog.open()) {
                        case 0: {
                            ResourceUpdateService.this.closeEditor(false, false);
                            break;
                        }
                        case 1: {
                            ResourceUpdateService.this.closeEditor(true, false);
                            break;
                        }
                    }
                }
            });
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Resources removed", (String)("Some resources used by '" + ResourceUpdateService.this.modelSet.getURIWithoutExtension().lastSegment() + "' have been removed. Do you wish to close the current editor? Unsaved changes will be lost."))) {
                        ResourceUpdateService.this.closeEditor();
                    }
                }
            });
        }
    }

    protected boolean isAllReadOnly(Collection<Resource> resources) {
        for (Resource resource : resources) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)resource);
            if (domain == null) {
                return false;
            }
            if (domain.isReadOnly(resource)) continue;
            return false;
        }
        return true;
    }

    protected void handleResourceChanged(Collection<Resource> emfResources) {
        try {
            if (!this.registry.getService(ISaveAndDirtyService.class).isDirty()) {
                this.closeEditor(false, true);
                return;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        boolean allReadOnly = this.isAllReadOnly(emfResources);
        if (allReadOnly) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Shell parentShell = Display.getCurrent().getActiveShell();
                    MessageDialog dialog = new MessageDialog(parentShell, "Resources changed", null, "Some resources used by '" + ResourceUpdateService.this.modelSet.getURIWithoutExtension().lastSegment() + "' have changed. Note: all these resources are loaded in read-only mode and won't be overriden if you choose to save. Unsaved changes will be lost.", 4, new String[]{"Reopen editor", "Save and reopen", "Ignore"}, 1);
                    switch (dialog.open()) {
                        case 0: {
                            ResourceUpdateService.this.closeEditor(false, true);
                            break;
                        }
                        case 1: {
                            ResourceUpdateService.this.closeEditor(true, true);
                            break;
                        }
                    }
                }
            });
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Shell parentShell = Display.getCurrent().getActiveShell();
                    if (MessageDialog.openConfirm((Shell)parentShell, (String)"Resources changed", (String)("Some resources used by the model '" + ResourceUpdateService.this.modelSet.getURIWithoutExtension().lastSegment() + "' have changed. Do you want to reopen the current editor? Unsaved changes will be lost."))) {
                        ResourceUpdateService.this.closeEditor(false, true);
                    }
                }
            });
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

