/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import com.google.common.base.Optional;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.readonly.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.emf.readonly.Activator;
import org.eclipse.papyrus.infra.emf.readonly.IReadOnlyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyManager
implements org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler {
    protected static Map<EditingDomain, org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler> roHandlers = new HashMap<EditingDomain, org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler>();
    protected static final Class<?>[] orderedHandlerClassesArray;
    protected org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler[] orderedHandlersArray;

    static {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.emf.readonly", "readOnlyHandler");
        LinkedList<HandlerPriorityPair> handlerPriorityPairs = new LinkedList<HandlerPriorityPair>();
        HashMap<String, HandlerPriorityPair> idMap = new HashMap<String, HandlerPriorityPair>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if ("readOnlyHandler".equals(elem.getName())) {
                try {
                    HandlerPriorityPair handlerPriorityPair = new HandlerPriorityPair();
                    String className = elem.getAttribute("class");
                    handlerPriorityPair.handlerClass = Platform.getBundle((String)elem.getContributor().getName()).loadClass(className);
                    handlerPriorityPair.priority = Integer.parseInt(elem.getAttribute("priority"));
                    String id = elem.getAttribute("id");
                    if (id != null) {
                        HandlerPriorityPair oldHandler = (HandlerPriorityPair)idMap.get(id);
                        if (oldHandler == null) {
                            idMap.put(id, handlerPriorityPair);
                            handlerPriorityPairs.add(handlerPriorityPair);
                        } else if (oldHandler.priority < handlerPriorityPair.priority) {
                            handlerPriorityPairs.remove(oldHandler);
                            handlerPriorityPairs.add(handlerPriorityPair);
                        }
                    } else {
                        handlerPriorityPairs.add(handlerPriorityPair);
                    }
                }
                catch (Throwable t) {
                    Activator.log.error(t);
                }
            }
            ++n2;
        }
        Collections.sort(handlerPriorityPairs);
        orderedHandlerClassesArray = new Class[handlerPriorityPairs.size()];
        int i = 0;
        while (i < orderedHandlerClassesArray.length) {
            ReadOnlyManager.orderedHandlerClassesArray[i] = ((HandlerPriorityPair)handlerPriorityPairs.get((int)i)).handlerClass;
            ++i;
        }
    }

    public static org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler getReadOnlyHandler(EditingDomain editingDomain) {
        org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler roHandler = roHandlers.get(editingDomain);
        if (roHandler == null) {
            roHandler = new ReadOnlyManager(editingDomain);
            roHandlers.put(editingDomain, roHandler);
        }
        return roHandler;
    }

    protected static org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler create(Class<?> handlerClass, EditingDomain editingDomain) {
        boolean isEditingDomainConstructor = true;
        Constructor<?> constructor = null;
        try {
            constructor = handlerClass.getConstructor(EditingDomain.class);
            if (constructor == null) {
                isEditingDomainConstructor = false;
                constructor = handlerClass.getConstructor(new Class[0]);
            }
            if (org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler.class.isAssignableFrom(constructor.getDeclaringClass())) {
                if (isEditingDomainConstructor) {
                    return (org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler)constructor.newInstance(editingDomain);
                }
                return (org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler)constructor.newInstance(new Object[0]);
            }
            if (IReadOnlyHandler.class.isAssignableFrom(constructor.getDeclaringClass())) {
                return new HandlerAdapter((IReadOnlyHandler)constructor.newInstance(new Object[0]), editingDomain);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ReadOnlyManager(EditingDomain editingDomain) {
        ArrayList<org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler> handlers = new ArrayList<org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler>();
        Class<?>[] classArray = orderedHandlerClassesArray;
        int n = orderedHandlerClassesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> roClass = classArray[n2];
            org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler h = ReadOnlyManager.create(roClass, editingDomain);
            if (h != null) {
                handlers.add(h);
            }
            ++n2;
        }
        this.orderedHandlersArray = handlers.toArray(new org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler[handlers.size()]);
    }

    public Optional<Boolean> anyReadOnly(URI[] uris) {
        Optional result = Optional.absent();
        int i = 0;
        while (i < this.orderedHandlersArray.length && !result.isPresent()) {
            result = this.orderedHandlersArray[i].anyReadOnly(uris);
            ++i;
        }
        return result.isPresent() ? result : Optional.of((Object)Boolean.FALSE);
    }

    public Optional<Boolean> isReadOnly(EObject eObject) {
        Optional result = Optional.absent();
        int i = 0;
        while (i < this.orderedHandlersArray.length && !result.isPresent()) {
            result = this.orderedHandlersArray[i].isReadOnly(eObject);
            ++i;
        }
        return result.isPresent() ? result : Optional.of((Object)Boolean.FALSE);
    }

    public Optional<Boolean> makeWritable(URI[] uris) {
        Boolean finalResult = true;
        int i = 0;
        while (i < this.orderedHandlersArray.length) {
            Optional result;
            Optional isRO = this.orderedHandlersArray[i].anyReadOnly(uris);
            if (isRO.isPresent() && ((Boolean)isRO.get()).booleanValue() && (!(result = this.orderedHandlersArray[i].makeWritable(uris)).isPresent() || !((Boolean)result.get()).booleanValue())) {
                finalResult = false;
            }
            ++i;
        }
        return Optional.of((Object)finalResult);
    }

    public Optional<Boolean> makeWritable(EObject eObject) {
        Boolean finalResult = true;
        int i = 0;
        while (i < this.orderedHandlersArray.length) {
            Optional result;
            Optional isRO = this.orderedHandlersArray[i].isReadOnly(eObject);
            if (isRO.isPresent() && ((Boolean)isRO.get()).booleanValue() && (result = this.orderedHandlersArray[i].makeWritable(eObject)).isPresent() && !((Boolean)result.get()).booleanValue()) {
                finalResult = false;
            }
            ++i;
        }
        return Optional.of((Object)finalResult);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HandlerAdapter
    extends AbstractReadOnlyHandler {
        private final IReadOnlyHandler delegate;

        HandlerAdapter(IReadOnlyHandler handler, EditingDomain editingDomain) {
            super(editingDomain);
            this.delegate = handler;
        }

        public Optional<Boolean> anyReadOnly(URI[] uris) {
            boolean delegateResult = this.delegate.isReadOnly(uris, this.getEditingDomain());
            return delegateResult ? Optional.of((Object)Boolean.TRUE) : Optional.absent();
        }

        public Optional<Boolean> makeWritable(URI[] uris) {
            boolean delegateResult = this.delegate.enableWrite(uris, this.getEditingDomain());
            return delegateResult ? Optional.absent() : Optional.of((Object)Boolean.FALSE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HandlerPriorityPair
    implements Comparable<HandlerPriorityPair> {
        public Class<?> handlerClass;
        public int priority;

        protected HandlerPriorityPair() {
        }

        @Override
        public int compareTo(HandlerPriorityPair o) {
            if (o.priority > this.priority) {
                return 1;
            }
            if (o.priority < this.priority) {
                return -1;
            }
            return 0;
        }
    }
}

