/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.commands;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveFromResourcecommand
extends RecordingCommand {
    private final Resource resource;
    private final EObject toRemove;
    private final Collection<EObject> elementsToRemove;

    public RemoveFromResourcecommand(TransactionalEditingDomain domain, Resource resource, EObject toRemove) {
        this(domain, resource, toRemove, null);
    }

    public RemoveFromResourcecommand(TransactionalEditingDomain domain, Resource resource, Collection<EObject> elementsToRemove) {
        this(domain, resource, null, elementsToRemove);
    }

    protected RemoveFromResourcecommand(TransactionalEditingDomain domain, Resource resource, EObject toRemove, Collection<EObject> elementsToRemove) {
        super(domain, "Remove an EObject from a resource");
        this.resource = resource;
        this.toRemove = toRemove;
        this.elementsToRemove = elementsToRemove;
    }

    protected void doExecute() {
        try {
            if (this.toRemove != null) {
                this.resource.getContents().remove((Object)this.toRemove);
            }
            if (this.elementsToRemove != null) {
                this.resource.getContents().removeAll(this.elementsToRemove);
            }
        }
        catch (Exception e) {
            int i = 0;
            ++i;
        }
    }

    public boolean canExecute() {
        boolean result = super.canExecute();
        if (this.toRemove == null && this.elementsToRemove == null) {
            return false;
        }
        return result;
    }
}

