/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.BorderedScalableImageFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ScalableCompartmentFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.ShapeFlowLayout;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SubCompartmentLayoutManager;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.NotificationManager;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ShapeService;

public class ShapeDisplayCompartmentEditPart
extends ResizableCompartmentEditPart {
    public static final String COMPARTMENT_NAME = "symbol";

    public ShapeDisplayCompartmentEditPart(EObject model) {
        super(model);
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("shape_refresh_edit_policy", (EditPolicy)new ShapeRefreshEditPolicy());
    }

    public String getCompartmentName() {
        return COMPARTMENT_NAME;
    }

    public IFigure createFigure() {
        ScalableCompartmentFigure result = new ScalableCompartmentFigure(this.getCompartmentName(), this.getMapMode());
        ShapeCompartmentLayoutManager layoutManager = new ShapeCompartmentLayoutManager();
        result.setLayoutManager((LayoutManager)layoutManager);
        ShapeFlowLayout layout = new ShapeFlowLayout();
        result.getContentPane().setLayoutManager((LayoutManager)layout);
        return result;
    }

    protected void refreshShapes(IFigure contentPane) {
        ArrayList children = new ArrayList(contentPane.getChildren());
        for (Object child : children) {
            if (!(child instanceof IFigure)) continue;
            contentPane.remove((IFigure)child);
        }
        List<RenderedImage> shapesToDisplay = ShapeService.getInstance().getShapesToDisplay(this.getNotationView().eContainer());
        if (shapesToDisplay != null && !shapesToDisplay.isEmpty()) {
            for (RenderedImage image : shapesToDisplay) {
                if (image != null) {
                    BorderedScalableImageFigure imageFigure = new BorderedScalableImageFigure(image, false, false, true);
                    imageFigure.setOpaque(false);
                    imageFigure.setVisible(true);
                    contentPane.add((IFigure)imageFigure);
                    continue;
                }
                Activator.log.debug("No image will be drawn");
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    public boolean isSelectable() {
        return false;
    }

    public class ShapeCompartmentLayoutManager
    extends SubCompartmentLayoutManager {
        public static final int MIN_PREFERRED_SIZE = 40;

        public void layout(IFigure container) {
            super.layout(container);
        }

        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            Dimension dim = super.calculatePreferredSize(figure, wHint, hHint);
            dim.height = Math.max(40, dim.height);
            return dim;
        }
    }

    public class ShapeRefreshEditPolicy
    extends GraphicalEditPolicyEx
    implements NotificationListener {
        public static final String SHAPE_REFRESH_EDIT_POLICY_ROLE = "shape_refresh_edit_policy";
        protected NotificationManager notificationManager;

        public void activate() {
            super.activate();
            View view = this.getView();
            if (view == null) {
                return;
            }
            this.notificationManager = ShapeService.getInstance().createNotificationManager(this.getDiagramEventBroker(), view.eContainer(), this);
        }

        public void deactivate() {
            View view = this.getView();
            if (view == null) {
                return;
            }
            this.notificationManager.dispose();
            this.notificationManager = null;
            super.deactivate();
        }

        public void refresh() {
            super.refresh();
            ShapeDisplayCompartmentEditPart.this.refreshShapes(ShapeDisplayCompartmentEditPart.this.getContentPane());
        }

        public void notifyChanged(Notification notification) {
            this.refresh();
        }

        protected DiagramEventBroker getDiagramEventBroker() {
            TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            if (theEditingDomain != null) {
                return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
            }
            return null;
        }

        protected View getView() {
            return (View)this.getHost().getModel();
        }
    }
}

