/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class DefaultSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String GRAPHICAL_RECONNECTED_EDGE = "graphical_edge";

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            request.getExtendedData().put(GRAPHICAL_RECONNECTED_EDGE, (View)view);
        }
        return super.getCommand(request);
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        if (completedRequest instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)completedRequest;
            return this.shouldProceed(destroyRequest) ? semanticCommand : null;
        }
        return semanticCommand;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return this.getDefaultSemanticCommand((IEditCommandRequest)req, req.getElementType());
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        return this.getDefaultSemanticCommand((IEditCommandRequest)req);
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return this.getDefaultSemanticCommand((IEditCommandRequest)req);
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return this.getDefaultSemanticCommand((IEditCommandRequest)req);
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((Object)req.getRelationship());
        if (commandService == null) {
            return UnexecutableCommand.INSTANCE;
        }
        View newView = (View)this.getHost().getModel();
        req.setParameter("RECONNECT_END_VIEW", (Object)newView);
        ICommand semanticCommand = commandService.getEditCommand((IEditCommandRequest)req);
        if (semanticCommand != null && semanticCommand.canExecute()) {
            return this.getGEFWrapper(semanticCommand);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return new ICommandProxy(cmd);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    private Command getDefaultSemanticCommand(IEditCommandRequest req) {
        return this.getDefaultSemanticCommand(req, null);
    }

    private Command getDefaultSemanticCommand(IEditCommandRequest req, Object context) {
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((Object)((IGraphicalEditPart)this.getHost()).resolveSemanticElement());
        if (context != null) {
            commandService = ElementEditServiceUtils.getCommandProvider((Object)context);
        }
        if (commandService == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand semanticCommand = commandService.getEditCommand(req);
        if (semanticCommand != null && semanticCommand.canExecute()) {
            return this.getGEFWrapper(semanticCommand);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

