/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.snap;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.copy.ConnectionEndpointTracker;

public class PapyrusConnectionEndpointTracker
extends ConnectionEndpointTracker
implements DragTracker {
    public PapyrusConnectionEndpointTracker(ConnectionEditPart cep) {
        super(cep);
    }

    protected void updateTargetRequest() {
        ReconnectRequest request = (ReconnectRequest)this.getTargetRequest();
        Point originalLocation = null;
        if (originalLocation == null) {
            originalLocation = this.getStartLocation().getCopy();
        }
        Dimension delta = this.getDragMoveDelta();
        if (this.getCurrentInput().isShiftKeyDown()) {
            float ratio = 0.0f;
            if (delta.width != 0) {
                ratio = (float)delta.height / (float)delta.width;
            }
            if ((double)(ratio = Math.abs(ratio)) > 0.5 && (double)ratio < 1.5) {
                if (Math.abs(delta.height) > Math.abs(delta.width)) {
                    delta.height = delta.height > 0 ? Math.abs(delta.width) : -Math.abs(delta.width);
                } else {
                    delta.width = delta.width > 0 ? Math.abs(delta.height) : -Math.abs(delta.height);
                }
            } else if (Math.abs(delta.width) > Math.abs(delta.height)) {
                delta.height = 0;
            } else {
                delta.width = 0;
            }
        }
        Point moveDelta = new Point(delta.width, delta.height);
        SnapToHelper snapToHelper = (SnapToHelper)this.getConnectionEditPart().getAdapter(SnapToHelper.class);
        Rectangle rect = new Rectangle(originalLocation.x, originalLocation.y, 1, 1);
        PrecisionRectangle sourceRectangle = null;
        if (sourceRectangle == null) {
            sourceRectangle = new PrecisionRectangle(rect);
        }
        if (snapToHelper != null && !this.getCurrentInput().isModKeyDown(MODIFIER_NO_SNAPPING)) {
            PrecisionRectangle baseRect = sourceRectangle.getPreciseCopy();
            baseRect.translate(moveDelta);
            PrecisionPoint preciseDelta = new PrecisionPoint(moveDelta);
            snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
            Point newLocation = originalLocation.getCopy().translate((Point)preciseDelta);
            request.setLocation(newLocation);
        } else {
            request.setLocation(this.getLocation());
        }
    }
}

