/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.types;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.tools.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotationTypesMap {
    public static final NotationTypesMap instance = new NotationTypesMap();
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.common.notationTypesMapping";
    public static final String DIAGRAM_CATEGORY = "diagramMappings";
    public static final String ALL_DIAGRAMS = "Papyrus.AllDiagrams";
    public static final String MAPPING = "mapping";
    private final Map<String, TypeMap> typeMaps = new HashMap<String, TypeMap>();

    private NotationTypesMap() {
        this.readExtensionPoint();
    }

    private void readExtensionPoint() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement diagramMappingsDefinition = iConfigurationElementArray[n2];
            if (DIAGRAM_CATEGORY.equals(diagramMappingsDefinition.getName())) {
                String diagramID = diagramMappingsDefinition.getAttribute("diagramID");
                TypeMap typeMap = this.getOrCreateTypeMap(diagramID);
                IConfigurationElement[] iConfigurationElementArray2 = diagramMappingsDefinition.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement mappingDefinition = iConfigurationElementArray2[n4];
                    String notationType = mappingDefinition.getAttribute("type");
                    String humanReadableType = StringHelper.toJavaIdentifier((String)mappingDefinition.getAttribute("humanReadableType"));
                    if (notationType == null || humanReadableType == null) {
                        Activator.log.warn(String.format("Plug-in %s contributed an invalid extension for Notation Type Mappings", mappingDefinition.getContributor().getName()));
                    } else {
                        typeMap.getComputerToHumanTypeMapping().put(notationType, humanReadableType);
                        typeMap.getHumanToComputerTypeMapping().put(humanReadableType, notationType);
                    }
                    ++n4;
                }
            } else if (MAPPING.equals(diagramMappingsDefinition.getName())) {
                TypeMap typeMap = TypeMap.defaultMap;
                String notationType = diagramMappingsDefinition.getAttribute("type");
                String humanReadableType = StringHelper.toJavaIdentifier((String)diagramMappingsDefinition.getAttribute("humanReadableType"));
                if (notationType == null || humanReadableType == null) {
                    Activator.log.warn(String.format("Plug-in %s contributed an invalid extension for Notation Type Mappings", diagramMappingsDefinition.getContributor().getName()));
                } else {
                    typeMap.getComputerToHumanTypeMapping().put(notationType, humanReadableType);
                    typeMap.getHumanToComputerTypeMapping().put(humanReadableType, notationType);
                }
            }
            ++n2;
        }
    }

    private TypeMap getTypeMap(String diagramID) {
        if (this.typeMaps.containsKey(diagramID)) {
            return this.typeMaps.get(diagramID);
        }
        return TypeMap.defaultMap;
    }

    private TypeMap getTypeMap(View view) {
        if (view.getDiagram() == null) {
            return TypeMap.defaultMap;
        }
        return this.getTypeMap(view.getDiagram().getType());
    }

    private TypeMap getOrCreateTypeMap(String diagramID) {
        if (!this.typeMaps.containsKey(diagramID)) {
            TypeMap typeMap = new TypeMap();
            this.typeMaps.put(diagramID, typeMap);
        }
        return this.typeMaps.get(diagramID);
    }

    public String getNotationType(String humanReadableType, String diagramID) {
        return this.getTypeMap(diagramID).getNotationType(humanReadableType);
    }

    public String getHumanReadableType(String notationType, String diagramID) {
        return this.getTypeMap(diagramID).getHumanReadableType(notationType);
    }

    public Map<String, String> getComputerToHumanTypeMapping(String diagramID) {
        return this.getTypeMap(diagramID).getComputerToHumanTypeMapping();
    }

    public Map<String, String> getHumanToComputerTypeMapping(String diagramID) {
        return this.getTypeMap(diagramID).getHumanToComputerTypeMapping();
    }

    public String getNotationType(View view) {
        if (view == null) {
            return null;
        }
        return this.getTypeMap(view).getNotationType(view.getType());
    }

    public String getHumanReadableType(View view) {
        if (view == null) {
            return null;
        }
        return this.getTypeMap(view).getHumanReadableType(view.getType());
    }

    public Map<String, String> getComputerToHumanTypeMapping(Diagram diagram) {
        if (diagram == null) {
            return TypeMap.defaultMap.getComputerToHumanTypeMapping();
        }
        return this.getComputerToHumanTypeMapping(diagram.getType());
    }

    public Map<String, String> getHumanToComputerTypeMapping(Diagram diagram) {
        if (diagram == null) {
            return TypeMap.defaultMap.getHumanToComputerTypeMapping();
        }
        return this.getHumanToComputerTypeMapping(diagram.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeMap {
        public static final TypeMap defaultMap = new TypeMap();
        private final Map<String, String> computerToHumanTypeMapping = new HashMap<String, String>();
        private final Map<String, String> humanToComputerTypeMapping = new HashMap<String, String>();

        private TypeMap() {
        }

        public String getNotationType(String humanReadableType) {
            if (this.humanToComputerTypeMapping.containsKey(humanReadableType) || defaultMap == this) {
                return this.humanToComputerTypeMapping.get(humanReadableType);
            }
            return defaultMap.getNotationType(humanReadableType);
        }

        public String getHumanReadableType(String notationType) {
            if (this.computerToHumanTypeMapping.containsKey(notationType) || defaultMap == this) {
                return this.computerToHumanTypeMapping.get(notationType);
            }
            return defaultMap.getHumanReadableType(notationType);
        }

        public Map<String, String> getComputerToHumanTypeMapping() {
            return this.computerToHumanTypeMapping;
        }

        public Map<String, String> getHumanToComputerTypeMapping() {
            return this.humanToComputerTypeMapping;
        }
    }
}

