/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.tools.util.EditorHelper;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEditPartsUtil {
    private DiagramEditPartsUtil() {
    }

    public static EditPart getEditPartFromView(View view, EditPart anyEditPart) {
        if (view != null && anyEditPart != null) {
            return (EditPart)anyEditPart.getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart instanceof IGraphicalEditPart) {
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart;
            View view = graphicalEditPart.getNotationView();
            Diagram diagram = view.getDiagram();
            Object object = graphicalEditPart.getViewer().getEditPartRegistry().get(diagram);
            if (object instanceof DiagramEditPart) {
                return (DiagramEditPart)object;
            }
        }
        if (editPart instanceof DiagramEditPart) {
            return (DiagramEditPart)editPart;
        }
        EditPart actual = editPart;
        EditPart parent = null;
        while ((parent = actual.getParent()) != null) {
            if (parent instanceof DiagramEditPart) {
                return (DiagramEditPart)parent;
            }
            actual = parent;
        }
        return null;
    }

    public static Collection<EditPart> getAllTopSemanticEditPart(EditPart ep) {
        HashSet<EditPart> editparts = new HashSet<EditPart>();
        for (Object current : ep.getChildren()) {
            if (!(current instanceof EditPart)) continue;
            editparts.addAll(DiagramEditPartsUtil.getAllTopSemanticEditPart((EditPart)current));
            EditPart topEP = DiagramEditPartsUtil.getTopSemanticEditPart((EditPart)current);
            if (topEP == null) continue;
            editparts.add(topEP);
        }
        return editparts;
    }

    public static final EditPart getTopSemanticEditPart(EditPart ep) {
        EObject currentEObject = (EObject)ep.getAdapter(EObject.class);
        if (currentEObject != null) {
            EditPart previousParent = ep;
            EditPart parent = ep;
            while (parent != null) {
                if (parent.getAdapter(EObject.class) != currentEObject || parent instanceof DiagramEditPart) {
                    return previousParent;
                }
                previousParent = parent;
                parent = parent.getParent();
            }
            return previousParent;
        }
        return null;
    }

    public static final IDiagramGraphicalViewer getActiveDiagramGraphicalViewer() {
        IDiagramWorkbenchPart part = DiagramEditPartsUtil.getActiveDiagramWorkbenchPart();
        return part != null ? part.getDiagramGraphicalViewer() : null;
    }

    public static final IDiagramWorkbenchPart getActiveDiagramWorkbenchPart() {
        IDiagramWorkbenchPart diagramPart = null;
        IWorkbenchPart part = EditorHelper.getActivePart();
        if (part instanceof IDiagramWorkbenchPart) {
            diagramPart = (IDiagramWorkbenchPart)part;
        } else if (part != null) {
            diagramPart = (IDiagramWorkbenchPart)part.getAdapter(IDiagramWorkbenchPart.class);
        }
        return diagramPart;
    }

    public static final IPreferenceStore getDiagramWorkspacePreferenceStore(EditPart anEditPart) {
        EditPartViewer viewer = anEditPart.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            return ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore();
        }
        return null;
    }
}

