/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.outline;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.outline.DiagramOrientedContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.outline.internal.Activator;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;

public class DiagramNavigator
extends Composite {
    private TreeViewer viewer;
    ICreationCommandRegistry creationCommandRegistry;
    private final ServicesRegistry registry;

    public DiagramNavigator(Composite parent, IPageSite pageSite, ServicesRegistry registry) {
        super(parent, 2048);
        this.registry = registry;
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.createContents(this);
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void setSelection(ISelection selection) {
        this.getTreeViewer().setSelection(selection, true);
    }

    protected void createContents(Composite parent) {
        this.viewer = new TreeViewer(parent, 2);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.initProviders();
        this.refreshViewer();
    }

    protected void initProviders() {
        NavigatorAdapterFactoryContentProvider adapterContentProvider = new NavigatorAdapterFactoryContentProvider(this.getAdapterFactory());
        adapterContentProvider.inputChanged((Viewer)this.viewer, null, null);
        this.viewer.setContentProvider((IContentProvider)new DiagramOrientedContentProvider(adapterContentProvider));
        try {
            ILabelProvider labelProvider = ((LabelProviderService)ServiceUtils.getInstance().getService(LabelProviderService.class, (Object)this.registry)).getLabelProvider();
            DecoratingLabelProvider fullLabelProvider = new DecoratingLabelProvider(labelProvider, Activator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
            this.viewer.setLabelProvider((IBaseLabelProvider)fullLabelProvider);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    protected final void refreshViewer() {
        this.refreshViewer(false);
    }

    protected final void refreshViewer(boolean updateLabel) {
        if (this.viewer != null && !this.viewer.getTree().isDisposed()) {
            if (Display.getCurrent() != Display.getDefault()) {
                this.syncRefreshViewer(updateLabel);
            } else {
                this.viewer.refresh(updateLabel);
            }
        }
    }

    private void syncRefreshViewer(final boolean updateLabel) {
        this.viewer.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                DiagramNavigator.this.viewer.refresh(updateLabel);
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    protected AdapterFactory getAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new UMLItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    protected class NavigatorAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public NavigatorAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public void notifyChanged(Notification notification) {
            if (notification instanceof IViewerNotification) {
                Object element = ((IViewerNotification)notification).getElement();
                if (!(element instanceof View)) {
                    super.notifyChanged(notification);
                } else if (element instanceof Diagram && ((IViewerNotification)notification).isLabelUpdate()) {
                    DiagramNavigator.this.refreshViewer(true);
                }
            } else {
                super.notifyChanged(notification);
            }
        }
    }
}

