/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.newchild;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.newchild.CreationMenuListener;
import org.eclipse.papyrus.infra.newchild.ElementCreationMenuModel.CreationMenu;
import org.eclipse.papyrus.infra.newchild.ElementCreationMenuModel.Folder;
import org.eclipse.papyrus.infra.newchild.ElementCreationMenuModel.Menu;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreationMenuFactory {
    private TransactionalEditingDomain editingDomain;

    public CreationMenuFactory(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public boolean populateMenu(org.eclipse.swt.widgets.Menu menu, Folder folder, EObject selectedObject) {
        if (selectedObject != null && folder != null) {
            MenuItem topMenuItem = new MenuItem(menu, 64);
            topMenuItem.setText(folder.getLabel());
            if (folder.getIcon() != null) {
                try {
                    URL url = new URL(folder.getIcon());
                    ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)url);
                    topMenuItem.setImage(imgDesc.createImage());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            org.eclipse.swt.widgets.Menu topMenu = new org.eclipse.swt.widgets.Menu(menu);
            topMenuItem.setMenu(topMenu);
            boolean oneDisplayedMenu = false;
            for (Menu currentMenu : folder.getMenu()) {
                boolean result = false;
                if (currentMenu instanceof Folder) {
                    result = this.populateMenu(topMenu, (Folder)currentMenu, selectedObject);
                }
                if (currentMenu instanceof CreationMenu) {
                    CreationMenu currentCreationMenu = (CreationMenu)currentMenu;
                    EReference reference = null;
                    String role = currentCreationMenu.getRole();
                    if (role != null) {
                        EStructuralFeature feature = selectedObject.eClass().getEStructuralFeature(role);
                        if (feature instanceof EReference) {
                            reference = (EReference)feature;
                            result = this.constructMenu(selectedObject, topMenu, currentCreationMenu, reference);
                        }
                    } else {
                        result = currentCreationMenu.isDisplayAllRoles() ? this.constructMenu(selectedObject, topMenu, currentCreationMenu) : this.constructMenu(selectedObject, topMenu, currentCreationMenu, reference);
                    }
                }
                if (!result) continue;
                oneDisplayedMenu = true;
            }
            if (!oneDisplayedMenu) {
                topMenuItem.dispose();
            }
            return oneDisplayedMenu;
        }
        return false;
    }

    protected boolean constructMenu(EObject selectedObject, org.eclipse.swt.widgets.Menu menu, CreationMenu currentCreationMenu) {
        ArrayList<EStructuralFeature> possibleEFeatures = this.getEreferences(selectedObject, currentCreationMenu);
        if (possibleEFeatures.size() == 1) {
            Command cmd = this.buildCommand(null, selectedObject, currentCreationMenu.getElementTypeIdRef());
            if (cmd.canExecute()) {
                MenuItem item = new MenuItem(menu, 0);
                this.fillIcon(currentCreationMenu, item);
                item.setEnabled(true);
                item.setText(currentCreationMenu.getLabel());
                item.addSelectionListener((SelectionListener)new CreationMenuListener(cmd, this.editingDomain));
                return true;
            }
            return false;
        }
        if (possibleEFeatures.size() > 1) {
            MenuItem topMenuItem = new MenuItem(menu, 64);
            topMenuItem.setText(currentCreationMenu.getLabel());
            org.eclipse.swt.widgets.Menu topMenu = new org.eclipse.swt.widgets.Menu(menu);
            topMenuItem.setMenu(topMenu);
            for (EStructuralFeature eStructuralFeature : possibleEFeatures) {
                Command cmd = this.buildCommand((EReference)eStructuralFeature, selectedObject, currentCreationMenu.getElementTypeIdRef());
                if (!cmd.canExecute()) continue;
                MenuItem item = new MenuItem(topMenu, 0);
                this.fillIcon(currentCreationMenu, item);
                item.setEnabled(true);
                item.setText("As " + eStructuralFeature.getName());
                item.addSelectionListener((SelectionListener)new CreationMenuListener(cmd, this.editingDomain));
            }
            if (topMenu.getItemCount() == 0) {
                topMenu.dispose();
                return false;
            }
            return true;
        }
        return false;
    }

    protected void fillIcon(CreationMenu currentCreationMenu, MenuItem item) {
        if (currentCreationMenu.getIcon() != null && !"".equals(currentCreationMenu.getIcon())) {
            try {
                URL url = new URL(currentCreationMenu.getIcon());
                ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)url);
                item.setImage(imgDesc.createImage());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            this.createIconFromElementType(currentCreationMenu, item);
        }
    }

    protected ArrayList<EStructuralFeature> getEreferences(EObject selectedObject, CreationMenu currentCreationMenu) {
        ArrayList<EStructuralFeature> possibleEFeatures = new ArrayList<EStructuralFeature>();
        EList featureList = selectedObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : featureList) {
            IElementType menuType;
            EReference ref;
            if (!(eStructuralFeature instanceof EReference) || !(ref = (EReference)eStructuralFeature).isContainment() || (menuType = this.getElementType(currentCreationMenu.getElementTypeIdRef())) == null || !this.isSubClass(ref.getEType(), menuType.getEClass())) continue;
            possibleEFeatures.add(eStructuralFeature);
        }
        return possibleEFeatures;
    }

    protected boolean isSubClass(EClassifier aclass, EClass possibleSubClasse) {
        if (aclass.equals(possibleSubClasse)) {
            return true;
        }
        EList superTypeList = possibleSubClasse.getEAllSuperTypes();
        return superTypeList.contains((Object)aclass);
    }

    protected void createIconFromElementType(CreationMenu currentCreationMenu, MenuItem item) {
        if (this.getElementType(currentCreationMenu.getElementTypeIdRef()).getIconURL() != null) {
            ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)this.getElementType(currentCreationMenu.getElementTypeIdRef()).getIconURL());
            item.setImage(imgDesc.createImage());
        }
    }

    protected boolean constructMenu(EObject selectedObject, org.eclipse.swt.widgets.Menu topMenu, CreationMenu currentCreationMenu, EReference reference) {
        boolean oneDisplayedMenu = false;
        Command cmd = this.buildCommand(reference, selectedObject, currentCreationMenu.getElementTypeIdRef());
        if (cmd.canExecute()) {
            oneDisplayedMenu = true;
            MenuItem item = new MenuItem(topMenu, 0);
            this.fillIcon(currentCreationMenu, item);
            item.setEnabled(true);
            item.setText(currentCreationMenu.getLabel());
            item.addSelectionListener((SelectionListener)new CreationMenuListener(cmd, this.editingDomain));
        }
        return oneDisplayedMenu;
    }

    protected IElementType getElementType(String extendedType) {
        return ElementTypeRegistry.getInstance().getType(extendedType);
    }

    protected Command buildCommand(EReference reference, EObject container, String extendedType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)container);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)this.buildRequest(reference, container, extendedType));
        if (createGMFCommand != null) {
            GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(createGMFCommand);
            return emfCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected CreateElementRequest buildRequest(EReference reference, EObject container, String extendedType) {
        if (reference == null) {
            return new CreateElementRequest(this.editingDomain, container, this.getElementType(extendedType));
        }
        return new CreateElementRequest(this.editingDomain, container, this.getElementType(extendedType), reference);
    }
}

