/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.common.internal;

import java.util.EventObject;
import java.util.HashMap;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.IWorkbenchPartProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.emf.databinding.EMFObservableValue;
import org.eclipse.papyrus.infra.table.common.internal.IPapyrusNatTableWidget;
import org.eclipse.papyrus.infra.table.common.internal.PapyrusNatTableWidget;
import org.eclipse.papyrus.infra.table.common.internal.TableEditorInput;
import org.eclipse.papyrus.infra.table.common.messages.Messages;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrustableinstancePackage;
import org.eclipse.papyrus.infra.widgets.editors.BooleanRadio;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.StringLabel;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.uml2.uml.util.UMLUtil;

public class NatTableEditor
extends EditorPart
implements ISelectionProvider,
IEditingDomainProvider,
IWorkbenchPartProvider {
    public static final String ID = "org.eclipse.emf.facet.widgets.nattable.workbench.editor.NatTableEditor";
    private TableEditorInput tableEditorInput;
    protected INatTableWidget natTableWidget;
    private EditingDomain editingDomain;
    private MenuManager menuMgr;
    private StringLabel contextLabel;
    private final CommandStackListener commandListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    NatTableEditor.this.firePropertyChange(257);
                }
            });
        }
    };
    private final Adapter contextListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            NatTableEditor.this.contextLabel.refreshValue();
            super.notifyChanged(notification);
        }
    };

    public Object getAdapter(Class adapter) {
        if (adapter == INatTableWidgetProvider.class) {
            return new INatTableWidgetProvider(){

                public INatTableWidget getNatTableWidget() {
                    return NatTableEditor.this.natTableWidget;
                }
            };
        }
        if (adapter == PapyrusTableInstance.class) {
            return this.tableEditorInput.getPapyrusTableInstance();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof TableEditorInput) {
            this.tableEditorInput = (TableEditorInput)input;
            this.editingDomain = this.tableEditorInput.getEditingDomain();
            this.initializeEditingDomain();
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(this.tableEditorInput);
            this.setPartName(this.tableEditorInput.getName());
        } else if (input instanceof FileEditorInput) {
            this.initializeEditingDomain();
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            URI uri = URI.createPlatformResourceURI((String)fileEditorInput.getFile().getFullPath().toString(), (boolean)false);
            if (uri != null) {
                Resource resource = null;
                if (this.getEditingDomain() != null) {
                    resource = this.getEditingDomain().loadResource(uri.toString());
                } else {
                    ResourceSetImpl rSet = new ResourceSetImpl();
                    resource = rSet.createResource(uri);
                }
                PapyrusTableInstance tableInstance = null;
                for (EObject eObject : resource.getContents()) {
                    if (!(eObject instanceof PapyrusTableInstance)) continue;
                    tableInstance = (PapyrusTableInstance)eObject;
                    break;
                }
                this.tableEditorInput = new TableEditorInput(tableInstance, this.getEditingDomain());
                this.setSite((IWorkbenchPartSite)site);
                this.setInput(this.tableEditorInput);
                this.setPartName(fileEditorInput.getName());
            }
        } else {
            throw new PartInitException("Input should be of type TableEditorInput or a .table file");
        }
    }

    public void createPartControl(Composite parent) {
        this.menuMgr = new MenuManager("#PopUp", ID);
        this.menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.menuMgr.setRemoveAllWhenShown(true);
        Composite editorComposite = this.createCompositeCompositeWthTableBorder(parent);
        Composite tableComposite = new Composite(editorComposite, 0);
        GridLayout tableCompositeGridLayout = new GridLayout(1, true);
        tableComposite.setLayout((Layout)tableCompositeGridLayout);
        GridData compositeTableGridLayout = new GridData();
        compositeTableGridLayout.grabExcessHorizontalSpace = true;
        compositeTableGridLayout.grabExcessVerticalSpace = true;
        compositeTableGridLayout.horizontalAlignment = 4;
        compositeTableGridLayout.verticalAlignment = 4;
        tableComposite.setLayoutData((Object)compositeTableGridLayout);
        this.natTableWidget = this.createNattableWidget(tableComposite, this, this.tableEditorInput.getPapyrusTableInstance().getTable(), this.menuMgr);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.natTableWidget);
    }

    private INatTableWidget createNattableWidget(Composite tableComposite, NatTableEditor natTableEditor, TableInstance2 table, MenuManager menuMgr2) {
        this.natTableWidget = new PapyrusNatTableWidget(tableComposite, natTableEditor, (TableInstance)table, this.menuMgr);
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalAlignment = 4;
        tableGridData.verticalAlignment = 4;
        this.natTableWidget.getComposite().setLayoutData((Object)tableGridData);
        return this.natTableWidget;
    }

    private Composite createCompositeCompositeWthTableBorder(Composite parent) {
        Composite editorComposite = new Composite(parent, 2048);
        GridLayout editorGridLayout = new GridLayout(1, true);
        editorGridLayout.marginHeight = 0;
        editorGridLayout.marginWidth = 0;
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        editorComposite.setLayoutData((Object)data);
        editorComposite.setLayout((Layout)editorGridLayout);
        return editorComposite;
    }

    protected void createFirstLine(Composite parent) {
        TableInstance2 table = this.tableEditorInput.getPapyrusTableInstance().getTable();
        Composite firstLineComposite = new Composite(parent, 0);
        GridLayout smallGridLayout = new GridLayout(2, true);
        smallGridLayout.marginHeight = 0;
        smallGridLayout.marginWidth = 0;
        smallGridLayout.marginLeft = 0;
        smallGridLayout.marginRight = 0;
        firstLineComposite.setLayout((Layout)smallGridLayout);
        GridData lineData = new GridData();
        lineData.horizontalSpan = 1;
        lineData.horizontalAlignment = 4;
        firstLineComposite.setLayoutData((Object)lineData);
        this.contextLabel = new StringLabel(firstLineComposite, 16384);
        this.contextLabel.setLabel(Messages.NatTableEditor_TableContextLabel);
        this.contextLabel.setToolTipText(Messages.NatTableEditor_TableContextTollTip);
        EObjectObservableValue contextObservable = new EObjectObservableValue((EObject)table, (EStructuralFeature)TableinstancePackage.eINSTANCE.getTableInstance_Context());
        table.getContext().eAdapters().add((Object)this.contextListener);
        this.contextLabel.setConverters(null, (IConverter)new ContextLabelConverter());
        this.contextLabel.setLabelProvider((ILabelProvider)new UMLLabelProvider());
        this.contextLabel.setModelObservable((IObservableValue)contextObservable);
        GridData contextGridData = new GridData();
        contextGridData.grabExcessHorizontalSpace = true;
        contextGridData.horizontalAlignment = 4;
        contextGridData.horizontalSpan = 1;
        this.contextLabel.setLayoutData((Object)contextGridData);
        BooleanRadio checkbox = new BooleanRadio(firstLineComposite, 0, "IsSynchronized :");
        checkbox.setToolTipText("Indicates if the table is synchronized with queries");
        EMFObservableValue isSynchronizedObservable = new EMFObservableValue((EObject)this.tableEditorInput.getPapyrusTableInstance(), (EStructuralFeature)PapyrustableinstancePackage.eINSTANCE.getPapyrusTableInstance_IsSynchronized(), this.getEditingDomain());
        checkbox.setModelObservable((IObservableValue)isSynchronizedObservable);
        GridData checkboxGridData = new GridData();
        checkboxGridData.grabExcessHorizontalSpace = true;
        checkboxGridData.horizontalAlignment = 4;
        checkbox.setLayoutData((Object)checkboxGridData);
    }

    protected void createDescription(Composite parent) {
        TableInstance2 table = this.tableEditorInput.getPapyrusTableInstance().getTable();
        EClass tableEClass = table.eClass();
        StringEditor descriptionEditor = new StringEditor(parent, 2);
        descriptionEditor.setLabel(Messages.NatTableEditor_TaleDescriptionLabel);
        descriptionEditor.setToolTipText(Messages.NatTableEditor_TableDescriptionToolTip);
        EStructuralFeature myFeature = tableEClass.getEStructuralFeature(7);
        EMFObservableValue observable = new EMFObservableValue((EObject)table, myFeature, this.getEditingDomain());
        descriptionEditor.setModelObservable((IObservableValue)observable);
        GridData descriptionGridData = new GridData();
        descriptionGridData.grabExcessHorizontalSpace = true;
        descriptionGridData.horizontalAlignment = 4;
        descriptionEditor.setLayoutData((Object)descriptionGridData);
    }

    public void dispose() {
        if (this.natTableWidget.getTableInstance().getContext() != null) {
            this.natTableWidget.getTableInstance().getContext().eAdapters().remove((Object)this.contextListener);
        }
        this.editingDomain.getCommandStack().removeCommandStackListener(this.commandListener);
        super.dispose();
        for (ISelectionChangedListener listener : this.natTableWidget.getSelectionChangedListeners()) {
            this.natTableWidget.removeSelectionChangedListener(listener);
        }
        ((IPapyrusNatTableWidget)this.natTableWidget).dispose();
        this.natTableWidget = null;
    }

    public void setFocus() {
        this.natTableWidget.getComposite().setFocus();
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        this.natTableWidget.save();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        this.natTableWidget.saveAs();
        this.firePropertyChange(257);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.natTableWidget.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        boolean focus;
        Control[] children = ((Composite)this.natTableWidget).getChildren();
        if (children.length != 0 && (focus = children[0].isFocusControl())) {
            return this.natTableWidget.getSelection();
        }
        return new StructuredSelection((Object)this.tableEditorInput.getPapyrusTableInstance());
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.natTableWidget != null) {
            this.natTableWidget.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.natTableWidget.setSelection(selection);
    }

    protected void initializeEditingDomain() {
        if (this.editingDomain == null) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            BasicCommandStack commandStack = new BasicCommandStack();
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        }
        this.editingDomain.getCommandStack().removeCommandStackListener(this.commandListener);
        this.editingDomain.getCommandStack().addCommandStackListener(this.commandListener);
    }

    public IWorkbenchPart getPart() {
        return this;
    }

    private static class ContextLabelConverter
    implements IConverter {
        private ContextLabelConverter() {
        }

        public Object getToType() {
            return String.class;
        }

        public Object getFromType() {
            return Object.class;
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof EObject) {
                return UMLUtil.getQualifiedText((EObject)((EObject)fromObject));
            }
            return "";
        }
    }
}

