/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.instance.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrustableinstancePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableContentsUtils {
    private TableContentsUtils() {
    }

    public static final List<EObject> getTableContents(PapyrusTableInstance papyrusTable, EObject tableContext, boolean synchronizedContent) {
        return new ArrayList<EObject>((Collection<EObject>)papyrusTable.getTable().getElements());
    }

    public static Iterable<EObject> createDescendantTablesIterable(EObject context) {
        HashSet result = Sets.newHashSet();
        TreeIterator eAllContents = EcoreUtil.getAllProperContents((EObject)context, (boolean)true);
        Iterator contextAndDescendants = Iterators.concat((Iterator)eAllContents, (Iterator)Iterators.singletonIterator((Object)context));
        Predicate<EStructuralFeature.Setting> keepPapyrusTableInstances = new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting setting) {
                boolean result = true;
                if (setting != null) {
                    EObject settingEObject = setting.getEObject();
                    result &= settingEObject instanceof PapyrusTableInstance;
                    result &= PapyrustableinstancePackage.Literals.PAPYRUS_TABLE_INSTANCE__TABLE == setting.getEStructuralFeature();
                } else {
                    result = false;
                }
                return result;
            }
        };
        Predicate<EStructuralFeature.Setting> keepTableInstances = new Predicate<EStructuralFeature.Setting>((Predicate)keepPapyrusTableInstances){
            private final /* synthetic */ Predicate val$keepPapyrusTableInstances;
            {
                this.val$keepPapyrusTableInstances = predicate;
            }

            public boolean apply(EStructuralFeature.Setting setting) {
                boolean result = true;
                if (setting != null) {
                    EObject settingEObject = setting.getEObject();
                    result &= settingEObject instanceof TableInstance;
                    boolean bl = setting.getEStructuralFeature() == TableinstancePackage.Literals.TABLE_INSTANCE__CONTEXT;
                    Collection references = EMFHelper.getUsages((EObject)settingEObject);
                    Iterable papyrusTableInstances = Iterables.filter((Iterable)references, (Predicate)this.val$keepPapyrusTableInstances);
                    result = (result &= bl) && !Iterables.isEmpty((Iterable)papyrusTableInstances);
                } else {
                    result = false;
                }
                return result;
            }
        };
        Function<EStructuralFeature.Setting, EObject> getEObject = new Function<EStructuralFeature.Setting, EObject>((Predicate)keepPapyrusTableInstances){
            private final /* synthetic */ Predicate val$keepPapyrusTableInstances;
            {
                this.val$keepPapyrusTableInstances = predicate;
            }

            public EObject apply(EStructuralFeature.Setting input) {
                EObject settingEObject = input.getEObject();
                Collection references = EMFHelper.getUsages((EObject)settingEObject);
                Iterable papyrusTableInstances = Iterables.filter((Iterable)references, (Predicate)this.val$keepPapyrusTableInstances);
                return ((EStructuralFeature.Setting)Iterables.get((Iterable)papyrusTableInstances, (int)0)).getEObject();
            }
        };
        while (contextAndDescendants.hasNext()) {
            EObject current = (EObject)contextAndDescendants.next();
            Collection usages = EMFHelper.getUsages((EObject)current);
            Iterable tableInstanceSettings = Iterables.filter((Iterable)usages, (Predicate)keepTableInstances);
            Iterable papyrusTableInstances = Iterables.transform((Iterable)tableInstanceSettings, (Function)getEObject);
            Iterables.addAll((Collection)result, (Iterable)papyrusTableInstances);
        }
        return result;
    }

    public static Collection<PapyrusTableInstance> getPapyrusTableInstances(EObject selection) {
        ArrayList<PapyrusTableInstance> pTables = new ArrayList<PapyrusTableInstance>();
        Iterable<EObject> allDescendingPapyrusTables = TableContentsUtils.createDescendantTablesIterable(selection);
        for (EObject eObject : allDescendingPapyrusTables) {
            if (!(eObject instanceof PapyrusTableInstance)) continue;
            pTables.add((PapyrusTableInstance)eObject);
        }
        return pTables;
    }
}

