/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.modelexplorer.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQuery;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.views.modelexplorer.NavigatorUtils;
import org.eclipse.papyrus.views.modelexplorer.queries.AbstractEditorContainerQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetContainedTables
extends AbstractEditorContainerQuery
implements IJavaModelQuery<EObject, Collection<PapyrusTableInstance>> {
    public Collection<PapyrusTableInstance> evaluate(EObject context, ParameterValueList parameterValues) throws ModelQueryExecutionException {
        ArrayList<PapyrusTableInstance> result = new ArrayList<PapyrusTableInstance>();
        Iterator diRoots = NavigatorUtils.getDiRoots((EObject)context);
        Iterator notationRoots = NavigatorUtils.getNotationRoots((EObject)context);
        if (diRoots == null && notationRoots == null) {
            return result;
        }
        this.findTablesInIterator(diRoots, result, context);
        this.findTablesInIterator(notationRoots, result, context);
        return result;
    }

    private void findTablesInIterator(Iterator<EObject> iterator, Collection<PapyrusTableInstance> result, EObject context) {
        while (iterator.hasNext()) {
            PapyrusTableInstance tableInstance;
            EObject root = iterator.next();
            if (!(root instanceof PapyrusTableInstance) || (tableInstance = (PapyrusTableInstance)root).getTable() == null || !EcoreUtil.equals((EObject)tableInstance.getTable().getContext(), (EObject)context)) continue;
            result.add(tableInstance);
        }
    }
}

