/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.swt.widgets.Composite;

public class DoubleEditor
extends StringEditor {
    private IConverter targetToModelConverter = new IConverter(){

        public Object getFromType() {
            return String.class;
        }

        public Object getToType() {
            return Double.class;
        }

        public Double convert(Object fromObject) {
            if (fromObject instanceof String) {
                String newString = ((String)fromObject).replaceAll(" ", "");
                try {
                    return Double.parseDouble(newString);
                }
                catch (NumberFormatException ex) {
                    Activator.log.error((Throwable)ex);
                    return null;
                }
            }
            return null;
        }
    };

    public DoubleEditor(Composite parent, int style) {
        super(parent, style);
        IConverter doubleToString = new IConverter(){

            public Object getFromType() {
                return Double.class;
            }

            public Object getToType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject instanceof Double) {
                    return Double.toString((Double)fromObject);
                }
                return "";
            }
        };
        this.setValidateOnDelay(true);
        this.setConverters(this.targetToModelConverter, doubleToString);
    }

    public Object getEditableType() {
        return Double.class;
    }

    public Double getValue() {
        try {
            return (Double)this.targetToModelConverter.convert(super.getValue());
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }
}

