/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.edit.part;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.figure.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.sysml.diagram.common.edit.policy.BlockPropertyCompositeSemanticEditPolicy;
import org.eclipse.papyrus.sysml.diagram.common.figure.ConstraintBlockPropertyCompositeFigure;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.ConstraintNodeLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.ConstraintParameterAffixedNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.part.PropertyNodeLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.edit.policy.EncapsulatedClassifierResizableShapeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.edit.policy.StructuredClassifierCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AffixedNodeAlignmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.QualifiedNameDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideRelatedContentsEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.FullInsidePortPositionLocator;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class ConstraintBlockPropertyCompositeEditPart
extends AbstractElementEditPart {
    public static final String REPRESENTATION_MODE_STYLE = "representation_mode_style";
    public static final String ROUNDED_REPRESENTATION = "rounded_representation";
    public static final String SQUARE_REPRESENTATION_WITH_STRUCTURE = "square_representation_with_structure";
    public Map<EditPart, FullInsidePortPositionLocator> constraintParameter2FullInsidePortPositionLocator = new HashMap<EditPart, FullInsidePortPositionLocator>();
    public static String lastRepresentationKind;

    public ConstraintBlockPropertyCompositeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new BlockPropertyCompositeSemanticEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
        this.installEditPolicy(ShowHideRelatedContentsEditPolicy.SHOW_HIDE_RELATED_CONTENTS_POLICY, (EditPolicy)new ShowHideRelatedContentsEditPolicy());
        this.installEditPolicy("Qualified_name_editpolicy", (EditPolicy)new QualifiedNameDisplayEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("affixed node alignment editpolicy", (EditPolicy)new AffixedNodeAlignmentEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new StructuredClassifierCreationEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new EncapsulatedClassifierResizableShapeEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof IBorderItemEditPart) {
                    return new BorderItemResizableEditPolicy();
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof PropertyNodeLabelEditPart) {
            ((PropertyNodeLabelEditPart)childEditPart).setLabel(this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof ConstraintNodeLabelEditPart) {
            ((ConstraintNodeLabelEditPart)childEditPart).setLabel(this.getPrimaryShape().getConstraintLabel());
            return true;
        }
        if (childEditPart instanceof ConstraintParameterAffixedNodeEditPart) {
            FullInsidePortPositionLocator locator = new FullInsidePortPositionLocator(this.getMainFigure(), 0, this.getPrimaryShape().getCorner());
            this.constraintParameter2FullInsidePortPositionLocator.put(childEditPart, locator);
            this.getBorderedFigure().getBorderItemContainer().add(((ConstraintParameterAffixedNodeEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof PropertyNodeLabelEditPart) {
            return true;
        }
        if (childEditPart instanceof ConstraintNodeLabelEditPart) {
            return true;
        }
        if (childEditPart instanceof ConstraintParameterAffixedNodeEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((ConstraintParameterAffixedNodeEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void removeChild(EditPart child) {
        if (child instanceof ConstraintNodeLabelEditPart) {
            return;
        }
        super.removeChild(child);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodeFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigure());
    }

    protected IFigure createNodeShape() {
        this.primaryShape = this.isSquareRepresentationWithStructure() ? new ConstraintBlockPropertyCompositeFigure(SQUARE_REPRESENTATION_WITH_STRUCTURE) : (this.isRoundedRepresentation() ? new ConstraintBlockPropertyCompositeFigure(ROUNDED_REPRESENTATION) : (ConstraintBlockPropertyCompositeEditPart.lastRepresentationIsSquareWithStructure() ? new ConstraintBlockPropertyCompositeFigure(SQUARE_REPRESENTATION_WITH_STRUCTURE) : (this.getChildViewBySemanticHint("compartment_sysml_blockproperty_structure") != null ? new ConstraintBlockPropertyCompositeFigure(SQUARE_REPRESENTATION_WITH_STRUCTURE) : new ConstraintBlockPropertyCompositeFigure(ROUNDED_REPRESENTATION))));
        return this.primaryShape;
    }

    public ConstraintBlockPropertyCompositeFigure getPrimaryShape() {
        return (ConstraintBlockPropertyCompositeFigure)this.primaryShape;
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint("label_uml_property_label");
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        List children = this.getChildren();
        for (Object editPart : children) {
            if (!(editPart instanceof EditPart)) continue;
            ((EditPart)editPart).refresh();
        }
    }

    public boolean isSquareRepresentationWithStructure() {
        StringValueStyle style = (StringValueStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getStringValueStyle());
        if (style == null) {
            return false;
        }
        return SQUARE_REPRESENTATION_WITH_STRUCTURE.equals(style.getStringValue());
    }

    public boolean isRoundedRepresentation() {
        StringValueStyle style = (StringValueStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getStringValueStyle());
        if (style == null) {
            return false;
        }
        return ROUNDED_REPRESENTATION.equals(style.getStringValue());
    }

    protected void handleNotificationEvent(Notification event) {
        EObject element;
        if (this.resolveSemanticElement() != null && (element = this.resolveSemanticElement()) != null && element.equals(event.getNotifier()) && element instanceof Property) {
            if (UMLPackage.eINSTANCE.getProperty_Aggregation().equals(event.getFeature())) {
                this.refreshVisuals();
            }
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(event.getFeature())) {
                this.refreshVisuals();
            }
            if (UMLPackage.eINSTANCE.getProperty_Association().equals(event.getFeature())) {
                this.refreshVisuals();
            }
        }
        super.handleNotificationEvent(event);
        this.refresh();
    }

    public static boolean lastRepresentationIsSquareWithStructure() {
        return SQUARE_REPRESENTATION_WITH_STRUCTURE.equals(lastRepresentationKind);
    }

    public static void setLastRepresentation(String representationKind) {
        lastRepresentationKind = representationKind;
    }

    public void setCornerLocators(int corner) {
        for (EditPart editPart : this.constraintParameter2FullInsidePortPositionLocator.keySet()) {
            FullInsidePortPositionLocator locator = this.constraintParameter2FullInsidePortPositionLocator.get(editPart);
            locator.setCorner(corner);
        }
    }
}

