/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sysml.portandflows.FlowProperty;
import org.eclipse.papyrus.sysml.portandflows.PortandflowsPackage;
import org.eclipse.papyrus.uml.diagram.common.parser.PropertyLabelParser;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowPropertyLabelParser
extends PropertyLabelParser {
    protected static final String DIRECTION_FORMAT = "%s %s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Property property;
        FlowProperty flowProperty;
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = super.getPrintString(element, flags);
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof Property && (flowProperty = (FlowProperty)UMLUtil.getStereotypeApplication((Element)(property = (Property)eObject), FlowProperty.class)) != null && maskValues.contains("direction")) {
            String direction;
            switch (flowProperty.getDirection().getValue()) {
                case 0: {
                    direction = "in";
                    break;
                }
                case 1: {
                    direction = "out";
                    break;
                }
                case 2: {
                    direction = "inout";
                    break;
                }
                default: {
                    direction = "inout";
                }
            }
            result = String.format(DIRECTION_FORMAT, direction, result);
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return PortandflowsPackage.eINSTANCE.getFlowProperty_Direction().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        Property semElement;
        FlowProperty flowProperty;
        List<EObject> semanticElementsBeingParsed = super.getSemanticElementsBeingParsed(element);
        if (element != null && element instanceof Property && (flowProperty = (FlowProperty)UMLUtil.getStereotypeApplication((Element)(semElement = (Property)element), FlowProperty.class)) != null) {
            semanticElementsBeingParsed.add((EObject)flowProperty);
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>(10);
        masks.put("direction", "Direction");
        masks.put("visibility", "Visibility");
        masks.put("derived", "Is Derived");
        masks.put("name", "Name");
        masks.put("type", "Type");
        masks.put("undefinedType", "Show <Undefined> type");
        masks.put("multiplicity", "Multiplicity");
        masks.put("defaultMultiplicity", "Show default multiplicity");
        masks.put("defaultValue", "Default Value");
        masks.put("modifiers", "Modifiers");
        return masks;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("direction", "name", "type", "undefinedType");
    }
}

