/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sysml.requirements.Requirement;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementLabelParser
extends NamedElementLabelParser {
    protected static final String NAME_FORMAT = "%s";
    protected static final String ID_FORMAT = "%s{id = %s}";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = (EObject)element.getAdapter(EObject.class);
        if (eObject != null && eObject instanceof Class) {
            Class clazz = (Class)eObject;
            Requirement requirement = (Requirement)UMLUtil.getStereotypeApplication((Element)clazz, Requirement.class);
            if (maskValues.contains("name")) {
                String name = clazz.getName();
                result = String.format(NAME_FORMAT, name);
            }
            if (requirement != null && maskValues.contains("id")) {
                String id = requirement.getId();
                result = String.format(ID_FORMAT, result, id);
            }
        }
        return result;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Class) {
            Class semElement = (Class)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            Requirement requirement = (Requirement)UMLUtil.getStereotypeApplication((Element)semElement, Requirement.class);
            if (requirement != null) {
                semanticElementsBeingParsed.add((EObject)requirement);
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>();
        masks.put("name", "Name");
        masks.put("id", "Id");
        return masks;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("name", "id");
    }
}

