/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.constraints.ConstraintBlock;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.sysml.constraints.ConstraintsPackage;
import org.eclipse.papyrus.sysml.service.types.Activator;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PropertyEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeSetCommand(SetRequest request) {
        ICommand gmfCommand = super.getBeforeSetCommand(request);
        EObject elementToEdit = request.getElementToEdit();
        if (elementToEdit instanceof Property && !(elementToEdit instanceof Port) && request.getFeature() == UMLPackage.eINSTANCE.getTypedElement_Type() && request.getValue() instanceof Type) {
            List<Property> currentlyRefactoredElements;
            Property propertyToEdit = (Property)elementToEdit;
            if (request.getValue() instanceof Class) {
                ICommand stereotypeApplicationCommand = this.getConstraintPropertyStereotypeApplicationCommand(propertyToEdit, (Class)request.getValue(), request);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)stereotypeApplicationCommand);
            }
            if (propertyToEdit.eContainer() instanceof Class && UMLUtil.getStereotypeApplication((Element)((Element)propertyToEdit.eContainer()), ConstraintBlock.class) != null && UMLUtil.getStereotypeApplication((Element)propertyToEdit, ConstraintProperty.class) == null) {
                return gmfCommand;
            }
            Association relatedAssociation = propertyToEdit.getAssociation();
            if (relatedAssociation == null || !ElementUtil.hasNature((Element)relatedAssociation, (String)"SysML_Nature")) {
                if (relatedAssociation == null && ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)((Type)request.getValue())) && !((ISpecializationType)SysMLElementTypes.CONSTRAINT_BLOCK).getMatcher().matches((EObject)((Type)request.getValue())) && ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches(propertyToEdit.eContainer())) {
                    ICommand addAssociationCommand = this.getCreatePartAssociationCommand((Class)propertyToEdit.eContainer(), propertyToEdit, (Class)request.getValue());
                    gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)addAssociationCommand);
                }
                return gmfCommand;
            }
            List list = currentlyRefactoredElements = request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") != null ? (List)request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") : new ArrayList();
            if (!currentlyRefactoredElements.contains(propertyToEdit)) {
                currentlyRefactoredElements.add(propertyToEdit);
                request.getParameters().put("ASSOCIATION_REFACTORED_ELEMENTS", currentlyRefactoredElements);
                if (currentlyRefactoredElements.contains(relatedAssociation)) {
                    return gmfCommand;
                }
            }
            if (!((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches((EObject)((Type)request.getValue())) && propertyToEdit.getType() != null) {
                ICommand destroyCommand = this.getDestroyPartAssociationCommand(relatedAssociation, propertyToEdit);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)destroyCommand);
                return gmfCommand;
            }
            ICommand refactorCommand = this.getAssociationRefactoringCommand(propertyToEdit, relatedAssociation, request);
            gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)refactorCommand);
        }
        if (gmfCommand != null) {
            gmfCommand = gmfCommand.reduce();
        }
        return gmfCommand;
    }

    protected ICommand getAfterSetCommand(SetRequest setRequest) {
        ICommand afterSetCommand = super.getAfterSetCommand(setRequest);
        EObject elementToEdit = setRequest.getElementToEdit();
        if (elementToEdit instanceof Property && !(elementToEdit instanceof Port) && setRequest.getFeature() == UMLPackage.eINSTANCE.getTypedElement_Type() && setRequest.getValue() instanceof Type) {
            afterSetCommand = this.getDestroyAssociatedNestedConnectorCommand((Property)elementToEdit, afterSetCommand);
        }
        return afterSetCommand;
    }

    protected ICommand getAfterDestroyDependentsCommand(DestroyDependentsRequest destroyDependentsRequest) {
        ICommand afterDestroyDependentsCommand = super.getAfterDestroyDependentsCommand(destroyDependentsRequest);
        EObject elementToDestroy = destroyDependentsRequest.getElementToDestroy();
        if (elementToDestroy instanceof Property) {
            afterDestroyDependentsCommand = this.getDestroyAssociatedNestedConnectorCommand((Property)elementToDestroy, afterDestroyDependentsCommand);
        }
        return afterDestroyDependentsCommand;
    }

    private ICommand getDestroyAssociatedNestedConnectorCommand(Property property, ICommand command) {
        List instancesFilteredByType = org.eclipse.papyrus.uml.tools.utils.ElementUtil.getInstancesFilteredByType((Model)property.getModel(), Connector.class, null);
        List<Connector> connectorToDestroy = ConnectorUtils.filterConnectorByPropertyInNestedConnectorEnd(instancesFilteredByType, property);
        for (Connector connector : connectorToDestroy) {
            ICommand destroyConnectorCommand = this.getDestroyConnectorCommand(connector);
            command = CompositeCommand.compose((ICommand)command, (ICommand)destroyConnectorCommand);
        }
        return command;
    }

    private ICommand getDestroyConnectorCommand(Connector connector) {
        DestroyElementRequest request = new DestroyElementRequest((EObject)connector, false);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)connector.eContainer());
        if (provider == null) {
            return null;
        }
        return provider.getEditCommand((IEditCommandRequest)request);
    }

    private ICommand getAssociationRefactoringCommand(Property setProperty, Association associationToRefactor, SetRequest request) {
        Association relatedAssociation = setProperty.getAssociation();
        if (associationToRefactor.getMemberEnds().size() >= 2) {
            int direction = 2;
            if (setProperty == associationToRefactor.getMemberEnds().get(1)) {
                direction = 1;
            }
            ReorientRelationshipRequest reorientRequest = new ReorientRelationshipRequest((EObject)relatedAssociation, (EObject)((Type)request.getValue()), setProperty.eContainer(), direction);
            reorientRequest.addParameters(request.getParameters());
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)relatedAssociation);
            if (provider != null) {
                return provider.getEditCommand((IEditCommandRequest)reorientRequest);
            }
        }
        return null;
    }

    private ICommand getCreatePartAssociationCommand(final Class sourceBlock, final Property sourceProperty, final Class targetBlock) {
        return new AbstractCommand("Create part association"){

            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return null;
            }

            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return null;
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Association association = UMLFactory.eINSTANCE.createAssociation();
                Package container = (Package)EMFCoreUtil.getLeastCommonContainer(Arrays.asList(sourceBlock, targetBlock), (EClass)UMLPackage.eINSTANCE.getPackage());
                container.getPackagedElements().add((Object)association);
                association.getMemberEnds().add((Object)sourceProperty);
                Property targetProperty = UMLFactory.eINSTANCE.createProperty();
                association.getOwnedEnds().add((Object)targetProperty);
                String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)UMLPackage.eINSTANCE.getAssociation().getName(), (Collection)association.eContainer().eContents());
                association.setName(initializedName);
                ElementUtil.addNature((Element)association, (String)"SysML_Nature");
                return CommandResult.newOKCommandResult((Object)association);
            }
        };
    }

    private ICommand getConstraintPropertyStereotypeApplicationCommand(final Property sourceProperty, final Class targetBlock, final SetRequest request) {
        return new AbstractTransactionalCommand(request.getEditingDomain(), "Apply/Remove ConstraintProperty Stereotype", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                ConstraintProperty constraintPropertyApplication = (ConstraintProperty)UMLUtil.getStereotypeApplication((Element)sourceProperty, ConstraintProperty.class);
                if (UMLUtil.getStereotypeApplication((Element)targetBlock, ConstraintBlock.class) != null) {
                    if (constraintPropertyApplication == null) {
                        UMLUtil.StereotypeApplicationHelper.INSTANCE.applyStereotype((Element)sourceProperty, ConstraintsPackage.eINSTANCE.getConstraintProperty());
                        String diagramType = null;
                        Set memberViewsToDestroy = CrossReferencerUtil.getCrossReferencingViews((EObject)sourceProperty, diagramType);
                        if (memberViewsToDestroy.size() != 0) {
                            String hideValue;
                            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                            String DISPLAY_MESSAGE_FOR_TYPING_ACTION_PREFERENCE_KEY = "displayMessageForTypingActionPreferenceKey";
                            boolean contains = store.contains("displayMessageForTypingActionPreferenceKey");
                            if (!contains) {
                                store.setValue("displayMessageForTypingActionPreferenceKey", "never");
                                store.setDefault("displayMessageForTypingActionPreferenceKey", "never");
                            }
                            if (!(hideValue = store.getString("displayMessageForTypingActionPreferenceKey")).equals("always")) {
                                int size = memberViewsToDestroy.size();
                                MessageDialogWithToggle.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Change Type Action", (String)("WARNING! Typing a Property by a ConstraintBlock make this property become a ConstraintProperty. ConstraintProperty have a specific representation. \nSo all representations of this property will be removed from the model (" + size + " occurence" + (size > 1 ? "s" : "") + ")."), (String)"Don't show this dialog the next time", (boolean)false, (IPreferenceStore)store, (String)"displayMessageForTypingActionPreferenceKey");
                            }
                        }
                        for (View view : memberViewsToDestroy) {
                            DestroyElementRequest destroyRequest = new DestroyElementRequest(request.getEditingDomain(), (EObject)view, false);
                            IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((Object)view);
                            ICommand editCommand = commandProvider.getEditCommand((IEditCommandRequest)destroyRequest);
                            editCommand.execute(progressMonitor, info);
                        }
                    }
                } else if (constraintPropertyApplication != null) {
                    UMLUtil.StereotypeApplicationHelper.INSTANCE.removeFromContainmentList((Element)sourceProperty, (EObject)constraintPropertyApplication);
                }
                return CommandResult.newOKCommandResult((Object)sourceProperty);
            }
        };
    }

    private ICommand getDestroyPartAssociationCommand(Association partAssociation, Property propertyToEdit) {
        DestroyElementRequest request = new DestroyElementRequest((EObject)partAssociation, false);
        List<EObject> dependentsToKeep = Arrays.asList(propertyToEdit);
        request.getParameters().put("DEPENDENTS_TO_KEEP", dependentsToKeep);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)partAssociation.eContainer());
        if (provider == null) {
            return null;
        }
        ICommand destroyCommand = provider.getEditCommand((IEditCommandRequest)request);
        return destroyCommand;
    }
}

