/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorUtils
extends org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils {
    public static String NESTED_CONNECTOR_END_PATH = "connectorEndPath";
    public static final String PART_SEPARATOR = ".";
    public static final String HAS_NO_WORD_CHAR_REGEX = "\\W+";
    public static final String STRING_DELIMITER = "'";

    public View getEncapsulatedContainer(View view) {
        View encapsulatedContainer = null;
        for (View containerView : this.getStructureContainers(view)) {
            StructuredClassifier structuredClassifier;
            Block block;
            if (view == containerView || view.getElement() instanceof Port && containerView.getChildren().contains((Object)view) || !(block = (Block)UMLUtil.getStereotypeApplication((Element)(structuredClassifier = this.getStructuredClassifier(containerView)), Block.class)).isEncapsulated()) continue;
            encapsulatedContainer = containerView;
            break;
        }
        return encapsulatedContainer;
    }

    public boolean isCrossingEncapsulation(View checkedEnd, View oppositeEnd) {
        boolean isCrossingEncapsulation = false;
        View encapsulatedContainer = new ConnectorUtils().getEncapsulatedContainer(checkedEnd);
        if (encapsulatedContainer != null) {
            View containerView = new ConnectorUtils().deduceViewContainer(checkedEnd, oppositeEnd);
            List containers = new ConnectorUtils().getStructureContainers(checkedEnd);
            if (containers.indexOf(encapsulatedContainer) < containers.indexOf(containerView)) {
                isCrossingEncapsulation = true;
            }
        }
        return isCrossingEncapsulation;
    }

    public List<View> getNestedPath(View checkedEnd, View oppositeEnd) {
        List<Object> isNestedConnectableElement = new ArrayList<View>();
        View nearestContainer = new ConnectorUtils().getNearestStructureContainer(checkedEnd);
        if (nearestContainer != null) {
            View containerView = new ConnectorUtils().deduceViewContainer(checkedEnd, oppositeEnd);
            List containers = new ConnectorUtils().getStructureContainers(checkedEnd);
            if (containers.indexOf(nearestContainer) < containers.indexOf(containerView)) {
                isNestedConnectableElement = containers.subList(containers.indexOf(nearestContainer), containers.indexOf(containerView));
            }
        }
        Collections.reverse(isNestedConnectableElement);
        return isNestedConnectableElement;
    }

    public List<Property> getNestedPropertyPath(View checkedEnd, View oppositeEnd) {
        Property partWithPort;
        ArrayList<Property> nestedPropertyPath = new ArrayList<Property>();
        List<View> nestedPath = this.getNestedPath(checkedEnd, oppositeEnd);
        for (View view : nestedPath) {
            if (view.getElement() == null || !(view.getElement() instanceof Property)) continue;
            nestedPropertyPath.add((Property)view.getElement());
        }
        if (!nestedPropertyPath.isEmpty() && checkedEnd.getElement() instanceof Port && (partWithPort = this.getPartWithPort(checkedEnd, oppositeEnd)) != null) {
            nestedPropertyPath.add(partWithPort);
        }
        return nestedPropertyPath;
    }

    public boolean isNestedConnectableElement(View checkedEnd, View oppositeEnd) {
        return !this.getNestedPath(checkedEnd, oppositeEnd).isEmpty();
    }

    public View getNearestStructureContainer(View view) {
        View nearestStructureContainer = null;
        for (View containerView : this.getStructureContainers(view)) {
            if (view == containerView || view.getElement() instanceof Port && containerView.getChildren().contains((Object)view)) continue;
            nearestStructureContainer = containerView;
            break;
        }
        return nearestStructureContainer;
    }

    public static final String getRolePath(ConnectorEnd end) {
        NestedConnectorEnd nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)end, NestedConnectorEnd.class);
        ConnectableElement role = end.getRole();
        StringBuilder rolePath = new StringBuilder();
        if (role != null) {
            if (nestedConnectorEnd != null) {
                EList properties = nestedConnectorEnd.getPropertyPath();
                for (Property current : properties) {
                    rolePath.append(ConnectorUtils.getNameWithQuotes((NamedElement)current));
                    rolePath.append(PART_SEPARATOR);
                }
            } else {
                Property partWithPort = end.getPartWithPort();
                if (partWithPort != null) {
                    rolePath.append(ConnectorUtils.getNameWithQuotes((NamedElement)partWithPort));
                    rolePath.append(PART_SEPARATOR);
                }
            }
            rolePath.append(ConnectorUtils.getNameWithQuotes((NamedElement)role));
        }
        return rolePath.toString();
    }

    public static final String getNameWithQuotes(NamedElement property) {
        String partName = property.getName();
        StringBuffer partNameBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile(HAS_NO_WORD_CHAR_REGEX);
        Matcher matcher = pattern.matcher(partName);
        boolean mustHaveQuote = false;
        while (matcher.find() && !mustHaveQuote) {
            mustHaveQuote = true;
        }
        if (mustHaveQuote) {
            partNameBuffer.append(STRING_DELIMITER);
            partNameBuffer.append(partName);
            partNameBuffer.append(STRING_DELIMITER);
        } else {
            partNameBuffer.append(partName);
        }
        return partNameBuffer.toString();
    }

    public static final boolean isCrossingEncapuslation(List<Property> nestedPath) {
        for (Property current : nestedPath) {
            Block block;
            Type type = current.getType();
            if (type == null || (block = (Block)UMLUtil.getStereotypeApplication((Element)type, Block.class)) == null || !block.isEncapsulated()) continue;
            return true;
        }
        return false;
    }

    public final boolean canDisplayExistingConnectorBetweenViewsAccordingToNestedPaths(Connector connector, View sourceView, View targetView) {
        ConnectorUtils utils = new ConnectorUtils();
        List<Property> sourcePath = utils.getNestedPropertyPath(sourceView, targetView);
        List<Property> targetPath = utils.getNestedPropertyPath(targetView, sourceView);
        boolean hasWantedPath = true;
        for (ConnectorEnd end : connector.getEnds()) {
            if (sourceView != null && end.getRole() == sourceView.getElement()) {
                hasWantedPath = hasWantedPath && this.haveSamePath(sourcePath, end);
                continue;
            }
            if (targetView == null || end.getRole() != targetView.getElement()) continue;
            boolean bl = hasWantedPath = hasWantedPath && this.haveSamePath(targetPath, end);
        }
        return hasWantedPath;
    }

    protected boolean haveSamePath(List<Property> wantedPath, ConnectorEnd end) {
        Stereotype ste = end.getAppliedStereotype("SysML::Blocks::NestedConnectorEnd");
        if (ste != null) {
            NestedConnectorEnd nestedConnectorEnd = (NestedConnectorEnd)end.getStereotypeApplication(ste);
            return nestedConnectorEnd.getPropertyPath().equals(wantedPath);
        }
        return wantedPath.isEmpty();
    }

    public boolean canDisplayExistingConnectorBetweenViewsAccordingToPartWithPort(Connector connector, View sourceView, View targetView) {
        Property partWithPort = this.getPartWithPortFromConnector(connector);
        if (partWithPort != null) {
            String partWithPortName = partWithPort.getName();
            Type partWithPortType = partWithPort.getType();
            EObject sourceContainer = ((View)sourceView.eContainer()).getElement();
            EObject targetContainer = ((View)targetView.eContainer()).getElement();
            boolean sameSourceType = false;
            if (sourceContainer instanceof TypedElement) {
                sameSourceType = partWithPortType.conformsTo(((TypedElement)sourceContainer).getType());
            }
            boolean sameSourceName = partWithPortName.equals(((NamedElement)sourceContainer).getName());
            boolean sameTargetType = false;
            if (targetContainer instanceof TypedElement) {
                sameTargetType = partWithPortType.conformsTo(((TypedElement)targetContainer).getType());
            }
            boolean sametargetName = partWithPortName.equals(((NamedElement)targetContainer).getName());
            return sameSourceType && sameSourceName || sameTargetType && sametargetName;
        }
        return true;
    }

    public Property getPartWithPortFromConnector(Connector connector) {
        if (connector != null && connector.getEnds() != null) {
            for (ConnectorEnd end : connector.getEnds()) {
                Property partWithPort = end.getPartWithPort();
                if (partWithPort == null) continue;
                return partWithPort;
            }
        }
        return null;
    }

    public static boolean canCreate(EObject source, EObject target, View sourceView, View targetView) {
        if (source != null && !(source instanceof ConnectableElement)) {
            return false;
        }
        if (target != null && !(target instanceof ConnectableElement)) {
            return false;
        }
        if (sourceView != null && targetView != null) {
            if (sourceView.getChildren().contains((Object)targetView) || targetView.getChildren().contains((Object)sourceView)) {
                return false;
            }
            if (new ConnectorUtils().getStructureContainers(sourceView).contains(targetView) || new ConnectorUtils().getStructureContainers(targetView).contains(sourceView)) {
                return false;
            }
        }
        return true;
    }

    public static List<Connector> filterConnectorByPropertyInNestedConnectorEnd(List<Connector> connectors, Property part) {
        ArrayList<Connector> res = new ArrayList<Connector>();
        for (Connector connector : connectors) {
            EList ends = connector.getEnds();
            for (ConnectorEnd connectorEnd : ends) {
                NestedConnectorEnd stereotypeApplication = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)connectorEnd, NestedConnectorEnd.class);
                if (stereotypeApplication == null) continue;
                EList propertyPath = stereotypeApplication.getPropertyPath();
                for (Property property : propertyPath) {
                    if (!property.equals(part)) continue;
                    res.add(connector);
                }
            }
        }
        return res;
    }
}

