/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation.typing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.alf.alf.AcceptClause;
import org.eclipse.papyrus.uml.alf.alf.AcceptStatement;
import org.eclipse.papyrus.uml.alf.alf.AlfPackage;
import org.eclipse.papyrus.uml.alf.alf.ClassificationExpression;
import org.eclipse.papyrus.uml.alf.alf.Expression;
import org.eclipse.papyrus.uml.alf.alf.InvocationOrAssignementOrDeclarationStatement;
import org.eclipse.papyrus.uml.alf.alf.LocalNameDeclarationStatement;
import org.eclipse.papyrus.uml.alf.alf.LoopVariableDefinition;
import org.eclipse.papyrus.uml.alf.alf.NameExpression;
import org.eclipse.papyrus.uml.alf.alf.NamedTemplateBinding;
import org.eclipse.papyrus.uml.alf.alf.QualifiedNameWithBinding;
import org.eclipse.papyrus.uml.alf.alf.SequenceExpansionExpression;
import org.eclipse.papyrus.uml.alf.alf.SuperInvocationExpression;
import org.eclipse.papyrus.uml.alf.alf.UnqualifiedName;
import org.eclipse.papyrus.uml.alf.scoping.AlfScopeProvider;
import org.eclipse.papyrus.uml.alf.validation.typing.ErrorTypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeUtils;
import org.eclipse.papyrus.uml.alf.validation.typing.VoidFacade;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TypedElement;

public class TypeFacadeFactory {
    public static TypeFacadeFactory eInstance = new TypeFacadeFactory();

    public TypeFacade createTypeFacade(EObject typeObject) {
        TypeFacade result = new TypeFacade(){

            public String getLabelWithoutBinding() {
                try {
                    if (this.typeObject instanceof Classifier) {
                        return ((Classifier)this.typeObject).getName();
                    }
                    if (this.typeObject instanceof ElementImport) {
                        ElementImport eImport = (ElementImport)this.typeObject;
                        if (eImport.getAlias() != null) {
                            return eImport.getAlias();
                        }
                        return ((Classifier)eImport.getImportedElement()).getName();
                    }
                    if (this.typeObject instanceof Parameter) {
                        return ((Parameter)this.typeObject).getType().getName();
                    }
                    if (this.typeObject instanceof TypedElement) {
                        return ((TypedElement)this.typeObject).getType().getName();
                    }
                    if (this.typeObject instanceof SequenceExpansionExpression) {
                        TypeFacade t = eInstance.createTypeFacade(this.typeObject);
                        return t.extractActualType().getName();
                    }
                }
                catch (NullPointerException e) {
                    return "any";
                }
                return super.getLabel();
            }

            public String getLabel() {
                try {
                    if (this.typeObject instanceof Classifier) {
                        return String.valueOf(((Classifier)this.typeObject).getName()) + super.getLabel();
                    }
                    if (this.typeObject instanceof ElementImport) {
                        ElementImport eImport = (ElementImport)this.typeObject;
                        if (eImport.getAlias() != null) {
                            return String.valueOf(eImport.getAlias()) + super.getLabel();
                        }
                        return String.valueOf(((Classifier)eImport.getImportedElement()).getName()) + super.getLabel();
                    }
                    if (this.typeObject instanceof Parameter) {
                        return String.valueOf(((Parameter)this.typeObject).getType().getName()) + super.getLabel();
                    }
                    if (this.typeObject instanceof TypedElement) {
                        return String.valueOf(((TypedElement)this.typeObject).getType().getName()) + super.getLabel();
                    }
                    if (this.typeObject instanceof SequenceExpansionExpression) {
                        TypeFacade t = eInstance.createTypeFacade(this.typeObject);
                        return String.valueOf(t.extractActualType().getName()) + super.getLabel();
                    }
                    if (this.typeObject == null) {
                        return "any";
                    }
                }
                catch (NullPointerException e) {
                    return "any";
                }
                return super.getLabel();
            }
        };
        if (typeObject instanceof Classifier) {
            result.setTypeObject(typeObject);
        } else if (typeObject instanceof ElementImport) {
            result.setTypeObject(typeObject);
        } else if (typeObject instanceof Parameter) {
            result.setTypeObject(typeObject);
        } else if (typeObject instanceof LocalNameDeclarationStatement) {
            LocalNameDeclarationStatement statement = (LocalNameDeclarationStatement)typeObject;
            if (statement.getType() != null) {
                result.setTypeObject(this.createVoidFacade((QualifiedNameWithBinding)statement.getType()).typeObject);
            }
        } else if (typeObject instanceof LoopVariableDefinition) {
            LoopVariableDefinition loopVariable = (LoopVariableDefinition)typeObject;
            if (loopVariable.getType() != null) {
                result.setTypeObject(this.createVoidFacade((QualifiedNameWithBinding)loopVariable.getType()).typeObject);
            } else if (loopVariable.getExpression1() != null) {
                TypeExpression typeOfExpression1 = new TypeUtils().getTypeOfExpression(loopVariable.getExpression1());
                if (loopVariable.getExpression2() != null) {
                    int _2_1_compatibility;
                    TypeExpression typeOfExpression2 = new TypeUtils().getTypeOfExpression(loopVariable.getExpression2());
                    int _1_2_compatibility = typeOfExpression1.isCompatibleWithMe(typeOfExpression2);
                    if (_1_2_compatibility == (_2_1_compatibility = typeOfExpression2.isCompatibleWithMe(typeOfExpression1))) {
                        if (_1_2_compatibility != 0) {
                            result.setTypeObject(typeOfExpression1.getTypeFacade().typeObject);
                        }
                    } else if (_1_2_compatibility > _2_1_compatibility) {
                        result.setTypeObject(typeOfExpression1.getTypeFacade().typeObject);
                    } else {
                        result.setTypeObject(typeOfExpression2.getTypeFacade().typeObject);
                    }
                } else {
                    result.setTypeObject(typeOfExpression1.getTypeFacade().typeObject);
                }
            }
        } else if (typeObject instanceof Property) {
            result.setTypeObject(typeObject);
        } else if (typeObject instanceof SequenceExpansionExpression) {
            result.setTypeObject(typeObject);
        } else if (typeObject instanceof AcceptStatement) {
            AcceptClause acceptClause = ((AcceptStatement)typeObject).getClause();
            if (acceptClause.getQualifiedNameList() != null && !acceptClause.getQualifiedNameList().getQualifiedName().isEmpty()) {
                TypeFacade f = eInstance.createVoidFacade((QualifiedNameWithBinding)acceptClause.getQualifiedNameList().getQualifiedName().get(0));
                result.setTypeObject((EObject)f.extractActualType());
            } else {
                result.setTypeObject(typeObject);
            }
        }
        return result;
    }

    public ErrorTypeFacade createErrorTypeFacade(String message, EObject source, EStructuralFeature structuralFeature) {
        ErrorTypeFacade result = new ErrorTypeFacade();
        result.setMessage(message);
        result.setErrorSource(source);
        result.setStructuralFeature(structuralFeature);
        return result;
    }

    public TypeFacade createVoidFacade(Expression exp) {
        NameExpression actualNameExpression = null;
        TreeIterator i = exp.eAllContents();
        while (i.hasNext() && actualNameExpression == null) {
            EObject o = (EObject)i.next();
            if (!(o instanceof NameExpression)) continue;
            actualNameExpression = (NameExpression)o;
        }
        if (actualNameExpression == null) {
            return this.createErrorTypeFacade("A type expression is expected", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getConditionalTestExpression_Exp());
        }
        return this.createVoidFacade(actualNameExpression);
    }

    public TypeFacade createVoidFacade(NameExpression exp) {
        EObject container;
        EObject previousPackage = null;
        if (exp.getPath() != null) {
            EList<UnqualifiedName> path = exp.getPath().getNamespace();
            List<EObject> visiblePackages = AlfScopeProvider.scopingTool.getVisiblePackages(exp).resolveByName(((UnqualifiedName)path.get(0)).getName());
            if (visiblePackages.isEmpty()) {
                return this.createErrorTypeFacade("Could not resolve package " + ((UnqualifiedName)path.get(0)).getName(), (EObject)path.get(0), (EStructuralFeature)AlfPackage.eINSTANCE.getUnqualifiedName_Name());
            }
            if (visiblePackages.size() > 1) {
                return this.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(0)).getName()) + " resolves to multiple packages", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
            }
            previousPackage = visiblePackages.get(0);
            int i = 1;
            while (i < path.size()) {
                List<EObject> nestedVisiblePackages = AlfScopeProvider.scopingTool.getVisiblePackages(previousPackage).resolveByName(((UnqualifiedName)path.get(i)).getName());
                if (nestedVisiblePackages.isEmpty()) {
                    return this.createErrorTypeFacade("Could not resolve package " + ((UnqualifiedName)path.get(i)).getName(), (EObject)path.get(i), (EStructuralFeature)AlfPackage.eINSTANCE.getUnqualifiedName_Name());
                }
                if (nestedVisiblePackages.size() > 1) {
                    return this.createErrorTypeFacade(String.valueOf(((UnqualifiedName)path.get(i)).getName()) + " resolves to multiple packages", exp.getPath(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNamePath_Namespace());
                }
                previousPackage = nestedVisiblePackages.get(0);
                ++i;
            }
        }
        if ((container = exp.eContainer()) instanceof InvocationOrAssignementOrDeclarationStatement) {
            InvocationOrAssignementOrDeclarationStatement cddDclStatement = (InvocationOrAssignementOrDeclarationStatement)container;
            if (cddDclStatement.getVariableDeclarationCompletion() != null) {
                if (cddDclStatement.getTypePart_OR_assignedPart_OR_invocationPart().getSuffix() != null) {
                    return this.createErrorTypeFacade("A type expression is expected", cddDclStatement, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
                }
                if (exp.getInvocationCompletion() != null || exp.getPostfixOp() != null || exp.getPrefixOp() != null || exp.getSequenceConstructionCompletion() != null) {
                    return this.createErrorTypeFacade("A type expression is expected", cddDclStatement, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
                }
                List<EObject> visibleClassifiers = null;
                visibleClassifiers = previousPackage == null ? AlfScopeProvider.scopingTool.getVisibleClassifiers(exp).resolveByName(exp.getId()) : AlfScopeProvider.scopingTool.getVisibleClassifiers(previousPackage).resolveByName(exp.getId());
                if (visibleClassifiers.isEmpty()) {
                    return this.createErrorTypeFacade("Could not resolve classifier " + exp.getId(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                }
                if (visibleClassifiers.size() > 1) {
                    return this.createErrorTypeFacade(String.valueOf(exp.getId()) + " resolves to multiple classifiers", cddDclStatement, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
                }
                return new VoidFacade(this.createTypeFacade(visibleClassifiers.get(0)));
            }
        } else if (!(container instanceof ClassificationExpression)) {
            boolean cfr_ignored_0 = container instanceof SuperInvocationExpression;
        }
        List<EObject> visibleClassifiers = null;
        visibleClassifiers = previousPackage == null ? AlfScopeProvider.scopingTool.getVisibleClassifiers(exp).resolveByName(exp.getId()) : AlfScopeProvider.scopingTool.getVisibleClassifiers(previousPackage).resolveByName(exp.getId());
        if (visibleClassifiers.isEmpty()) {
            return this.createErrorTypeFacade("Could not resolve classifier " + exp.getId(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
        }
        if (visibleClassifiers.size() > 1) {
            return this.createErrorTypeFacade(String.valueOf(exp.getId()) + " resolves to multiple classifiers", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getNameExpression_Id());
        }
        return new VoidFacade(this.createTypeFacade(visibleClassifiers.get(0)));
    }

    public TypeFacade createVoidFacade(QualifiedNameWithBinding exp) {
        QualifiedNameWithBinding remaining = exp;
        EObject previousPackage = null;
        if (exp.getRemaining() != null) {
            List<EObject> visiblePackages = AlfScopeProvider.scopingTool.getVisiblePackages(exp).resolveByName(exp.getId());
            if (visiblePackages.isEmpty()) {
                return this.createErrorTypeFacade("Could not resolve package " + exp.getId(), exp, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameWithBinding_Id());
            }
            if (visiblePackages.size() > 1) {
                return this.createErrorTypeFacade(String.valueOf(exp.getId()) + " resolves to multiple packages", exp, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameWithBinding_Id());
            }
            previousPackage = visiblePackages.get(0);
            remaining = exp.getRemaining();
            while (remaining.getRemaining() != null) {
                List<EObject> nestedVisiblePackages = AlfScopeProvider.scopingTool.getVisiblePackages(previousPackage).resolveByName(remaining.getId());
                if (nestedVisiblePackages.isEmpty()) {
                    return this.createErrorTypeFacade("Could not resolve package " + remaining.getId(), remaining, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameWithBinding_Id());
                }
                if (nestedVisiblePackages.size() > 1) {
                    return this.createErrorTypeFacade(String.valueOf(remaining.getId()) + " resolves to multiple packages", remaining, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameWithBinding_Id());
                }
                previousPackage = nestedVisiblePackages.get(0);
                remaining = remaining.getRemaining();
            }
        }
        List<EObject> visibleClassifiers = null;
        visibleClassifiers = previousPackage != null ? AlfScopeProvider.scopingTool.getVisibleClassifiers(previousPackage).resolveByName(remaining.getId()) : AlfScopeProvider.scopingTool.getVisibleClassifiers(exp).resolveByName(remaining.getId());
        if (visibleClassifiers.isEmpty()) {
            return this.createErrorTypeFacade("Could not resolve classifier " + remaining.getId(), remaining, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameWithBinding_Id());
        }
        if (visibleClassifiers.size() > 1) {
            return this.createErrorTypeFacade(String.valueOf(remaining.getId()) + " resolves to multiple classifiers.", remaining, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameWithBinding_Id());
        }
        Classifier resolvedClassifier = (Classifier)visibleClassifiers.get(0);
        if (!resolvedClassifier.isTemplate()) {
            if (remaining.getBinding() != null) {
                return this.createErrorTypeFacade(String.valueOf(remaining.getId()) + " is not a template", remaining, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameWithBinding_Binding());
            }
            return new VoidFacade(this.createTypeFacade(visibleClassifiers.get(0)));
        }
        if (remaining.getBinding() != null) {
            ArrayList<ParameterableElement> orderedListOfParameteredElements = new ArrayList<ParameterableElement>();
            HashMap<String, ParameterableElement> mapOfParameteredElements = new HashMap<String, ParameterableElement>();
            for (TemplateParameter tp : resolvedClassifier.getOwnedTemplateSignature().getOwnedParameters()) {
                ParameterableElement p = tp.getParameteredElement();
                if (p == null) continue;
                orderedListOfParameteredElements.add(p);
                mapOfParameteredElements.put(((NamedElement)p).getName(), p);
            }
            HashMap<TemplateParameter, Classifier> substitutionsMap = new HashMap<TemplateParameter, Classifier>();
            for (NamedTemplateBinding ntp : remaining.getBinding().getBindings()) {
                ParameterableElement formal = (ParameterableElement)mapOfParameteredElements.get(ntp.getFormal());
                if (formal == null) {
                    return this.createErrorTypeFacade("Template parameter " + ntp.getFormal() + " is undefined for classifier " + remaining.getId(), ntp, (EStructuralFeature)AlfPackage.eINSTANCE.getNamedTemplateBinding_Formal());
                }
                TypeFacade actual = this.createVoidFacade(ntp.getActual());
                if (actual instanceof ErrorTypeFacade) {
                    return actual;
                }
                substitutionsMap.put(formal.getTemplateParameter(), actual.extractActualType());
            }
            if (remaining.getBinding().getBindings().size() != orderedListOfParameteredElements.size()) {
                String errorMessage = "";
                errorMessage = remaining.getBinding().getBindings().size() > orderedListOfParameteredElements.size() ? "Too many template bindings specified for " + remaining.getId() : "Template bindings are missing for " + remaining.getId();
                return this.createErrorTypeFacade(errorMessage, remaining, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameWithBinding_Binding());
            }
            VoidFacade boundResolvedClassifier = new VoidFacade(this.createTypeFacade(visibleClassifiers.get(0)));
            return boundResolvedClassifier;
        }
        return new VoidFacade(this.createTypeFacade(visibleClassifiers.get(0)));
    }
}

