/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.papyrus.uml.diagram.common.Activator;

public class UpdatePortLocationCommand
extends AbstractTransactionalCommand {
    private IBorderItemEditPart borderItemEditPart;
    private GraphicalEditPart parentEditPart;
    private final int borderItemSide;
    private ChangeBoundsRequest request;

    public UpdatePortLocationCommand(TransactionalEditingDomain domain, ChangeBoundsRequest request, GraphicalEditPart parentEditPart, IBorderItemEditPart borderItemEditPart, int borderItemSide) {
        super(domain, "Update port location command", null);
        this.borderItemEditPart = borderItemEditPart;
        this.parentEditPart = parentEditPart;
        this.borderItemSide = borderItemSide;
        this.request = request;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Shape parentShape = (Shape)this.parentEditPart.getNotationView();
        Bounds parentBounds = (Bounds)parentShape.getLayoutConstraint();
        int borderItemOffset = 10;
        Shape borderItemShape = (Shape)this.borderItemEditPart.getNotationView();
        Bounds borderItemBounds = (Bounds)borderItemShape.getLayoutConstraint();
        switch (this.borderItemSide) {
            case 1: {
                borderItemBounds.setY(-borderItemOffset);
                break;
            }
            case 17: {
                borderItemBounds.setX(parentBounds.getWidth() - borderItemOffset);
                borderItemBounds.setY(-borderItemOffset);
                break;
            }
            case 16: {
                borderItemBounds.setX(parentBounds.getWidth() - borderItemOffset);
                break;
            }
            case 20: {
                borderItemBounds.setX(parentBounds.getWidth() - borderItemOffset);
                borderItemBounds.setY(parentBounds.getHeight() - borderItemOffset);
                break;
            }
            case 4: {
                borderItemBounds.setY(parentBounds.getHeight() - borderItemOffset);
                break;
            }
            case 12: {
                borderItemBounds.setX(-borderItemOffset);
                borderItemBounds.setY(parentBounds.getHeight() - borderItemOffset);
                break;
            }
            case 8: {
                borderItemBounds.setX(-borderItemOffset);
                break;
            }
            case 9: {
                borderItemBounds.setX(-borderItemOffset);
                borderItemBounds.setY(-borderItemOffset);
                break;
            }
            default: {
                Activator.log.warn("Unknown position value has been received");
            }
        }
        int resizeDirection = this.request.getResizeDirection();
        if (this.request.isConstrainedResize()) {
            Point delta = this.request.getMoveDelta();
            if (resizeDirection == 1) {
                switch (this.borderItemSide) {
                    case 8: 
                    case 16: {
                        borderItemBounds.setY(borderItemBounds.getY() - delta.y);
                        break;
                    }
                }
            } else if (resizeDirection == 8) {
                switch (this.borderItemSide) {
                    case 1: 
                    case 4: {
                        borderItemBounds.setX(borderItemBounds.getX() - delta.x);
                        break;
                    }
                }
            } else if (resizeDirection == 9) {
                switch (this.borderItemSide) {
                    case 1: 
                    case 4: {
                        borderItemBounds.setX(borderItemBounds.getX() - delta.x);
                        break;
                    }
                    case 8: 
                    case 16: {
                        borderItemBounds.setY(borderItemBounds.getY() - delta.y);
                        break;
                    }
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

