/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.dialogs;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.uml.diagram.common.messages.Messages;
import org.eclipse.papyrus.uml.diagram.common.util.EdgeEndsMapper;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOrShowExistingLinkDialog
extends MessageDialog {
    public static final int CREATE = 0;
    public static final int RESTORE_SELECTED_LINK = 1;
    public static final int CANCEL = 2;
    public static final String DIALOG_TITLE = Messages.CreateOrShowExistingLinkDialog_ShowOrCreate;
    private static final String CREATE_STRING = Messages.CreateOrShowExistingLinkDialog_Create;
    private static final String RESTORE_SELECTION = Messages.CreateOrShowExistingLinkDialog_RestoreSelection;
    private static final String CANCEL_STRING = "Cancel";
    private static final String NAME = Messages.CreateOrShowExistingLinkDialog_Name;
    private static final String ENDS = Messages.CreateOrShowExistingLinkDialog_Ends;
    private static final String SOURCES = Messages.CreateOrShowExistingLinkDialog_Sources;
    private static final String TARGETS = Messages.CreateOrShowExistingLinkDialog_Targets;
    private static final int COLUMN_NAME_SIZE = 150;
    private static final int COLUMN_SIZE = 200;
    private final List<EdgeEndsMapper> existingLinks;
    final UMLLabelProvider labelProvider = new UMLLabelProvider();
    private static final String NOT_AVAILABLE = "N/A";
    private static final String CHECKED_ICON_PATH = "icons/checkedRadioButton.gif";
    private static final String UNCHECKED_ICON_PATH = "icons/uncheckedRadioButton.gif";
    private int selectedElementIndex = 0;
    private EObject result = null;

    public CreateOrShowExistingLinkDialog(String dialogTitle, String dialogMessage, List<EdgeEndsMapper> elements) {
        super(Display.getDefault().getActiveShell(), dialogTitle, null, dialogMessage, 3, new String[]{CREATE_STRING, RESTORE_SELECTION, CANCEL_STRING}, 1);
        this.existingLinks = elements;
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(false);
        column.setMoveable(false);
        return viewerColumn;
    }

    protected Control createCustomArea(final Composite parent) {
        Composite composite = parent;
        final TableViewer viewer = new TableViewer(composite, 68354);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        TableViewerColumn colCheckbox = this.createTableViewerColumn("", 20, viewer);
        colCheckbox.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                if (CreateOrShowExistingLinkDialog.this.existingLinks.get(CreateOrShowExistingLinkDialog.this.selectedElementIndex) == element) {
                    return Activator.getDefault().getImage("org.eclipse.papyrus.uml.diagram.common", CreateOrShowExistingLinkDialog.CHECKED_ICON_PATH);
                }
                return Activator.getDefault().getImage("org.eclipse.papyrus.uml.diagram.common", CreateOrShowExistingLinkDialog.UNCHECKED_ICON_PATH);
            }
        });
        colCheckbox.setEditingSupport(new EditingSupport((ColumnViewer)viewer){
            private CheckboxCellEditor checkboxCellEditor;

            protected void setValue(Object element, Object value) {
                if (this.checkboxCellEditor.getValue() == Boolean.TRUE) {
                    CreateOrShowExistingLinkDialog.this.selectedElementIndex = CreateOrShowExistingLinkDialog.this.existingLinks.indexOf(element);
                }
                for (EdgeEndsMapper current : CreateOrShowExistingLinkDialog.this.existingLinks) {
                    viewer.update((Object)current, null);
                }
            }

            protected Object getValue(Object element) {
                if (CreateOrShowExistingLinkDialog.this.existingLinks.get(CreateOrShowExistingLinkDialog.this.selectedElementIndex) == element) {
                    return true;
                }
                return false;
            }

            protected CellEditor getCellEditor(Object element) {
                this.checkboxCellEditor = new CheckboxCellEditor(parent, 40);
                return this.checkboxCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn columnName = this.createTableViewerColumn(NAME, 150, viewer);
        this.configureColumn(columnName);
        columnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EdgeEndsMapper) {
                    return CreateOrShowExistingLinkDialog.this.labelProvider.getText((Object)((EdgeEndsMapper)element).getLink());
                }
                return CreateOrShowExistingLinkDialog.NOT_AVAILABLE;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        TableViewerColumn columnEnds = this.createTableViewerColumn(ENDS, 200, viewer);
        this.configureColumn(columnEnds);
        columnEnds.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EdgeEndsMapper) {
                    return CreateOrShowExistingLinkDialog.this.getLabel(((EdgeEndsMapper)element).getEnds());
                }
                return CreateOrShowExistingLinkDialog.NOT_AVAILABLE;
            }
        });
        TableViewerColumn columnSources = this.createTableViewerColumn(SOURCES, 200, viewer);
        this.configureColumn(columnSources);
        columnSources.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EdgeEndsMapper) {
                    return CreateOrShowExistingLinkDialog.this.getLabel(((EdgeEndsMapper)element).getSources());
                }
                return CreateOrShowExistingLinkDialog.NOT_AVAILABLE;
            }
        });
        TableViewerColumn columnTargets = this.createTableViewerColumn(TARGETS, 200, viewer);
        this.configureColumn(columnTargets);
        columnTargets.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EdgeEndsMapper) {
                    return CreateOrShowExistingLinkDialog.this.getLabel(((EdgeEndsMapper)element).getTargets());
                }
                return CreateOrShowExistingLinkDialog.NOT_AVAILABLE;
            }
        });
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.setInput(this.existingLinks);
        parent.pack();
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1 && this.existingLinks.size() >= this.selectedElementIndex) {
            this.result = this.existingLinks.get(this.selectedElementIndex).getLink();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureColumn(TableViewerColumn viewerColumn) {
        viewerColumn.getColumn().setMoveable(true);
        viewerColumn.getColumn().setResizable(true);
    }

    private String getLabel(Collection<?> list) {
        if (list != null) {
            StringBuilder builder = new StringBuilder();
            Iterator<?> iter = list.iterator();
            while (iter.hasNext()) {
                builder.append(this.labelProvider.getText(iter.next()));
                if (!iter.hasNext()) continue;
                builder.append(",");
            }
            return builder.toString();
        }
        return NOT_AVAILABLE;
    }

    public EObject getResult() {
        return this.result;
    }
}

