/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.MaskLabelHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMaskManagedEditPolicy
extends GraphicalEditPolicyEx
implements NotificationListener,
IPapyrusListener,
IMaskManagedLabelEditPolicy {
    protected Element hostSemanticElement;

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.hostSemanticElement = this.initSemanticElement();
        if (this.hostSemanticElement != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
            this.getDiagramEventBroker().addNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
            this.addAdditionalListeners();
            this.refreshDisplay();
        } else {
            Activator.log.error("No semantic element was found during activation of the mask managed label edit policy", null);
        }
    }

    protected Element initSemanticElement() {
        return (Element)this.getView().getElement();
    }

    protected void addAdditionalListeners() {
    }

    public void refresh() {
        super.refresh();
        this.refreshDisplay();
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
        if (this.hostSemanticElement != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.hostSemanticElement, (NotificationListener)this);
            this.removeAdditionalListeners();
        }
        this.hostSemanticElement = null;
    }

    protected void removeAdditionalListeners() {
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public Element getUMLElement() {
        return this.hostSemanticElement;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected boolean isMaskManagedAnnotation(Object object) {
        return object instanceof EAnnotation && "CustomAppearance_Annotation".equals(((EAnnotation)object).getSource());
    }

    protected boolean isRemovedMaskManagedLabelAnnotation(Object object, Notification notification) {
        Object oldValue;
        if (object instanceof EModelElement && notification.getEventType() == 4 && (oldValue = notification.getOldValue()) instanceof EAnnotation) {
            return "CustomAppearance_Annotation".equals(((EAnnotation)oldValue).getSource());
        }
        return false;
    }

    public abstract void refreshDisplay();

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object != null && object.equals(this.getView())) {
            this.refreshDisplay();
        }
    }

    public void setDefaultDisplayValue() {
        MaskLabelHelper.unsetMaskValues((View)((View)this.getHost().getModel()));
    }

    public void updateDisplayValue(Collection<String> newValue) {
        MaskLabelHelper.setMaskValues((View)((View)this.getHost().getModel()), newValue);
    }

    public Collection<String> getCurrentDisplayValue() {
        Collection maskValues = MaskLabelHelper.getMaskValues((View)((View)this.getHost().getModel()));
        if (maskValues == null) {
            return this.getDefaultDisplayValue();
        }
        return maskValues;
    }

    protected abstract Collection<String> getDefaultDisplayValue();
}

