/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.papyrus.uml.tools.utils.OperationUtil;
import org.eclipse.uml2.uml.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationLabelHelper
extends StereotypedElementLabelHelper {
    private static OperationLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();

    public static OperationLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new OperationLabelHelper();
        }
        return labelHelper;
    }

    protected OperationLabelHelper() {
        this.masks.put("visibility", "Visibility");
        this.masks.put("name", "Name");
        this.masks.put("parametersName", "Parameters Name");
        this.masks.put("parametersDirection", "Parameters Direction");
        this.masks.put("parametersType", "Parameters Type");
        this.masks.put("returnType", "Return Type");
        this.masks.put("parametersMultiplicity", "Parameters Multiplicity");
        this.masks.put("parametersDefault", "Parameters Default Value");
        this.masks.put("parametersModifiers", "Parameters Modifiers");
        this.masks.put("modifiers", "Modifiers");
    }

    @Override
    protected String elementLabel(GraphicalEditPart editPart) {
        Collection displayValue = ICustomAppearance.DEFAULT_UML_OPERATION;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        return OperationUtil.getCustomLabel((Operation)this.getUMLElement(editPart), (Collection)displayValue);
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public Operation getUMLElement(GraphicalEditPart editPart) {
        return (Operation)((View)editPart.getModel()).getElement();
    }
}

