/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StereotypedElementLabelHelper {
    public Element getUMLElement(GraphicalEditPart editPart) {
        return UMLUtil.resolveUMLElement((Object)editPart);
    }

    protected Map<String, List<String>> parseStereotypeProperties(GraphicalEditPart editPart, String stereotypesToDisplay, String stereotypesPropertiesToDisplay) {
        HashMap<String, List<String>> propertiesMap = new HashMap<String, List<String>>();
        StringTokenizer stringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String propertyName = stringTokenizer.nextToken();
            String stereotypeName = propertyName.substring(0, propertyName.lastIndexOf("."));
            if (!propertiesMap.containsKey(stereotypeName)) {
                ArrayList propertiesForStereotype = new ArrayList();
                propertiesMap.put(stereotypeName, propertiesForStereotype);
            }
            ((List)propertiesMap.get(stereotypeName)).add(propertyName.substring(propertyName.lastIndexOf(".") + 1, propertyName.length()));
        }
        return propertiesMap;
    }

    public Collection<Image> stereotypeIconsToDisplay(GraphicalEditPart editPart) {
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)editPart.getModel()));
        if (stereotypespresentationKind == null) {
            return null;
        }
        if (stereotypespresentationKind.equals("IconStereotype") || stereotypespresentationKind.equals("TextIconStereotype")) {
            String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)editPart.getModel()));
            ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
            StringTokenizer tokenizer = new StringTokenizer(stereotypesToDisplay, ",");
            while (tokenizer.hasMoreTokens()) {
                String firstStereotypeName = tokenizer.nextToken();
                stereotypes.add(this.getUMLElement(editPart).getAppliedStereotype(firstStereotypeName));
            }
            return Activator.getIconElements(this.getUMLElement(editPart), stereotypes, false);
        }
        return new ArrayList<Image>();
    }

    public String stereotypesAndPropertiesToDisplay(GraphicalEditPart editPart, String separator, String stereotypesToDisplay, String stereotypeWithQualifiedName, String stereotypesPropertiesToDisplay) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        assert (store != null) : "The preference store was not found";
        if (store == null) {
            return "";
        }
        String sNameAppearance = store.getString("ProfileApplicationPreferenceConstants.stereotype.name.appearance");
        Map<String, List<String>> propertiesToDisplay = this.parseStereotypeProperties(editPart, stereotypesToDisplay, stereotypesPropertiesToDisplay);
        StringTokenizer strQualifiedName = new StringTokenizer(stereotypesToDisplay, ",");
        String out = "";
        while (strQualifiedName.hasMoreElements()) {
            List<String> properties;
            String currentStereotype = strQualifiedName.nextToken();
            Element umlElement = this.getUMLElement(editPart);
            Stereotype stereotype = umlElement.getAppliedStereotype(currentStereotype);
            if (stereotype == null) continue;
            String name = currentStereotype;
            if (stereotypeWithQualifiedName.indexOf(currentStereotype) == -1) {
                StringTokenizer strToken = new StringTokenizer(currentStereotype, "::");
                while (strToken.hasMoreTokens()) {
                    name = strToken.nextToken();
                }
            }
            if (sNameAppearance.equals("User Controlled")) {
                if (out.indexOf(name) == -1) {
                    out = String.valueOf(out) + Activator.ST_LEFT + name + Activator.ST_RIGHT + separator;
                }
            } else if (out.indexOf(name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1, name.length())) == -1) {
                out = String.valueOf(out) + Activator.ST_LEFT + name + Activator.ST_RIGHT + separator;
            }
            if ((properties = propertiesToDisplay.get(stereotype.getQualifiedName())) == null) continue;
            for (String propertyName : properties) {
                out = String.valueOf(out) + StereotypeUtil.displayPropertyValue((Stereotype)stereotype, (Property)StereotypeUtil.getPropertyByName((Stereotype)stereotype, (String)propertyName), (Element)this.getUMLElement(editPart), (String)" ");
            }
        }
        if (out.endsWith(",")) {
            return out.substring(0, out.length() - 1);
        }
        if (out.endsWith(separator)) {
            return out.substring(0, out.length() - separator.length());
        }
        return out;
    }

    public String stereotypesToDisplay(GraphicalEditPart editPart) {
        View view = (View)editPart.getModel();
        String stereotypesPropertiesToDisplay = AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)view);
        String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)view);
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)view);
        if ("IconStereotype".equals(stereotypespresentationKind)) {
            return StereotypeUtil.getPropertiesValuesInBrace((String)stereotypesPropertiesToDisplay, (Element)this.getUMLElement(editPart));
        }
        String stereotypesToDisplayWithQN = AppliedStereotypeHelper.getStereotypesQNToDisplay((EModelElement)view);
        String display = "";
        if ("VerticalStereo".equals(stereotypespresentationKind)) {
            display = String.valueOf(display) + this.stereotypesAndPropertiesToDisplay(editPart, "\n", stereotypesToDisplay, stereotypesToDisplayWithQN, stereotypesPropertiesToDisplay);
        } else {
            String propSt;
            String st = this.stereotypesToDisplay(editPart, ", ", stereotypesToDisplay, stereotypesToDisplayWithQN);
            if (st != null && !st.equals("")) {
                display = String.valueOf(display) + Activator.ST_LEFT + st + Activator.ST_RIGHT + " ";
            }
            if ((propSt = StereotypeUtil.getPropertiesValuesInBrace((String)stereotypesPropertiesToDisplay, (Element)this.getUMLElement(editPart))) != null && !propSt.equals("")) {
                if (st != null) {
                    st.equals("");
                }
                display = String.valueOf(display) + "{" + propSt + "} ";
            }
        }
        return display;
    }

    public String stereotypesToDisplay(GraphicalEditPart editPart, String separator, String stereotypesToDisplay, String stereotypeWithQualifiedName) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        assert (store != null) : "The preference store was not found";
        if (store == null) {
            return "";
        }
        String sNameAppearance = store.getString("ProfileApplicationPreferenceConstants.stereotype.name.appearance");
        StringTokenizer strQualifiedName = new StringTokenizer(stereotypesToDisplay, ",");
        String out = "";
        while (strQualifiedName.hasMoreElements()) {
            String currentStereotype = strQualifiedName.nextToken();
            Element umlElement = this.getUMLElement(editPart);
            Stereotype stereotype = umlElement.getAppliedStereotype(currentStereotype);
            if (stereotype == null) continue;
            String name = currentStereotype;
            if (stereotypeWithQualifiedName.indexOf(currentStereotype) == -1) {
                StringTokenizer strToken = new StringTokenizer(currentStereotype, "::");
                while (strToken.hasMoreTokens()) {
                    name = strToken.nextToken();
                }
            }
            if (sNameAppearance.equals("User Controlled")) {
                if (out.indexOf(name) != -1) continue;
                out = String.valueOf(out) + name + separator;
                continue;
            }
            if (out.indexOf(name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1, name.length())) != -1) continue;
            out = String.valueOf(out) + name + separator;
        }
        if (out.endsWith(",")) {
            return out.substring(0, out.length() - 1);
        }
        if (out.endsWith(separator)) {
            return out.substring(0, out.length() - separator.length());
        }
        return out;
    }

    public void refreshEditPartDisplay(GraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        Collection<Image> imageToDisplay = this.stereotypeIconsToDisplay(editPart);
        if (AppearanceHelper.showElementIcon((EModelElement)((View)editPart.getModel()))) {
            imageToDisplay.add(this.getImage(editPart));
        }
        int i = 0;
        if (figure instanceof WrappingLabel) {
            while (((WrappingLabel)figure).getIcon(i) != null) {
                ((WrappingLabel)figure).setIcon(null, i);
                ++i;
            }
            i = 0;
            for (Image image : imageToDisplay) {
                ((WrappingLabel)figure).setIcon(image, i);
                ++i;
            }
            ((WrappingLabel)figure).setText(this.labelToDisplay(editPart));
        }
    }

    protected String labelToDisplay(GraphicalEditPart editPart) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.stereotypesToDisplay(editPart));
        buffer.append(this.elementLabel(editPart));
        return buffer.toString();
    }

    protected abstract String elementLabel(GraphicalEditPart var1);

    public Image getImage(GraphicalEditPart editPart) {
        Element element = this.getUMLElement(editPart);
        String key = "";
        if (element instanceof NamedElement) {
            key = String.valueOf(((NamedElement)element).getName()) + "::" + ((NamedElement)element).getVisibility();
        } else if (element != null) {
            key = element.getClass().getName();
        } else {
            return null;
        }
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(key);
        ImageDescriptor descriptor = null;
        if (image == null) {
            AdapterFactory factory = Activator.getDefault().getItemProvidersAdapterFactory();
            IItemLabelProvider labelProvider = (IItemLabelProvider)factory.adapt((Notifier)this.getUMLElement(editPart), IItemLabelProvider.class);
            if (labelProvider != null) {
                descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)this.getUMLElement(editPart)));
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            imageRegistry.put(key, descriptor);
            image = imageRegistry.get(key);
        }
        return image;
    }
}

