/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteToolbar;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.gmf.runtime.common.ui.util.ActivityUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.ContributeToPaletteOperation;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.IPaletteProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteService;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.SelectionToolEx;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.common.part.IPaletteDescription;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.part.PapyrusPalettePreferences;
import org.eclipse.papyrus.uml.diagram.common.service.ExtendedPaletteProviderConfiguration;
import org.eclipse.papyrus.uml.diagram.common.service.IPapyrusPaletteConstant;
import org.eclipse.papyrus.uml.diagram.common.service.LocalPaletteProvider;
import org.eclipse.papyrus.uml.diagram.common.service.WorkspacePaletteProvider;
import org.eclipse.papyrus.uml.diagram.common.service.XMLPaletteProviderConfiguration;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusPaletteService
extends PaletteService
implements IPaletteProvider,
IPapyrusPaletteConstant,
IEclipsePreferences.IPreferenceChangeListener {
    private static PapyrusPaletteService instance;
    public static final String GROUP_STANDARD = "standardGroup";
    public static final String SEPARATOR_STANDARD = "standardSeparator";
    public static final String TOOL_SELECTION = "selectionTool";

    public void setContributions(IConfigurationElement configElement) {
    }

    protected PapyrusPaletteService() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.uml.diagram.common");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    protected void configureLocalPalettes() {
        List<IPaletteDescription> localPalettes = PapyrusPalettePreferences.getLocalPalettes();
        for (Service.ProviderDescriptor providerDescriptor : this.getProviders()) {
            if (!(providerDescriptor instanceof LocalProviderDescriptor)) continue;
            this.removeProvider(providerDescriptor);
        }
        for (IPaletteDescription iPaletteDescription : localPalettes) {
            LocalProviderDescriptor descriptor = new LocalProviderDescriptor(iPaletteDescription);
            this.addProvider(iPaletteDescription.getPriority(), (Service.ProviderDescriptor)descriptor);
        }
    }

    protected void configureWorkspacePalettes() {
        List<IPaletteDescription> workspacePalettes = PapyrusPalettePreferences.getWorkspacePalettes();
        for (Service.ProviderDescriptor providerDescriptor : this.getProviders()) {
            if (!(providerDescriptor instanceof WorkspaceProviderDescriptor)) continue;
            this.removeProvider(providerDescriptor);
        }
        for (IPaletteDescription iPaletteDescription : workspacePalettes) {
            WorkspaceProviderDescriptor descriptor = new WorkspaceProviderDescriptor(iPaletteDescription);
            this.addProvider(iPaletteDescription.getPriority(), (Service.ProviderDescriptor)descriptor);
        }
    }

    public static synchronized PapyrusPaletteService getInstance() {
        if (instance == null) {
            instance = new PapyrusPaletteService();
            PapyrusPaletteService.configureProviders();
        }
        return instance;
    }

    private static void configureProviders() {
        PapyrusPaletteService.getInstance().configureProviders(DiagramUIPlugin.getPluginId(), "paletteProviders");
        PapyrusPaletteService.getInstance().configureProviders("org.eclipse.papyrus.uml.diagram.common", "paletteDefinition");
        PapyrusPaletteService.getInstance().configureLocalPalettes();
        PapyrusPaletteService.getInstance().configureWorkspacePalettes();
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        String extensionPointId = element.getDeclaringExtension().getExtensionPointUniqueIdentifier();
        if ("org.eclipse.papyrus.uml.diagram.common.paletteDefinition".equals(extensionPointId)) {
            return new ExtendedProviderDescriptor(element);
        }
        return new ProviderDescriptor(element);
    }

    public void contributeToPalette(IEditorPart editor, Object content, PaletteRoot root, Map predefinedEntries) {
        PaletteToolbar standardGroup = new PaletteToolbar(Messages.StandardGroup_Label);
        standardGroup.setDescription("");
        standardGroup.setId(GROUP_STANDARD);
        root.add((PaletteEntry)standardGroup);
        PaletteSeparator standardSeparator = new PaletteSeparator(SEPARATOR_STANDARD);
        standardGroup.add((PaletteEntry)standardSeparator);
        PanningSelectionToolEntry selectTool = new PanningSelectionToolEntry();
        selectTool.setId(TOOL_SELECTION);
        selectTool.setToolClass(SelectionToolEx.class);
        standardGroup.add((PaletteEntry)selectTool);
        root.setDefaultEntry((ToolEntry)selectTool);
        this.execute((IOperation)new ContributeToPaletteOperation(editor, content, root, predefinedEntries));
    }

    public List<? extends Service.ProviderDescriptor> getProviders() {
        return this.getAllProviders();
    }

    private List execute(IOperation operation) {
        return this.execute(ExecutionStrategy.REVERSE, operation);
    }

    public PaletteRoot createPalette(final IEditorPart editor, final Object content) {
        final PaletteRoot root = new PaletteRoot();
        try {
            EditingDomain domain;
            IEditingDomainProvider provider = (IEditingDomainProvider)editor.getAdapter(IEditingDomainProvider.class);
            if (provider != null && (domain = provider.getEditingDomain()) instanceof TransactionalEditingDomain) {
                ((TransactionalEditingDomain)domain).runExclusive(new Runnable(){

                    public void run() {
                        PapyrusPaletteService.this.contributeToPalette(editor, content, root, new HashMap());
                    }
                });
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError("Error in PapyrusPaletteService::createPalette()", e);
        }
        return root;
    }

    public void updatePalette(PaletteRoot existingRoot, IEditorPart editor, Object content) {
        PaletteRoot newRoot = this.createPalette(editor, content);
        this.updatePaletteContainerEntries((PaletteContainer)existingRoot, (PaletteContainer)newRoot);
    }

    protected void updatePaletteContainerEntries(PaletteContainer existingContainer, PaletteContainer newContainer) {
        HashMap<String, PaletteEntry> existingEntryIds = new HashMap<String, PaletteEntry>();
        for (PaletteEntry entry : existingContainer.getChildren()) {
            existingEntryIds.put(entry.getId(), entry);
        }
        int nextNewIndex = 0;
        for (PaletteEntry newEntry : newContainer.getChildren()) {
            PaletteEntry existingEntry = (PaletteEntry)existingEntryIds.get(newEntry.getId());
            if (existingEntry != null) {
                nextNewIndex = existingContainer.getChildren().indexOf(existingEntry) + 1;
                existingEntryIds.remove(existingEntry.getId());
                if (!(existingEntry instanceof PaletteContainer) || !(newEntry instanceof PaletteContainer)) continue;
                this.updatePaletteContainerEntries((PaletteContainer)existingEntry, (PaletteContainer)newEntry);
                continue;
            }
            existingContainer.add(nextNewIndex++, newEntry);
        }
        for (PaletteEntry entry : existingEntryIds.values()) {
            existingContainer.remove(entry);
        }
    }

    public List<ProviderDescriptor> getContributingProviders(IEditorPart part, PaletteRoot root) {
        ArrayList<ProviderDescriptor> descriptors = new ArrayList<ProviderDescriptor>();
        ContributeToPaletteOperation o = new ContributeToPaletteOperation(part, (Object)part.getEditorInput(), root, new HashMap());
        for (Service.ProviderDescriptor providerDescriptor : this.getProviders()) {
            if (providerDescriptor instanceof ProviderDescriptor) {
                boolean add;
                ProviderDescriptor papyrusProviderDesc = (ProviderDescriptor)providerDescriptor;
                String name = papyrusProviderDesc.getContributionName();
                if (name == null || name.equals("")) {
                    name = papyrusProviderDesc.getContributionID();
                }
                boolean bl = add = (add = this.isChangeable(papyrusProviderDesc, name)) && this.isContributing(papyrusProviderDesc, o);
                if (!add) continue;
                descriptors.add(papyrusProviderDesc);
                continue;
            }
            Activator.getDefault().logInfo("impossible to cast this provider: " + providerDescriptor);
        }
        return descriptors;
    }

    protected boolean isChangeable(ProviderDescriptor provider, String name) {
        assert (name != null);
        String[] providersToRemove = new String[]{"<Unnamed>", "Presentation Palette", "Geoshapes", "org.eclipse.papyrus.uml.diagram.common"};
        List<String> providersList = Arrays.asList(providersToRemove);
        if (providersList.contains(name)) {
            return false;
        }
        return name.indexOf("Predefined Entries") == -1;
    }

    protected boolean isContributing(ProviderDescriptor provider, ContributeToPaletteOperation o) {
        return provider.providesWithVisibility(o);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String id = event.getKey();
        if ("workspacePaletteDefinition".equals(id)) {
            PapyrusPaletteService.getInstance().configureWorkspacePalettes();
            this.providerChanged(new ProviderChangeEvent((IProvider)this));
        } else if ("localPaletteDefinition".equals(id)) {
            PapyrusPaletteService.getInstance().configureLocalPalettes();
            this.providerChanged(new ProviderChangeEvent((IProvider)this));
        } else if ("paletteCustomization".equals(id)) {
            this.providerChanged(new ProviderChangeEvent((IProvider)this));
        } else if ("paletteRedefinitions".equals(id)) {
            for (Service.ProviderDescriptor providerDescriptor : this.getProviders()) {
                this.removeProvider(providerDescriptor);
            }
            PapyrusPaletteService.configureProviders();
            this.providerChanged(new ProviderChangeEvent((IProvider)this));
        }
    }

    protected void fireProviderChange(ProviderChangeEvent event) {
        try {
            super.fireProviderChange(event);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public static /* bridge */ /* synthetic */ PaletteService getInstance() {
        return PapyrusPaletteService.getInstance();
    }

    public static class ExtendedProviderDescriptor
    extends ProviderDescriptor {
        public ExtendedProviderDescriptor(IConfigurationElement element) {
            super(element);
        }

        protected ExtendedPaletteProviderConfiguration parseConfiguration(IConfigurationElement element) {
            return ExtendedPaletteProviderConfiguration.parse(element);
        }

        protected ExtendedPaletteProviderConfiguration getProviderConfiguration() {
            return (ExtendedPaletteProviderConfiguration)this.providerConfiguration;
        }

        public String createLocalRedefinition() {
            String bundleId;
            String filePath = this.getProviderConfiguration().getPath();
            String realId = bundleId = this.getProviderConfiguration().getBundleID();
            InputStream stream = null;
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (Platform.isFragment((Bundle)bundle)) {
                stream = this.openConfigurationFile(bundle, filePath);
            } else {
                Bundle[] fragments = Platform.getFragments((Bundle)bundle);
                if (fragments == null) {
                    stream = this.openConfigurationFile(bundle, filePath);
                } else {
                    Bundle[] bundleArray = fragments;
                    int n = fragments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Bundle fragment = bundleArray[n2];
                        if (stream == null) {
                            stream = this.openConfigurationFile(fragment, filePath);
                            realId = fragment.getSymbolicName();
                        }
                        ++n2;
                    }
                    if (stream == null) {
                        stream = this.openConfigurationFile(bundle, filePath);
                        realId = bundle.getSymbolicName();
                    }
                }
            }
            if (stream == null) {
                Activator.log.error("Impossible to read initial file", null);
                return null;
            }
            File stateLocationRootFile = Activator.getDefault().getStateLocation().toFile();
            File bundleFolder = new File(stateLocationRootFile, realId);
            bundleFolder.mkdir();
            File root = bundleFolder;
            String[] folders = filePath.split("/");
            int i = 0;
            while (i < folders.length - 1) {
                String folderName = folders[i];
                if (folderName != null && folderName.length() != 0) {
                    File newFolder = new File(root, folders[i]);
                    newFolder.mkdir();
                    root = newFolder;
                }
                ++i;
            }
            File newFile = new File(root, folders[folders.length - 1]);
            boolean fileCreated = false;
            if (newFile.exists()) {
                fileCreated = true;
            } else {
                try {
                    fileCreated = newFile.createNewFile();
                }
                catch (IOException e) {
                    Activator.log.error("Impossible to create new file", (Throwable)e);
                    return null;
                }
            }
            if (!fileCreated) {
                Activator.log.error("It was not possible to create the file", null);
                return null;
            }
            try {
                int len;
                FileOutputStream fileOutputStream = new FileOutputStream(newFile);
                byte[] buf = new byte[1024];
                while ((len = stream.read(buf)) > 0) {
                    fileOutputStream.write(buf, 0, len);
                }
                stream.close();
                fileOutputStream.close();
            }
            catch (FileNotFoundException e) {
                Activator.log.error("It was not possible to write in the file", (Throwable)e);
                return null;
            }
            catch (IOException e) {
                Activator.log.error("It was not possible to write in the file", (Throwable)e);
                return null;
            }
            return String.valueOf(realId) + filePath;
        }

        protected InputStream openConfigurationFile(Bundle bundle, String filePath) {
            block4: {
                int jarPathEndIndex;
                String path;
                block5: {
                    URL urlFile = bundle.getEntry(filePath);
                    urlFile = FileLocator.resolve((URL)urlFile);
                    urlFile = FileLocator.toFileURL((URL)urlFile);
                    if ("file".equals(urlFile.getProtocol())) {
                        return new FileInputStream(urlFile.getFile());
                    }
                    if (!"jar".equals(urlFile.getProtocol()) || !(path = urlFile.getPath()).startsWith("file:")) break block4;
                    jarPathEndIndex = path.indexOf("!/");
                    if (jarPathEndIndex >= 0) break block5;
                    Activator.log.error("Impossible to find the jar path end", null);
                    return null;
                }
                try {
                    String jarPath = path.substring("file:".length(), jarPathEndIndex);
                    ZipFile zipFile = new ZipFile(jarPath);
                    filePath = filePath.substring(jarPathEndIndex + 2, path.length());
                    ZipEntry entry = zipFile.getEntry(path);
                    return zipFile.getInputStream(entry);
                }
                catch (IOException e) {
                    Activator.log.error("Impossible to find initial file", (Throwable)e);
                }
            }
            return null;
        }

        public URI getRedefinitionFileURI() {
            String path = PapyrusPalettePreferences.getPaletteRedefinition(this.getContributionID());
            if (path == null) {
                Activator.log.error("Path is null for the given contribution: " + this.getContributionID(), null);
                return null;
            }
            File stateLocationRootFile = Activator.getDefault().getStateLocation().append(path).toFile();
            if (stateLocationRootFile == null) {
                Activator.log.error("No redefinition file was found for id: " + this.getContributionID(), null);
                return null;
            }
            if (!stateLocationRootFile.exists()) {
                Activator.log.error("local definition file does not exists : " + stateLocationRootFile, null);
                return null;
            }
            if (!stateLocationRootFile.canRead()) {
                Activator.log.error("Impossible to read local definition of the file " + stateLocationRootFile, null);
                return null;
            }
            URI uri = URI.createFileURI((String)stateLocationRootFile.getAbsolutePath());
            return uri;
        }
    }

    public static class LocalProviderDescriptor
    extends ProviderDescriptor {
        protected final IPaletteDescription description;

        public LocalProviderDescriptor(IPaletteDescription description) {
            super(null);
            this.description = description;
        }

        public boolean hasOnlyEntriesDefinition() {
            return false;
        }

        public IPaletteDescription getDescription() {
            return this.description;
        }

        public String getContributionName() {
            return this.description.getName();
        }

        public String getContributionID() {
            return this.description.getPaletteID();
        }

        public boolean isHidden(ContributeToPaletteOperation operation) {
            List<String> hiddenPalettes = PapyrusPalettePreferences.getHiddenPalettes(operation.getEditor());
            return hiddenPalettes.contains(this.getContributionID());
        }

        public ProviderPriority getPriority() {
            return this.description.getPriority();
        }

        public boolean provides(IOperation operation) {
            boolean isEnable = ActivityUtil.isEnabled((String)this.getContributionID(), (String)"org.eclipse.papyrus.uml.diagram.common");
            if (!isEnable) {
                return false;
            }
            if (operation instanceof ContributeToPaletteOperation) {
                ContributeToPaletteOperation o = (ContributeToPaletteOperation)operation;
                IEditorPart part = o.getEditor();
                if (!(part instanceof DiagramEditorWithFlyOutPalette)) {
                    return false;
                }
                if (this.description.getContributionEditorID() != null && !this.description.getContributionEditorID().equals(((DiagramEditorWithFlyOutPalette)part).getContributorId())) {
                    return false;
                }
                if (!PaletteUtil.areRequiredProfileApplied(part, this)) {
                    return false;
                }
                return !this.isHidden(o);
            }
            return false;
        }

        public boolean providesWithVisibility(ContributeToPaletteOperation operation) {
            boolean isEnable = ActivityUtil.isEnabled((String)this.getContributionID(), (String)"org.eclipse.papyrus.uml.diagram.common");
            if (!isEnable) {
                return false;
            }
            if (operation instanceof ContributeToPaletteOperation) {
                ContributeToPaletteOperation o = operation;
                IEditorPart part = o.getEditor();
                if (!(part instanceof DiagramEditorWithFlyOutPalette)) {
                    return false;
                }
                return this.description.getContributionEditorID() == null || this.description.getContributionEditorID().equals(((DiagramEditorWithFlyOutPalette)part).getContributorId());
            }
            return false;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                this.provider = new LocalPaletteProvider();
                ((LocalPaletteProvider)this.provider).setContributions(this.description);
            }
            return this.provider;
        }
    }

    public static class ProviderDescriptor
    extends ActivityFilterProviderDescriptor {
        protected XMLPaletteProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            if (element != null) {
                this.providerConfiguration = this.parseConfiguration(element);
                Assert.isNotNull((Object)((Object)this.getProviderConfiguration()));
            }
        }

        public String getTargetEditorID() {
            XMLPaletteProviderConfiguration.EditorDescriptor targetEditor;
            if (this.providerConfiguration != null && (targetEditor = this.providerConfiguration.getEditor()) != null) {
                return targetEditor.getTargetId();
            }
            return null;
        }

        protected XMLPaletteProviderConfiguration parseConfiguration(IConfigurationElement element) {
            return XMLPaletteProviderConfiguration.parse(element);
        }

        protected XMLPaletteProviderConfiguration getProviderConfiguration() {
            return this.providerConfiguration;
        }

        public boolean hasOnlyEntriesDefinition() {
            return this.getProviderConfiguration().hasOnlyEntriesDefinition();
        }

        public String getContributionName() {
            return this.getProviderConfiguration().getName();
        }

        public String getContributionID() {
            return this.getProviderConfiguration().getID();
        }

        public boolean isHidden(ContributeToPaletteOperation operation) {
            List<String> hiddenPalettes = PapyrusPalettePreferences.getHiddenPalettes(operation.getEditor());
            return hiddenPalettes.contains(this.getContributionID());
        }

        public ProviderPriority getPriority() {
            return this.getProviderConfiguration().getPriority();
        }

        public boolean provides(IOperation operation) {
            if (!super.provides(operation)) {
                return false;
            }
            if (!this.policyInitialized) {
                this.policy = this.getPolicy();
                this.policyInitialized = true;
            }
            if (this.policy != null) {
                return this.policy.provides(operation);
            }
            if (operation instanceof ContributeToPaletteOperation) {
                ContributeToPaletteOperation o = (ContributeToPaletteOperation)operation;
                IEditorPart part = o.getEditor();
                if (!(part instanceof DiagramEditorWithFlyOutPalette)) {
                    return false;
                }
                boolean supports = this.getProviderConfiguration().supports(o.getEditor(), o.getContent());
                if (!supports) {
                    return false;
                }
                if (this.isHidden(o)) {
                    return false;
                }
                return PaletteUtil.areRequiredProfileApplied(part, this);
            }
            return false;
        }

        public boolean providesWithVisibility(ContributeToPaletteOperation operation) {
            if (!super.provides((IOperation)operation)) {
                return false;
            }
            if (!this.policyInitialized) {
                this.policy = this.getPolicy();
                this.policyInitialized = true;
            }
            if (this.policy != null) {
                return this.policy.provides((IOperation)operation);
            }
            if (operation instanceof ContributeToPaletteOperation) {
                ContributeToPaletteOperation o = operation;
                boolean supports = this.getProviderConfiguration().supports(o.getEditor(), o.getContent());
                return supports;
            }
            return false;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                IProvider newProvider = super.getProvider();
                if (this.provider instanceof IPaletteProvider) {
                    IPaletteProvider defaultProvider = (IPaletteProvider)newProvider;
                    defaultProvider.setContributions(this.getElement());
                }
                return newProvider;
            }
            return super.getProvider();
        }
    }

    public static class WorkspaceProviderDescriptor
    extends LocalProviderDescriptor {
        public WorkspaceProviderDescriptor(IPaletteDescription description) {
            super(description);
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                this.provider = new WorkspacePaletteProvider();
                ((WorkspacePaletteProvider)this.provider).setContributions(this.description);
            }
            return this.provider;
        }
    }
}

