/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.ModelPostAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Profile;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalPostAction
extends ModelPostAction {
    protected Map<String, Object> propertiesToUpdate = new HashMap<String, Object>();
    protected IPaletteEntryProxy entryProxy;
    protected List<Profile> appliedProfiles;

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        if (configurationNode == null) {
            return;
        }
        NodeList childNodes = configurationNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node featureNode = childNodes.item(i);
            if ("feature".equals(featureNode.getNodeName())) {
                Node nameNode = childNodes.item(i).getAttributes().getNamedItem("name");
                Node valueNode = childNodes.item(i).getAttributes().getNamedItem("value");
                if (nameNode != null && valueNode != null) {
                    this.propertiesToUpdate.put(nameNode.getNodeValue(), valueNode.getNodeValue());
                } else {
                    Activator.log.error("Impossible to parse the configuration node for graphical post action", null);
                }
            }
            ++i;
        }
    }

    @Override
    public ICommand getPostCommand(final IAdaptable viewAdapter) {
        TransactionalEditingDomain editingDomain = EditorUtils.getTransactionalEditingDomain();
        return new AbstractTransactionalCommand(editingDomain, "Modify Graphic", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                for (String featureName : GraphicalPostAction.this.propertiesToUpdate.keySet()) {
                    EStructuralFeature feature = view.eClass().getEStructuralFeature(featureName);
                    if (feature == null) {
                        Activator.log.error("Impossible to find the feature " + featureName + " for element " + view, null);
                        continue;
                    }
                    view.eSet(feature, GraphicalPostAction.this.getValue(feature, GraphicalPostAction.this.propertiesToUpdate.get(featureName)));
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        this.entryProxy = entryProxy;
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText("Configuration of graphical post action : ");
        GridData data = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)data);
        return composite;
    }

    @Override
    public void save(Node parentNode) {
    }
}

