/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.util.ViewServiceUtil;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShowHideAction
implements IActionDelegate,
IWorkbenchWindowActionDelegate {
    protected List<EditPart> selectedElements;
    protected List<Object> initialSelection;
    private String editPolicyKey = null;
    private String title = null;
    private String message = null;
    private ILabelProvider labelProvider = null;
    private ITreeContentProvider contentProvider = null;
    protected List<Object> viewsToDestroy;
    protected List<Object> viewsToCreate;
    protected List<EditPartRepresentation> representations;

    public AbstractShowHideAction(String title, String message, String editPolicyKey) {
        this.editPolicyKey = editPolicyKey;
        this.title = title;
        this.message = message;
        ViewServiceUtil.forceLoad();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (!this.canRun()) {
            return;
        }
        this.initAction();
        this.buildInitialSelection();
        CheckedTreeSelectionDialog selectionDialog = new CheckedTreeSelectionDialog(DisplayUtils.getDisplay().getActiveShell(), this.labelProvider, this.contentProvider);
        selectionDialog.setTitle(this.title);
        selectionDialog.setMessage(this.message);
        selectionDialog.setContainerMode(true);
        selectionDialog.setInput(this.getInput());
        selectionDialog.setExpandedElements(this.getInput().toArray());
        selectionDialog.setInitialElementSelections(this.initialSelection);
        selectionDialog.open();
        if (selectionDialog.getReturnCode() == 0) {
            this.buildShowHideElementsList(selectionDialog.getResult());
            final org.eclipse.gef.commands.Command command = this.getActionCommand();
            final TransactionalEditingDomain domain = ((IGraphicalEditPart)this.selectedElements.get(0)).getEditingDomain();
            if (command.canExecute()) {
                try {
                    domain.runExclusive(new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(command));
                                }
                            });
                        }
                    });
                }
                catch (InterruptedException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    public boolean canRun() {
        if (this.selectedElements.isEmpty()) {
            return false;
        }
        for (EditPart object : this.selectedElements) {
            if (!(object instanceof EditPart)) {
                return false;
            }
            EditPolicy policy = object.getEditPolicy((Object)this.editPolicyKey);
            if (policy != null) continue;
            return false;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        if (this.editPolicyKey != null) {
            this.selectedElements = new ArrayList<EditPart>();
            if (selection instanceof StructuredSelection) {
                Object[] objectArray = ((StructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    if (current instanceof EditPart) {
                        this.selectedElements.add((EditPart)current);
                        EditPolicy policy = ((EditPart)current).getEditPolicy((Object)this.editPolicyKey);
                        if (policy != null) {
                            enabled = true;
                            break;
                        }
                    }
                    ++n2;
                }
            }
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    protected void initAction() {
        this.labelProvider = new UMLLabelProvider();
        this.representations = new ArrayList<EditPartRepresentation>();
    }

    public List<Object> getInitialSelection() {
        return this.initialSelection;
    }

    protected void buildInitialSelection() {
        this.initialSelection = new ArrayList<Object>();
        for (EditPartRepresentation current : this.representations) {
            this.initialSelection.addAll(current.getInitialSelection());
        }
    }

    protected abstract List<Object> getInput();

    protected void buildShowHideElementsList(Object[] result) {
        this.viewsToCreate = new ArrayList<Object>();
        this.viewsToDestroy = new ArrayList<Object>();
    }

    protected abstract org.eclipse.gef.commands.Command getActionCommand();

    protected void setEditorLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
    }

    protected void setContentProvider(ITreeContentProvider provider) {
        this.contentProvider = provider;
    }

    public void setSelection(List<EditPart> selection) {
        this.selectedElements = selection;
    }

    public String getEditPolicyKey() {
        return this.editPolicyKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EditPartRepresentation {
        protected EditPart representedEditPart;
        protected List<Object> initialSelection;
        protected List<Object> elementsToSelect;
        protected Element UMLElement;

        public EditPartRepresentation(EditPart representedEditPart, Element umlElement) {
            this.representedEditPart = representedEditPart;
            this.UMLElement = umlElement;
            this.initRepresentation();
        }

        public EditPart getRepresentedEditPart() {
            return this.representedEditPart;
        }

        public Element getUMLElement() {
            return this.UMLElement;
        }

        public List<Object> getInitialSelection() {
            return this.initialSelection;
        }

        protected void initRepresentation() {
            this.initialSelection = new ArrayList<Object>();
            this.elementsToSelect = new ArrayList<Object>();
        }

        public List<Object> getPossibleElement() {
            return this.elementsToSelect;
        }
    }
}

