/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.infra.emf.appearance.helper.ShadowFigureHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentCombinedFragmentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomInteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.CombinedFragmentHeadImpactLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.GateCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.GatesHolderGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomCombinedFragmentItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.CombinedFragmentFigure;
import org.eclipse.papyrus.uml.diagram.sequence.locator.GateLocator;
import org.eclipse.papyrus.uml.diagram.sequence.locator.TextCellEditorLocator;
import org.eclipse.papyrus.uml.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.ElementIconUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.InteractionOperatorKindCompatibleMapping;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineCoveredByUpdater;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCombinedFragmentEditPart
extends CombinedFragmentEditPart
implements ITextAwareEditPart,
IPapyrusEditPart {
    private static final String FORBIDDEN_ACTION = "Forbidden action";
    private static final String BLOCK_OPERATOR_MODIFICATION_MSG = "It's impossible to change the operator kind of the combined fragment\nbecause the combined fragment has more than one operand";
    private static final String FORBIDEN_OPERATOR_MODIFICATION_MSG = "It's impossible to configure combined fragment as consider or ignore.\nUse ConsiderIgnoreFragment instead";
    private static final String BLOCK_OPERAND_ADDITION_MSG = "It's impossible to add more than one operand on opt, loop, break, neg combined fragment";
    private DirectEditManager manager;
    private IParser parser;
    private IEclipsePreferences.IPreferenceChangeListener propertyListener;

    public CustomCombinedFragmentEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomCombinedFragmentItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new CombinedFragmentDirectEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GatesHolderGraphicalNodeEditPolicy());
        this.installEditPolicy("Gate Creation Edit Policy", (EditPolicy)new GateCreationEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("HeadImpactLayoutEditPolicy", (EditPolicy)new CombinedFragmentHeadImpactLayoutEditPolicy());
    }

    @Override
    protected IFigure createNodeShape() {
        this.primaryShape = new CombinedFragmentFigure();
        this.updateHeaderLabel();
        return this.primaryShape;
    }

    @Override
    protected NodeFigure createNodeFigure() {
        return new BorderedNodeFigure((IFigure)super.createNodeFigure());
    }

    @Override
    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    public final BorderedNodeFigure getBorderedFigure() {
        return (BorderedNodeFigure)this.getFigure();
    }

    @Override
    protected NodeFigure createNodePlate() {
        String prefElementId = "CombinedFragment";
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        AnchorHelper.CombinedFragmentNodeFigure result = new AnchorHelper.CombinedFragmentNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        return result;
    }

    @Override
    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof NodeFigure) {
            ((NodeFigure)this.primaryShape).setLineWidth(width);
        } else {
            super.setLineWidth(width);
        }
    }

    @Override
    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof CombinedFragmentCombinedFragmentCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getCompartmentFigure();
            this.setupContentPane((IFigure)pane);
            pane.remove(((CombinedFragmentCombinedFragmentCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof GateEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((GateEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof GateEditPart) {
            this.getBorderedFigure().getBorderItemContainer().add(((GateEditPart)childEditPart).getFigure(), (Object)new GateLocator((GateEditPart)childEditPart, this.getFigure()));
            return true;
        }
        return super.addFixedChild(childEditPart);
    }

    public List<CustomInteractionOperandEditPart> getOperandChildrenEditParts() {
        LinkedList<CustomInteractionOperandEditPart> children = new LinkedList<CustomInteractionOperandEditPart>();
        IGraphicalEditPart compartment = this.getChildBySemanticHint(String.valueOf(7004));
        if (compartment instanceof CombinedFragmentCombinedFragmentCompartmentEditPart) {
            for (Object ep : compartment.getChildren()) {
                if (!(ep instanceof CustomInteractionOperandEditPart)) continue;
                children.add((CustomInteractionOperandEditPart)((Object)ep));
            }
        }
        return children;
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (UMLPackage.eINSTANCE.getCombinedFragment_InteractionOperator().equals(feature)) {
            CombinedFragment combinedFragment = (CombinedFragment)this.resolveSemanticElement();
            String newStringValue = notification.getNewStringValue();
            if (notification.getOldValue() instanceof InteractionOperatorKind && !this.isAllowedInteractionOperator(newStringValue)) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)FORBIDDEN_ACTION, (String)FORBIDEN_OPERATOR_MODIFICATION_MSG);
                CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)combinedFragment, (Object)feature, (Object)notification.getOldValue()), true);
                return;
            }
            EList operands = combinedFragment.getOperands();
            if (operands == null || operands.size() <= 1) {
                this.updateHeaderLabel();
            } else if (notification.getOldValue() instanceof InteractionOperatorKind) {
                InteractionOperatorKind newValue = (InteractionOperatorKind)notification.getNewValue();
                if (!InteractionOperatorKindCompatibleMapping.supportMultiOperand(newValue)) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)FORBIDDEN_ACTION, (String)BLOCK_OPERATOR_MODIFICATION_MSG);
                    CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)combinedFragment, (Object)feature, (Object)notification.getOldValue()), true);
                } else {
                    this.updateHeaderLabel();
                }
            }
            for (CustomInteractionOperandEditPart ioep : this.getOperandChildrenEditParts()) {
                ioep.updateConstraintLabel();
            }
        } else if (UMLPackage.eINSTANCE.getCombinedFragment_Operand().equals(feature)) {
            EList operands;
            CombinedFragment combinedFragment = (CombinedFragment)this.resolveSemanticElement();
            InteractionOperatorKind interactionOperator = combinedFragment.getInteractionOperator();
            Object newValue = notification.getNewValue();
            if (interactionOperator != null && newValue != null && (InteractionOperatorKind.OPT_LITERAL.equals((Object)interactionOperator) || InteractionOperatorKind.LOOP_LITERAL.equals((Object)interactionOperator) || InteractionOperatorKind.BREAK_LITERAL.equals((Object)interactionOperator) || InteractionOperatorKind.NEG_LITERAL.equals((Object)interactionOperator)) && (operands = combinedFragment.getOperands()) != null && operands.size() > 1) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)FORBIDDEN_ACTION, (String)BLOCK_OPERAND_ADDITION_MSG);
                CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)combinedFragment, (Object)feature, (Object)newValue), true);
                return;
            }
        } else if (UMLPackage.eINSTANCE.getInteractionFragment_Covered().equals(feature)) {
            if (notification.getNotifier() instanceof CombinedFragment) {
                CombinedFragment combinedFragment = (CombinedFragment)notification.getNotifier();
                EList combinedFragmentCoveredLifelines = combinedFragment.getCovereds();
                for (InteractionOperand operand : combinedFragment.getOperands()) {
                    EList operandCoveredLifelines = operand.getCovereds();
                    if (operandCoveredLifelines.equals((Object)combinedFragmentCoveredLifelines)) continue;
                    ArrayList coveredLifelinesToAdd = new ArrayList(combinedFragmentCoveredLifelines);
                    coveredLifelinesToAdd.removeAll((Collection<?>)operandCoveredLifelines);
                    if (!coveredLifelinesToAdd.isEmpty()) {
                        CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)operand, (Object)UMLPackage.eINSTANCE.getInteractionFragment_Covered(), coveredLifelinesToAdd), true);
                    }
                    ArrayList coveredLifelinesToRemove = new ArrayList(operandCoveredLifelines);
                    coveredLifelinesToRemove.removeAll((Collection<?>)combinedFragmentCoveredLifelines);
                    if (coveredLifelinesToRemove.isEmpty()) continue;
                    CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)operand, (Object)UMLPackage.eINSTANCE.getInteractionFragment_Covered(), coveredLifelinesToRemove), true);
                }
            }
        } else if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) && notification.getNotifier() instanceof CombinedFragment) {
            this.refreshLabel();
        }
        if (notification.getNewValue() instanceof EAnnotation && "QualifiedName".equals(((EAnnotation)notification.getNewValue()).getSource())) {
            this.refreshLabel();
        }
        super.handleNotificationEvent(notification);
        if (notification.getNotifier() instanceof Bounds && notification.getNotifier() instanceof Bounds) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    LifelineCoveredByUpdater updater = new LifelineCoveredByUpdater();
                    updater.update((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)CustomCombinedFragmentEditPart.this);
                }
            });
        }
        if (this.getModel() != null && this.getModel() == notification.getNotifier() && NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        }
        if (this.resolveSemanticElement() != null) {
            this.refreshShadow();
        }
        if (ElementIconUtil.isIconNotification(notification)) {
            this.refreshLabelIcon();
        }
    }

    protected void refreshShadow() {
        this.getPrimaryShape().setShadow(ShadowFigureHelper.getShadowFigureValue((EModelElement)((View)this.getModel())));
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void setGradient(GradientData gradient) {
        CombinedFragmentFigure fig = this.getPrimaryShape();
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (gradient != null) {
            fig.setIsUsingGradient(true);
            fig.setGradientData(style.getFillColor(), gradient.getGradientColor1(), gradient.getGradientStyle());
        } else {
            fig.setIsUsingGradient(false);
        }
    }

    public boolean supportsGradient() {
        return true;
    }

    protected void setBackgroundColor(Color c) {
        CombinedFragmentFigure fig = this.getPrimaryShape();
        fig.setBackgroundColor(c);
        fig.setIsUsingGradient(false);
        fig.setGradientData(-1, -1, 0);
    }

    protected void updateHeaderLabel() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof CombinedFragment) {
            CombinedFragment combinedFragment = (CombinedFragment)element;
            String operatorKind = combinedFragment.getInteractionOperator().getName();
            this.getPrimaryShape().getHeaderLabel().setText(operatorKind);
        }
    }

    protected boolean isAllowedInteractionOperator(String interactionOperatorLiteral) {
        return !InteractionOperatorKind.CONSIDER_LITERAL.getLiteral().equals(interactionOperatorLiteral) && !InteractionOperatorKind.IGNORE_LITERAL.getLiteral().equals(interactionOperatorLiteral);
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        if (this.propertyListener == null) {
            this.propertyListener = new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    CustomCombinedFragmentEditPart.this.handlePreferenceChange(event);
                }
            };
            InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.infra.gmfdiag.preferences").addPreferenceChangeListener(this.propertyListener);
        }
    }

    protected void handlePreferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.getParent() == null) {
            return;
        }
        String key = event.getKey();
        if (key.equals(this.getTitlePreferenceKey())) {
            this.refreshLabel();
        }
    }

    public String getTitlePreferenceKey() {
        return "ELEMENT_PapyrusUMLSequenceDiagram_CombinedFragment_CombinedFragmentCompartment.compartment_name.visibility";
    }

    public WrappingLabel getTitleLabel() {
        return this.getPrimaryShape().getTitleLabel();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshLabelIcon();
    }

    protected void refreshLabelIcon() {
        Image image = ElementIconUtil.getLabelIcon((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this);
        this.getPrimaryShape().getHeaderLabel().setIcon(image);
    }

    private void refreshLabel() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof CombinedFragment) {
            CombinedFragment combinedFragment = (CombinedFragment)element;
            String name = combinedFragment.getName();
            int depth = AppearanceHelper.getQualifiedNameDepth((EModelElement)this.getNotationView());
            if (depth == 0) {
                name = combinedFragment.getQualifiedName();
            }
            WrappingLabel label = this.getPrimaryShape().getTitleLabel();
            label.setText(name);
            ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.papyrus.infra.gmfdiag.preferences");
            String visible = store.getString(this.getTitlePreferenceKey());
            label.setVisible("true".equals(visible));
        }
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            WrappingLabel label = this.getPrimaryShape().getTitleLabel();
            this.manager = new TextDirectEditManager((GraphicalEditPart)this, TextCellEditorEx.class, (CellEditorLocator)new TextCellEditorLocator(label){

                public void relocate(CellEditor celleditor) {
                    Text text = (Text)celleditor.getControl();
                    Rectangle rect = this.getWrapLabel().getBounds().getCopy();
                    this.getWrapLabel().translateToAbsolute((Translatable)rect);
                    Point right = rect.getRight();
                    if (!text.getFont().isDisposed()) {
                        if (this.getWrapLabel().isTextWrapOn() && this.getWrapLabel().getText().length() > 0) {
                            rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
                        } else {
                            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
                        }
                        if (rect.getRight().x > right.x) {
                            rect.translate(right.x - rect.getRight().x, 0);
                        }
                    }
                    if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                        text.setBounds(rect.x, rect.y, rect.width, rect.height);
                    }
                }
            });
        }
        return this.manager;
    }

    protected void performDirectEditRequest(Request request) {
        if (request instanceof DirectEditRequest) {
            WrappingLabel label = this.getPrimaryShape().getTitleLabel();
            Point location = ((DirectEditRequest)request).getLocation().getCopy();
            label.translateToRelative((Translatable)location);
            if (label.containsPoint(location)) {
                this.getManager().show();
            }
        }
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = new CombinedFragmentTitleParser();
        }
        return this.parser;
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    public void setLabelText(String text) {
        WrappingLabel label = this.getPrimaryShape().getTitleLabel();
        label.setText(text);
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = CustomCombinedFragmentEditPart.this.getParserElement();
                    final IParser parser = CustomCombinedFragmentEditPart.this.getParser();
                    if (element != null && parser != null) {
                        try {
                            IParserEditStatus valid = (IParserEditStatus)CustomCombinedFragmentEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                                public void run() {
                                    this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                                }
                            });
                            return valid.getCode() == 0 ? null : valid.getMessage();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }
        };
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy policy = this.getEditPolicy("PrimaryDrag Policy");
        return policy != null ? policy : new ResizableShapeEditPolicyEx();
    }

    class CombinedFragmentDirectEditPolicy
    extends DirectEditPolicy {
        CombinedFragmentDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest edit) {
            String labelText = (String)edit.getCellEditor().getValue();
            if (labelText == null) {
                return null;
            }
            ITextAwareEditPart compartment = (ITextAwareEditPart)this.getHost();
            EObject model = (EObject)compartment.getModel();
            EObjectAdapterEx elementAdapter = null;
            if (model instanceof View) {
                View view = (View)model;
                elementAdapter = new EObjectAdapterEx(ViewUtil.resolveSemanticElement((View)view), view);
            } else {
                elementAdapter = new EObjectAdapterEx(model, null);
            }
            String prevText = compartment.getParser().getEditString((IAdaptable)elementAdapter, compartment.getParserOptions().intValue());
            if (!prevText.equals(labelText)) {
                ICommand iCommand = compartment.getParser().getParseCommand((IAdaptable)elementAdapter, labelText, 0);
                return new ICommandProxy(iCommand);
            }
            return null;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            String value = (String)request.getCellEditor().getValue();
            WrappingLabel label = CustomCombinedFragmentEditPart.this.getPrimaryShape().getTitleLabel();
            label.setText(value);
        }
    }

    static class CombinedFragmentTitleParser
    extends MessageFormatParser
    implements ISemanticParser {
        public CombinedFragmentTitleParser() {
            super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
        }

        public List getSemanticElementsBeingParsed(EObject element) {
            ArrayList<CombinedFragment> semanticElementsBeingParsed = new ArrayList<CombinedFragment>();
            if (element instanceof CombinedFragment) {
                CombinedFragment cf = (CombinedFragment)element;
                semanticElementsBeingParsed.add(cf);
            }
            return semanticElementsBeingParsed;
        }

        public boolean areSemanticElementsAffected(EObject listener, Object notification) {
            EStructuralFeature feature = this.getEStructuralFeature(notification);
            return this.isValidFeature(feature);
        }

        public boolean isAffectingEvent(Object event, int flags) {
            EStructuralFeature feature = this.getEStructuralFeature(event);
            return this.isValidFeature(feature);
        }

        public String getPrintString(IAdaptable element, int flags) {
            Object adapter = element.getAdapter(EObject.class);
            if (adapter instanceof CombinedFragment) {
                CombinedFragment cf = (CombinedFragment)adapter;
                return cf.getName();
            }
            return "";
        }

        public IParserEditStatus isValidEditString(IAdaptable adapter, String editString) {
            return ParserEditStatus.EDITABLE_STATUS;
        }

        public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
            EObject element = (EObject)adapter.getAdapter(EObject.class);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)element);
            if (editingDomain == null || !(element instanceof CombinedFragment)) {
                return UnexecutableCommand.INSTANCE;
            }
            SetRequest request = new SetRequest(element, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newString);
            return new SetValueCommand(request);
        }

        public String getEditString(IAdaptable element, int flags) {
            Object adapter = element.getAdapter(EObject.class);
            if (adapter instanceof CombinedFragment) {
                CombinedFragment cf = (CombinedFragment)adapter;
                return cf.getName();
            }
            return "";
        }

        protected EStructuralFeature getEStructuralFeature(Object notification) {
            Object feature;
            EStructuralFeature featureImpl = null;
            if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
                featureImpl = (EStructuralFeature)feature;
            }
            return featureImpl;
        }

        private boolean isValidFeature(EStructuralFeature feature) {
            return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature);
        }
    }

    static class EObjectAdapterEx
    extends EObjectAdapter {
        private View view = null;

        public EObjectAdapterEx(EObject element, View view) {
            super(element);
            this.view = view;
        }

        public Object getAdapter(Class adapter) {
            Object o = super.getAdapter(adapter);
            if (o != null) {
                return o;
            }
            if (adapter.equals(View.class)) {
                return this.view;
            }
            return null;
        }
    }

    static class ResizableShapeEditPolicyEx
    extends ResizableShapeEditPolicy {
        ResizableShapeEditPolicyEx() {
        }

        protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
            IFigure feedback = this.getDragSourceFeedbackFigure();
            PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            Rectangle old = rect.getCopy();
            rect.translate(request.getMoveDelta());
            rect.resize(request.getSizeDelta());
            IFigure f = this.getHostFigure();
            Dimension min = f.getMinimumSize().getCopy();
            Dimension max = f.getMaximumSize().getCopy();
            IMapMode mmode = MapModeUtil.getMapMode((IFigure)f);
            min.height = mmode.LPtoDP(min.height);
            min.width = mmode.LPtoDP(min.width);
            max.height = mmode.LPtoDP(max.height);
            max.width = mmode.LPtoDP(max.width);
            if (min.width > rect.width) {
                rect.width = min.width;
                if (request.getMoveDelta().x > 0 && request.getSizeDelta().width < 0) {
                    rect.x = old.getRight().x - min.width;
                    request.getMoveDelta().x = rect.x - old.getLeft().x;
                }
            } else if (max.width < rect.width) {
                rect.width = max.width;
            }
            if (min.height > rect.height) {
                rect.height = min.height;
                if (request.getMoveDelta().y > 0 && request.getSizeDelta().height < 0) {
                    rect.y = old.getBottom().y - min.height;
                    request.getMoveDelta().y = rect.y - old.getTop().y;
                }
            } else if (max.height < rect.height) {
                rect.height = max.height;
            }
            feedback.translateToRelative((Translatable)rect);
            feedback.setBounds((Rectangle)rect);
        }
    }
}

