/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GeneralOrderingEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomGeneralOrderingItemSemanticEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class CustomGeneralOrderingEditPart
extends GeneralOrderingEditPart
implements IPapyrusEditPart {
    public CustomGeneralOrderingEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomGeneralOrderingItemSemanticEditPolicy());
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        }
    }

    protected Connection createConnectionFigure() {
        return new CustomGeneralOrderingDescriptor();
    }

    public CustomGeneralOrderingDescriptor getPrimaryShape() {
        return (CustomGeneralOrderingDescriptor)this.getFigure();
    }

    protected void setLineWidth(int width) {
        this.getPrimaryShape().setLineWidth(width);
    }

    public EditPart getTargetEditPart(Request request) {
        ReconnectRequest rRequest;
        EditPart ep = super.getTargetEditPart(request);
        if (ep != null && ep instanceof ConnectionEditPart && request instanceof ReconnectRequest && this.isCyclicConnectionRequest((ConnectionEditPart)ep, (rRequest = (ReconnectRequest)request).getConnectionEditPart())) {
            return null;
        }
        return ep;
    }

    private boolean isCyclicConnectionRequest(ConnectionEditPart currentConn, ConnectionEditPart reqConn) {
        if (currentConn == null || reqConn == null) {
            return false;
        }
        EditPart source = currentConn.getSource();
        EditPart target = currentConn.getTarget();
        if (reqConn == source || reqConn == target) {
            return true;
        }
        return reqConn == source.getParent() || reqConn == target.getParent();
    }

    public class CustomGeneralOrderingDescriptor
    extends GeneralOrderingEditPart.GeneralOrderingDescriptor
    implements IPapyrusUMLElementFigure {
        private WrappingLabel fAppliedStereotypeLabel;
        private RotatableDecoration middleDecoration;

        public CustomGeneralOrderingDescriptor() {
            super(CustomGeneralOrderingEditPart.this);
            this.setTargetDecoration(null, null);
            this.setAntialias(1);
            this.createContents();
            this.setLineStyle(2);
            this.setForegroundColor(ColorConstants.black);
            this.setMiddleDecoration(this.createTargetDecoration());
        }

        protected void createContents() {
            this.createStereotypeLabel();
        }

        protected void createStereotypeLabel() {
            this.fAppliedStereotypeLabel = new WrappingLabel();
            this.fAppliedStereotypeLabel.setTextWrap(true);
            this.fAppliedStereotypeLabel.setTextJustification(2);
            this.fAppliedStereotypeLabel.setText("");
            this.add((IFigure)this.fAppliedStereotypeLabel);
        }

        private RotatableDecoration createTargetDecoration() {
            PolygonDecoration df = new PolygonDecoration();
            df.setFill(true);
            df.setForegroundColor(this.getForegroundColor());
            df.setBackgroundColor(this.getForegroundColor());
            PointList pl = new PointList();
            pl.addPoint(CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(-2), CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(2));
            pl.addPoint(CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(0), CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(-2), CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(-2));
            pl.addPoint(CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(-2), CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(2));
            df.setTemplate(pl);
            df.setScale((double)CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(7), (double)CustomGeneralOrderingEditPart.this.getMapMode().DPtoLP(3));
            return df;
        }

        public WrappingLabel getAppliedStereotypeLabel() {
            return this.fAppliedStereotypeLabel;
        }

        protected RotatableDecoration getMiddleDecoration() {
            return this.middleDecoration;
        }

        public void setForegroundColor(Color fg) {
            super.setForegroundColor(fg);
            if (this.getMiddleDecoration() != null) {
                this.getMiddleDecoration().setForegroundColor(fg);
                this.getMiddleDecoration().setBackgroundColor(fg);
            }
        }

        public void setLineWidth(int w) {
            super.setLineWidth(w);
            if (this.getMiddleDecoration() instanceof Shape) {
                ((Shape)this.getMiddleDecoration()).setLineWidth(w);
            }
        }

        public void setMiddleDecoration(RotatableDecoration dec) {
            if (this.getMiddleDecoration() != null) {
                this.remove((IFigure)this.getMiddleDecoration());
            }
            this.middleDecoration = dec;
            if (dec != null) {
                this.add((IFigure)dec, new ArrowLocator((Connection)this, 4){

                    public void relocate(IFigure target) {
                        Point refPoint;
                        PointList points = this.getConnection().getPoints();
                        RotatableDecoration arrow = (RotatableDecoration)target;
                        arrow.setLocation(this.getLocation(points));
                        if (points.size() % 2 == 0) {
                            int i = points.size() / 2;
                            refPoint = points.getPoint(i - 1);
                        } else {
                            int i = (points.size() - 1) / 2;
                            refPoint = points.getPoint(i - 1);
                        }
                        arrow.setReferencePoint(refPoint);
                    }
                });
            }
        }

        public void setStereotypeDisplay(String stereotypes, Image image) {
            if (!"".equals(stereotypes)) {
                this.fAppliedStereotypeLabel.setText(stereotypes);
            } else {
                this.fAppliedStereotypeLabel.setText("");
            }
            this.fAppliedStereotypeLabel.setIcon(image);
        }
    }
}

