/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.WrapTextCellEditor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentCombinedFragmentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CommentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ConstraintEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ContinuationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ExecutionSpecificationEndEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandGuardEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.CombinedFragmentCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.InteractionOperandAppliedStereotypeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomInteractionOperandItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.locator.ContinuationLocator;
import org.eclipse.papyrus.uml.diagram.sequence.locator.TextCellEditorLocator;
import org.eclipse.papyrus.uml.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.ElementIconUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.InteractionOperandModelElementFactory;
import org.eclipse.papyrus.uml.diagram.sequence.util.LoopOperatorUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.NotificationHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Continuation;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class CustomInteractionOperandEditPart
extends InteractionOperandEditPart
implements ITextAwareEditPart,
IPapyrusEditPart {
    private NotificationHelper notifierHelper = null;
    private DirectEditManager manager;
    private IParser parser;
    private boolean firstOperand;

    public CustomInteractionOperandEditPart(View view) {
        super(view);
    }

    protected NotificationHelper getNotifierHelper() {
        if (this.notifierHelper == null) {
            try {
                Field f = InteractionOperandEditPart.class.getDeclaredField("notifier");
                f.setAccessible(true);
                this.notifierHelper = (NotificationHelper)f.get((Object)this);
            }
            catch (Exception e) {
                this.notifierHelper = new NotificationHelper(new UIAdapterImpl(){

                    protected void safeNotifyChanged(Notification msg) {
                        CustomInteractionOperandEditPart.this.handleNotificationEvent(msg);
                    }
                });
            }
        }
        return this.notifierHelper;
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof NodeFigure) {
            ((NodeFigure)this.primaryShape).setLineWidth(width);
        }
        super.setLineWidth(width);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CombinedFragmentCreationEditPolicy());
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomInteractionOperandItemSemanticEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new GuardConditionDirectEditPolicy());
        this.removeEditPolicy("DragDropPolicy");
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new InteractionOperandAppliedStereotypeLabelDisplayEditPolicy());
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof ContinuationEditPart) {
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)new ContinuationLocator(this.getMainFigure(), this.getContinuationPosition(borderItemEditPart)));
            return;
        }
        super.addBorderItem(borderItemContainer, borderItemEditPart);
    }

    private int getContinuationPosition(IBorderItemEditPart borderItemEditPart) {
        Shape shape;
        EObject eObject;
        Object model = borderItemEditPart.getModel();
        if (model instanceof Shape && (eObject = (shape = (Shape)model).getElement()) instanceof Continuation) {
            return ((Continuation)eObject).isSetting() ? 4 : 1;
        }
        return 1;
    }

    static String getGuardLabelText(InteractionOperand interactionOperand, boolean edit) {
        String condition;
        ValueSpecification specification;
        CombinedFragment enclosingCF = (CombinedFragment)interactionOperand.getOwner();
        InteractionOperatorKind cfOperator = enclosingCF.getInteractionOperator();
        InteractionConstraint guard = interactionOperand.getGuard();
        String specValue = null;
        if (guard != null && (specification = guard.getSpecification()) != null) {
            try {
                specValue = specification.stringValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder("");
        if (InteractionOperatorKind.LOOP_LITERAL.equals((Object)cfOperator) && (condition = LoopOperatorUtil.getLoopCondition(guard)) != null) {
            sb.append(condition);
        }
        if (specValue == null) {
            EList operands = enclosingCF.getOperands();
            if (InteractionOperatorKind.ALT_LITERAL.equals((Object)cfOperator) && interactionOperand.equals(operands.get(operands.size() - 1))) {
                specValue = "else";
            }
        }
        if (specValue != null) {
            if (!edit) {
                sb.append('[');
            }
            sb.append(specValue);
            if (!edit) {
                sb.append(']');
            }
        }
        String text = sb.toString();
        return text;
    }

    protected void handleNotificationEvent(Notification notification) {
        LiteralInteger newIntegerValue;
        NotificationHelper notifierHelper = this.getNotifierHelper();
        Object feature = notification.getFeature();
        Object newValue = notification.getNewValue();
        if (UMLPackage.eINSTANCE.getInteractionOperand_Guard().equals(feature)) {
            InteractionConstraint constraint;
            if (notification.getOldValue() instanceof InteractionConstraint) {
                constraint = (InteractionConstraint)notification.getOldValue();
                notifierHelper.unlistenObject((Notifier)constraint);
                notifierHelper.unlistenObject((Notifier)constraint.getSpecification());
                notifierHelper.unlistenObject((Notifier)constraint.getMaxint());
                notifierHelper.unlistenObject((Notifier)constraint.getMinint());
            }
            if (newValue instanceof InteractionConstraint) {
                constraint = (InteractionConstraint)newValue;
                notifierHelper.listenObject((Notifier)constraint);
                notifierHelper.listenObject((Notifier)constraint.getSpecification());
                notifierHelper.listenObject((Notifier)constraint.getMaxint());
                notifierHelper.listenObject((Notifier)constraint.getMinint());
            }
        } else if (UMLPackage.eINSTANCE.getConstraint_Specification().equals(feature)) {
            if (notification.getOldValue() instanceof ValueSpecification) {
                notifierHelper.unlistenObject((Notifier)((ValueSpecification)notification.getOldValue()));
            }
            if (newValue instanceof ValueSpecification) {
                ValueSpecification newStringValue = (ValueSpecification)newValue;
                notifierHelper.listenObject((Notifier)newStringValue);
            }
        } else if (UMLPackage.eINSTANCE.getInteractionConstraint_Minint().equals(feature)) {
            if (notification.getOldValue() instanceof LiteralInteger) {
                notifierHelper.unlistenObject((Notifier)((LiteralInteger)notification.getOldValue()));
            }
            if (newValue instanceof LiteralInteger) {
                newIntegerValue = (LiteralInteger)newValue;
                notifierHelper.listenObject((Notifier)newIntegerValue);
            }
        } else if (UMLPackage.eINSTANCE.getInteractionConstraint_Maxint().equals(feature)) {
            if (notification.getOldValue() instanceof LiteralInteger) {
                notifierHelper.unlistenObject((Notifier)((LiteralInteger)notification.getOldValue()));
            }
            if (newValue instanceof LiteralInteger) {
                newIntegerValue = (LiteralInteger)newValue;
                notifierHelper.listenObject((Notifier)newIntegerValue);
            }
        }
        if (notification.getNotifier() instanceof LiteralInteger && InteractionOperatorKind.LOOP_LITERAL.equals((Object)this.getInteractionOperator())) {
            InteractionConstraint constraint;
            LiteralInteger literalIntNotifier = (LiteralInteger)notification.getNotifier();
            EStructuralFeature containingFeature = literalIntNotifier.eContainingFeature();
            if (UMLPackage.eINSTANCE.getInteractionConstraint_Minint().equals(containingFeature)) {
                constraint = (InteractionConstraint)literalIntNotifier.getOwner();
                if (newValue instanceof Integer) {
                    int max;
                    Integer newMin = (Integer)newValue;
                    if (newMin < 0) {
                        literalIntNotifier.setValue(0);
                    }
                    if (constraint.getMaxint() instanceof LiteralInteger && (max = ((LiteralInteger)constraint.getMaxint()).getValue()) != -1 && newMin > max) {
                        literalIntNotifier.setValue(max);
                    }
                }
            } else if (UMLPackage.eINSTANCE.getInteractionConstraint_Maxint().equals(containingFeature)) {
                constraint = (InteractionConstraint)literalIntNotifier.getOwner();
                if (newValue instanceof Integer) {
                    Integer newMax = (Integer)newValue;
                    int min = 0;
                    if (constraint.getMinint() instanceof LiteralInteger) {
                        min = ((LiteralInteger)constraint.getMinint()).getValue();
                        if (newMax != -1 && newMax < min) {
                            literalIntNotifier.setValue(min);
                        }
                    }
                }
            }
        }
        this.updateConstraintLabel();
        if (UMLPackage.eINSTANCE.getInteractionFragment_Covered().equals(feature) && InteractionOperatorKind.ALT_LITERAL.equals((Object)this.getInteractionOperator())) {
            InteractionOperand interactionOperand = (InteractionOperand)notification.getNotifier();
            EList currentlyCoveredLifeline = interactionOperand.getCovereds();
            for (InteractionFragment interactionFragment : interactionOperand.getFragments()) {
                EList continuationCoveredLifelines;
                if (!(interactionFragment instanceof Continuation) || (continuationCoveredLifelines = interactionFragment.getCovereds()).equals((Object)currentlyCoveredLifeline)) continue;
                ArrayList coveredLifelinesToAdd = new ArrayList(currentlyCoveredLifeline);
                coveredLifelinesToAdd.removeAll((Collection<?>)continuationCoveredLifelines);
                if (!coveredLifelinesToAdd.isEmpty()) {
                    CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)interactionFragment, (Object)UMLPackage.eINSTANCE.getInteractionFragment_Covered(), coveredLifelinesToAdd), true);
                }
                ArrayList coveredLifelinesToRemove = new ArrayList(continuationCoveredLifelines);
                coveredLifelinesToRemove.removeAll((Collection<?>)currentlyCoveredLifeline);
                if (coveredLifelinesToRemove.isEmpty()) continue;
                CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)interactionFragment, (Object)UMLPackage.eINSTANCE.getInteractionFragment_Covered(), coveredLifelinesToRemove), true);
            }
        }
        super.handleNotificationEvent(notification);
        if (this.getModel() != null && this.getModel() == notification.getNotifier() && NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        }
        if (ElementIconUtil.isIconNotification(notification)) {
            this.refreshLabelIcon();
        }
        if (InteractionOperandModelElementFactory.isGuardVisibilityChanged(notification)) {
            this.refreshChildren();
            this.refreshGuard();
        }
    }

    protected List getModelChildren() {
        ArrayList<DecorationNode> modelChildren = new ArrayList<DecorationNode>(super.getModelChildren());
        if (!this.isGuardVisible()) {
            ArrayList result = new ArrayList();
            for (Object e : modelChildren) {
                if (e instanceof View && "InteractionOperand_Guard".equals(((View)e).getType())) continue;
                result.add(e);
            }
            return result;
        }
        boolean hasGuardChild = false;
        for (Object e : modelChildren) {
            if (!(e instanceof View) || !"InteractionOperand_Guard".equals(((View)e).getType())) continue;
            hasGuardChild = true;
            break;
        }
        if (!hasGuardChild) {
            final View view = this.getNotationView();
            final DecorationNode guardNode = NotationFactory.eINSTANCE.createDecorationNode();
            Bounds b = NotationFactory.eINSTANCE.createBounds();
            b.setX(5);
            b.setY(5);
            guardNode.setLayoutConstraint((LayoutConstraint)b);
            guardNode.setType("InteractionOperand_Guard");
            if (view.getElement() instanceof InteractionOperand) {
                guardNode.setElement((EObject)((InteractionOperand)view.getElement()).getGuard());
            }
            CommandHelper.executeCommandWithoutHistory((EditingDomain)this.getEditingDomain(), (Command)new ExecutionSpecificationEndEditPart.DummyCommand(){

                public void execute() {
                    ViewUtil.insertChildView((View)view, (View)guardNode, (int)-1, (boolean)true);
                }
            }, true);
            modelChildren.add(guardNode);
        }
        return modelChildren;
    }

    public boolean isGuardVisible() {
        return InteractionOperandModelElementFactory.isGuardVisible(this.getPrimaryView());
    }

    protected void refreshLabelIcon() {
        Image image = ElementIconUtil.getLabelIcon((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this);
        this.getInteractionConstraintLabel().setIcon(image);
    }

    public WrappingLabel getInteractionConstraintLabel() {
        IGraphicalEditPart child = this.getChildBySemanticHint("InteractionOperand_Guard");
        if (child instanceof InteractionOperandGuardEditPart) {
            IFigure figure = ((InteractionOperandGuardEditPart)child).getFigure();
            if (figure instanceof WrappingLabel) {
                return (WrappingLabel)figure;
            }
            if (figure instanceof InteractionOperandGuardEditPart.GuardFigure) {
                return ((InteractionOperandGuardEditPart.GuardFigure)figure).getPrimaryLabel();
            }
        }
        return this.getPrimaryShape().getInteractionConstraintLabel();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabelIcon();
        this.refreshTransparency();
        this.refreshGuard();
    }

    protected void refreshGuard() {
        IGraphicalEditPart guard = this.getChildBySemanticHint("InteractionOperand_Guard");
        if (!(guard instanceof InteractionOperandGuardEditPart)) {
            return;
        }
        ((InteractionOperandGuardEditPart)guard).refreshLabel();
        EditPolicy editPolicy = this.getEditPolicy("AppliedStereotypeLabelDisplayEditPolicy");
        if (editPolicy instanceof AppliedStereotypeLabelDisplayEditPolicy) {
            ((AppliedStereotypeLabelDisplayEditPolicy)editPolicy).refreshDisplay();
        }
    }

    protected void refreshBackgroundColor() {
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (style != null) {
            if (style.getGradient() == null || !this.supportsGradient()) {
                if (0xFFFFFF == style.getFillColor()) {
                    this.getPrimaryShape().setTransparency(100);
                    this.getPrimaryShape().setIsUsingGradient(true);
                    this.getPrimaryShape().setGradientData(style.getFillColor(), style.getFillColor(), 0);
                } else {
                    this.refreshTransparency();
                    this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(Integer.valueOf(style.getFillColor())));
                }
            } else {
                this.refreshTransparency();
                this.setGradient(style.getGradient());
            }
        }
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void setGradient(GradientData gradient) {
        CustomCustomInteractionOperandFigure fig = this.getPrimaryShape();
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (gradient != null) {
            this.setTransparency(0);
            fig.setIsUsingGradient(true);
            fig.setGradientData(style.getFillColor(), gradient.getGradientColor1(), gradient.getGradientStyle());
        } else {
            fig.setIsUsingGradient(false);
        }
    }

    public boolean supportsGradient() {
        return true;
    }

    protected void setBackgroundColor(Color c) {
        CustomCustomInteractionOperandFigure fig = this.getPrimaryShape();
        fig.setBackgroundColor(c);
        fig.setIsUsingGradient(false);
        fig.setGradientData(-1, -1, 0);
    }

    private InteractionOperatorKind getInteractionOperator() {
        EObject element;
        InteractionOperatorKind interactionOperatorKind = null;
        EditPart parent = this.getParent();
        if (parent instanceof CombinedFragmentCombinedFragmentCompartmentEditPart && (parent = parent.getParent()) instanceof CombinedFragmentEditPart && (element = ((CombinedFragmentEditPart)parent).resolveSemanticElement()) instanceof CombinedFragment) {
            interactionOperatorKind = ((CombinedFragment)element).getInteractionOperator();
        }
        return interactionOperatorKind;
    }

    public void setFirstOperand(boolean firstOperand) {
        this.firstOperand = firstOperand;
        if (this.primaryShape != null) {
            this.getPrimaryShape().setLineSeparator(!firstOperand);
        }
    }

    public void activate() {
        this.addListeners();
        super.activate();
    }

    public void deactivate() {
        if (this.notifierHelper != null) {
            this.notifierHelper.unlistenAll();
        }
        super.deactivate();
    }

    public void removeNotify() {
        if (this.notifierHelper != null) {
            this.notifierHelper.unlistenAll();
        }
        super.removeNotify();
    }

    private void addListeners() {
        InteractionOperand interactionOperand;
        InteractionConstraint guard;
        NotificationHelper notifierHelper = this.getNotifierHelper();
        EObject eObject = this.resolveSemanticElement();
        if (eObject instanceof InteractionOperand && (guard = (interactionOperand = (InteractionOperand)eObject).getGuard()) != null) {
            notifierHelper.listenObject((Notifier)guard);
            notifierHelper.listenObject((Notifier)guard.getSpecification());
            notifierHelper.listenObject((Notifier)guard.getMaxint());
            notifierHelper.listenObject((Notifier)guard.getMinint());
        }
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            WrappingLabel label = this.getInteractionConstraintLabel();
            this.manager = new TextDirectEditManager((GraphicalEditPart)this, WrapTextCellEditor.class, (CellEditorLocator)new TextCellEditorLocator(label));
        }
        return this.manager;
    }

    protected void performDirectEditRequest(Request request) {
        if (request instanceof DirectEditRequest) {
            if (!this.isGuardVisible()) {
                return;
            }
            WrappingLabel label = this.getPrimaryShape().getInteractionConstraintLabel();
            Point location = ((DirectEditRequest)request).getLocation().getCopy();
            label.translateToRelative((Translatable)location);
            if (label.containsPoint(location)) {
                this.getManager().show();
            }
        }
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = new GuardConditionParser();
        }
        return this.parser;
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    public void setLabelText(String text) {
        WrappingLabel label = this.getPrimaryShape().getInteractionConstraintLabel();
        label.setText(text);
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = CustomInteractionOperandEditPart.this.getParserElement();
                    final IParser parser = CustomInteractionOperandEditPart.this.getParser();
                    if (element != null && parser != null) {
                        try {
                            IParserEditStatus valid = (IParserEditStatus)CustomInteractionOperandEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                                public void run() {
                                    this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                                }
                            });
                            return valid.getCode() == 0 ? null : valid.getMessage();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }
        };
    }

    public boolean ignoreRequest(Request request) {
        List parts;
        if (request instanceof ChangeBoundsRequest && (request.getType().equals("add children") || request.getType().equals("drop")) && (parts = ((ChangeBoundsRequest)request).getEditParts()) != null) {
            for (Object obj : parts) {
                if (!(obj instanceof CommentEditPart) && !(obj instanceof ConstraintEditPart) && !(obj instanceof TimeObservationEditPart)) continue;
                return true;
            }
        }
        return false;
    }

    public void showTargetFeedback(Request request) {
        if (this.ignoreRequest(request)) {
            return;
        }
        super.showTargetFeedback(request);
    }

    public org.eclipse.gef.commands.Command getCommand(Request request) {
        if (this.ignoreRequest(request)) {
            return null;
        }
        if (request instanceof ReconnectRequest) {
            if ("Reconnection source".equals(request.getType()) && ((ReconnectRequest)request).getConnectionEditPart().getSource() instanceof GateEditPart) {
                return this.getParent().getParent().getCommand(request);
            }
            if ("Reconnection target".equals(request.getType()) && ((ReconnectRequest)request).getConnectionEditPart().getTarget() instanceof GateEditPart) {
                return this.getParent().getParent().getCommand(request);
            }
        }
        return super.getCommand(request);
    }

    protected void refreshTransparency() {
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (style != null) {
            this.setTransparency(style.getTransparency());
        }
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new CustomCustomInteractionOperandFigure();
        return this.primaryShape;
    }

    public CustomCustomInteractionOperandFigure getPrimaryShape() {
        return (CustomCustomInteractionOperandFigure)this.primaryShape;
    }

    public void updateConstraintLabel() {
        IGraphicalEditPart child = this.getChildBySemanticHint("InteractionOperand_Guard");
        if (child instanceof InteractionOperandGuardEditPart) {
            child.refresh();
        }
    }

    public class CustomCustomInteractionOperandFigure
    extends InteractionOperandEditPart.CustomInteractionOperandFigure {
        public CustomCustomInteractionOperandFigure() {
            super(CustomInteractionOperandEditPart.this);
            this.setLineWidth(2);
            this.setLineSeparator(!CustomInteractionOperandEditPart.this.firstOperand);
            this.getInteractionConstraintLabel().setVisible(false);
        }

        protected boolean useLocalCoordinates() {
            return true;
        }

        protected void paintBackground(Graphics graphics, Rectangle rectangle) {
            graphics.pushState();
            super.paintBackground(graphics, rectangle);
            graphics.popState();
        }

        protected void updateConstraintLabel() {
            if (!CustomInteractionOperandEditPart.this.isGuardVisible()) {
                this.getInteractionConstraintLabel().setText("");
            } else {
                String text = "";
                EObject parserElement = CustomInteractionOperandEditPart.this.getParserElement();
                if (parserElement != null && CustomInteractionOperandEditPart.this.getParser() != null) {
                    text = CustomInteractionOperandEditPart.this.getParser().getPrintString((IAdaptable)new EObjectAdapter(parserElement), CustomInteractionOperandEditPart.this.getParserOptions().intValue());
                }
                this.getInteractionConstraintLabel().setText(text);
            }
        }
    }

    private static class EObjectAdapterEx
    extends EObjectAdapter {
        private View view = null;

        public EObjectAdapterEx(EObject element, View view) {
            super(element);
            this.view = view;
        }

        public Object getAdapter(Class adapter) {
            Object o = super.getAdapter(adapter);
            if (o != null) {
                return o;
            }
            if (adapter.equals(View.class)) {
                return this.view;
            }
            return null;
        }
    }

    class GuardConditionDirectEditPolicy
    extends DirectEditPolicy {
        GuardConditionDirectEditPolicy() {
        }

        protected org.eclipse.gef.commands.Command getDirectEditCommand(DirectEditRequest edit) {
            String labelText = (String)edit.getCellEditor().getValue();
            if (labelText == null) {
                return null;
            }
            ITextAwareEditPart compartment = (ITextAwareEditPart)this.getHost();
            EObject model = (EObject)compartment.getModel();
            EObjectAdapterEx elementAdapter = null;
            if (model instanceof View) {
                View view = (View)model;
                elementAdapter = new EObjectAdapterEx(ViewUtil.resolveSemanticElement((View)view), view);
            } else {
                elementAdapter = new EObjectAdapterEx(model, null);
            }
            String prevText = compartment.getParser().getEditString((IAdaptable)elementAdapter, compartment.getParserOptions().intValue());
            if (!prevText.equals(labelText)) {
                ICommand iCommand = compartment.getParser().getParseCommand((IAdaptable)elementAdapter, labelText, 0);
                return new ICommandProxy(iCommand);
            }
            CustomInteractionOperandEditPart.this.getPrimaryShape().updateConstraintLabel();
            return null;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            String value = (String)request.getCellEditor().getValue();
            WrappingLabel label = CustomInteractionOperandEditPart.this.getPrimaryShape().getInteractionConstraintLabel();
            label.setText(value);
        }
    }

    private static class GuardConditionParser
    extends MessageFormatParser
    implements ISemanticParser {
        public GuardConditionParser() {
            super(new EAttribute[]{UMLPackage.eINSTANCE.getLiteralInteger_Value(), UMLPackage.eINSTANCE.getLiteralString_Value()});
        }

        public List getSemanticElementsBeingParsed(EObject element) {
            ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
            if (element instanceof InteractionOperand) {
                InteractionOperand op = (InteractionOperand)element;
                semanticElementsBeingParsed.add(op);
                semanticElementsBeingParsed.add(op.getGuard());
            }
            return semanticElementsBeingParsed;
        }

        public boolean areSemanticElementsAffected(EObject listener, Object notification) {
            EStructuralFeature feature = this.getEStructuralFeature(notification);
            return this.isValidFeature(feature);
        }

        public boolean isAffectingEvent(Object event, int flags) {
            EStructuralFeature feature = this.getEStructuralFeature(event);
            return this.isValidFeature(feature);
        }

        public String getPrintString(IAdaptable element, int flags) {
            Object adapter = element.getAdapter(EObject.class);
            if (adapter instanceof InteractionOperand) {
                InteractionOperand interactionOperand = (InteractionOperand)adapter;
                return CustomInteractionOperandEditPart.getGuardLabelText(interactionOperand, false);
            }
            return "";
        }

        public IParserEditStatus isValidEditString(IAdaptable adapter, String editString) {
            return ParserEditStatus.EDITABLE_STATUS;
        }

        public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
            EObject element = (EObject)adapter.getAdapter(EObject.class);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)element);
            if (editingDomain == null || !(element instanceof InteractionOperand)) {
                return UnexecutableCommand.INSTANCE;
            }
            InteractionOperand interactionOperand = (InteractionOperand)element;
            InteractionConstraint guard = interactionOperand.getGuard();
            CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Values");
            command.compose((IUndoableOperation)new UpdateGuardConditionCommand(editingDomain, interactionOperand, guard, newString));
            return command;
        }

        public String getEditString(IAdaptable element, int flags) {
            Object adapter = element.getAdapter(EObject.class);
            if (adapter instanceof InteractionOperand) {
                InteractionOperand interactionOperand = (InteractionOperand)adapter;
                return CustomInteractionOperandEditPart.getGuardLabelText(interactionOperand, true);
            }
            return "";
        }

        protected EStructuralFeature getEStructuralFeature(Object notification) {
            Object feature;
            EStructuralFeature featureImpl = null;
            if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
                featureImpl = (EStructuralFeature)feature;
            }
            return featureImpl;
        }

        private boolean isValidFeature(EStructuralFeature feature) {
            return UMLPackage.eINSTANCE.getInteractionConstraint_Maxint().equals(feature) || UMLPackage.eINSTANCE.getInteractionConstraint_Minint().equals(feature) || UMLPackage.eINSTANCE.getConstraint_Specification().equals(feature);
        }
    }

    private static class UpdateGuardConditionCommand
    extends AbstractTransactionalCommand {
        private InteractionConstraint guard;
        private String text;
        private InteractionOperand interactionOperand;

        public UpdateGuardConditionCommand(TransactionalEditingDomain domain, InteractionOperand interactionOperand, InteractionConstraint guard, String text) {
            super(domain, null, null);
            this.interactionOperand = interactionOperand;
            this.guard = guard;
            this.text = text;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CombinedFragment enclosingCF = (CombinedFragment)this.interactionOperand.getOwner();
            InteractionOperatorKind cfOperator = enclosingCF.getInteractionOperator();
            if (InteractionOperatorKind.LOOP_LITERAL.equals((Object)cfOperator)) {
                if (this.text.contains("]") && this.text.contains("[")) {
                    String[] parts = this.text.split("]");
                    String[] nums = parts[0].replaceAll("\\[", "").split(",");
                    int min = 0;
                    int max = -1;
                    min = this.parseInt(nums[0], 0);
                    int n = max = nums.length > 1 ? this.parseInt(nums[1], -1) : min;
                    if (this.guard.getMinint() != null) {
                        this.setIntValue(this.guard.getMinint(), min);
                    } else {
                        this.guard.setMinint((ValueSpecification)this.createLiteralInteger(min));
                    }
                    if (this.guard.getMaxint() != null) {
                        this.setIntValue(this.guard.getMaxint(), max);
                    } else {
                        this.guard.setMaxint((ValueSpecification)this.createLiteralInteger(max));
                    }
                    this.text = parts.length > 1 ? (parts[1] == null ? "" : parts[1].trim()) : "";
                } else {
                    this.guard.setMinint(null);
                    this.guard.setMaxint(null);
                }
            }
            if (this.guard.getSpecification() != null || this.text.length() > 0) {
                LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
                literalString.setValue(this.text);
                this.guard.setSpecification((ValueSpecification)literalString);
            }
            return CommandResult.newOKCommandResult();
        }

        private LiteralInteger createLiteralInteger(int val) {
            LiteralInteger li = UMLFactory.eINSTANCE.createLiteralInteger();
            li.setValue(val);
            return li;
        }

        private void setIntValue(ValueSpecification spec, int val) {
            if (spec instanceof LiteralInteger) {
                ((LiteralInteger)spec).setValue(val);
            }
        }

        private int parseInt(String string, int defaultInt) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return defaultInt;
            }
        }
    }
}

