/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.util.MessageDirection;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BorderItemLabelEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AppliedStereotypeExternalNodeLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.locator.GateLocator;
import org.eclipse.papyrus.uml.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class GateNameEditPart
extends BorderItemLabelEditPart
implements IPapyrusEditPart {
    public static final String GATE_NAME_TYPE = "Gate_Name";

    static {
        GateNameEditPart.registerSnapBackPosition((String)GATE_NAME_TYPE, (Point)new Point(-32, 0));
    }

    public GateNameEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new UMLTextSelectionEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeExternalNodeLabelEditPolicy());
    }

    public IFigure getPrimaryShape() {
        return this.getFigure();
    }

    public IBorderItemLocator getBorderItemLocator() {
        IFigure parentFigure = this.getFigure().getParent();
        if (parentFigure != null && parentFigure.getLayoutManager() != null) {
            Object constraint = parentFigure.getLayoutManager().getConstraint(this.getFigure());
            return (IBorderItemLocator)constraint;
        }
        return null;
    }

    protected Point getLocation() {
        Point location = super.getLocation();
        if (location.x == 0 && location.y == 0) {
            Dimension size = this.getSize();
            EditPart parent = this.getParent();
            if (parent instanceof GateEditPart) {
                GateEditPart gateEditPart = (GateEditPart)parent;
                EObject elt = gateEditPart.resolveSemanticElement();
                Dimension preferredSize = this.getFigure().getPreferredSize(size.width, size.height);
                IBorderItemLocator locator = gateEditPart.getBorderItemLocator();
                if (locator instanceof GateLocator) {
                    int alignment = ((GateLocator)locator).getAlignment(((GateLocator)locator).getConstraint());
                    if (1 == alignment) {
                        location.x = gateEditPart.getTargetConnections().isEmpty() ? -preferredSize.width - 1 : GateEditPart.DEFAULT_SIZE.width + 1;
                        location.y = elt instanceof Gate && GateHelper.isInnerCFGate((Gate)elt) ? GateEditPart.DEFAULT_SIZE.height - 2 : -GateEditPart.DEFAULT_SIZE.height + 2;
                    } else if (4 == alignment) {
                        location.x = gateEditPart.getSourceConnections().isEmpty() ? GateEditPart.DEFAULT_SIZE.width + 1 : -preferredSize.width - 1;
                        location.y = elt instanceof Gate && GateHelper.isInnerCFGate((Gate)elt) ? GateEditPart.DEFAULT_SIZE.height - 2 : -GateEditPart.DEFAULT_SIZE.height + 2;
                    } else if (8 == alignment) {
                        location.y = -GateEditPart.DEFAULT_SIZE.height - 1;
                    } else if (32 == alignment) {
                        location.y = GateEditPart.DEFAULT_SIZE.height + 1;
                    }
                }
            }
        }
        return location;
    }

    protected IParser createParser() {
        return new GateNameParser();
    }

    protected IFigure createFigurePrim() {
        return new GateNameFigure();
    }

    public class GateNameFigure
    extends Figure
    implements ILabelFigure,
    IPapyrusNodeUMLElementFigure {
        protected static final String LEFT_BRACE = "{";
        protected static final String RIGHT_BRACE = "}";
        private WrappingLabel namedLabel;
        private Label stereotypesLabel;
        private Label stereotypePropertiesLabel;

        public GateNameFigure() {
            this.setBorder((Border)new MarginBorder(2));
            ToolbarLayout layout = new ToolbarLayout(false);
            layout.setStretchMinorAxis(true);
            this.setLayoutManager((LayoutManager)layout);
            this.createContents();
        }

        protected void createContents() {
            this.namedLabel = new WrappingLabel();
            this.namedLabel.setTextWrap(true);
            this.namedLabel.setAlignment(2);
            this.add((IFigure)this.namedLabel);
        }

        public void setStereotypeDisplay(String stereotypes, Image image) {
            if (stereotypes == null || stereotypes.trim().equals("")) {
                if (this.stereotypesLabel != null) {
                    this.remove((IFigure)this.stereotypesLabel);
                }
                this.stereotypesLabel = null;
            } else if (this.stereotypesLabel == null) {
                this.stereotypesLabel = new Label(stereotypes, image);
                this.add((IFigure)this.stereotypesLabel, 0);
            } else {
                this.stereotypesLabel.setText(stereotypes);
                this.stereotypesLabel.setIcon(image);
            }
        }

        public void setStereotypePropertiesInBrace(String stereotypeProperties) {
            if (stereotypeProperties == null || stereotypeProperties.trim().equals("")) {
                if (this.stereotypePropertiesLabel != null) {
                    this.remove((IFigure)this.stereotypePropertiesLabel);
                }
                this.stereotypePropertiesLabel = null;
            } else {
                if (this.stereotypePropertiesLabel == null) {
                    this.stereotypePropertiesLabel = new Label();
                    int index = this.getChildren().indexOf(this.stereotypesLabel);
                    this.add((IFigure)this.stereotypePropertiesLabel, index + 1);
                }
                this.stereotypePropertiesLabel.setText(LEFT_BRACE + stereotypeProperties + RIGHT_BRACE);
            }
        }

        public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
        }

        public Label getStereotypesLabel() {
            return this.stereotypesLabel;
        }

        public void setText(String text) {
            this.namedLabel.setText(text);
        }

        public String getText() {
            return this.namedLabel.getText();
        }

        public void setIcon(Image icon) {
            this.namedLabel.setIcon(icon);
        }

        public Image getIcon() {
            return this.namedLabel.getIcon();
        }
    }

    public class GateNameParser
    extends MessageFormatParser
    implements ISemanticParser {
        public GateNameParser() {
            super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
        }

        public String getPrintString(IAdaptable adapter, int flags) {
            return super.getPrintString(adapter, flags);
        }

        protected String getPrintString(Gate gate) {
            Message message = gate.getMessage();
            if (message != null) {
                MessageDirection direction = null;
                EObject parent = gate.eContainer();
                if (parent instanceof CombinedFragment) {
                    CombinedFragment cf = (CombinedFragment)parent;
                    if (gate == message.getSendEvent()) {
                        MessageEnd receiveEvent = message.getReceiveEvent();
                        Lifeline lifeline = this.getCoveredBy(receiveEvent);
                        if (!cf.getCovereds().contains((Object)lifeline)) {
                            direction = MessageDirection.OUT;
                        }
                    } else {
                        MessageEnd sendEvent = message.getSendEvent();
                        Lifeline coveredBy = this.getCoveredBy(sendEvent);
                        if (!cf.getCovereds().contains((Object)coveredBy)) {
                            direction = MessageDirection.IN;
                        }
                    }
                } else if (parent instanceof Interaction) {
                    if (gate == message.getSendEvent()) {
                        direction = MessageDirection.IN;
                    } else if (gate == message.getReceiveEvent()) {
                        direction = MessageDirection.OUT;
                    }
                }
                if (direction == null) {
                    if (gate == message.getSendEvent()) {
                        direction = MessageDirection.OUT;
                    } else if (gate == message.getReceiveEvent()) {
                        direction = MessageDirection.IN;
                    }
                }
                if (direction != null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(String.valueOf(direction.getName()) + "_");
                    buf.append(message.getName());
                    return new String(buf);
                }
            }
            return null;
        }

        private Lifeline getCoveredBy(MessageEnd messageEnd) {
            if (messageEnd == null) {
                return null;
            }
            if (messageEnd instanceof OccurrenceSpecification) {
                return ((OccurrenceSpecification)messageEnd).getCovered();
            }
            return null;
        }

        protected EStructuralFeature getEStructuralFeature(Object notification) {
            Object feature;
            EStructuralFeature featureImpl = null;
            if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
                featureImpl = (EStructuralFeature)feature;
            }
            return featureImpl;
        }

        private boolean isValidFeature(EStructuralFeature feature) {
            return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature);
        }

        public List getSemanticElementsBeingParsed(EObject element) {
            if (element instanceof Gate) {
                return Collections.singletonList(element);
            }
            return Collections.emptyList();
        }

        public boolean areSemanticElementsAffected(EObject listener, Object notification) {
            EStructuralFeature feature = this.getEStructuralFeature(notification);
            return this.isValidFeature(feature);
        }
    }
}

