/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandUtilities;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateViewAndOptionallyElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.SuppressibleUIRequest;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateGateViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragment2EditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.GatesHolderGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.GateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;

public class InteractionGraphicalNodeEditPolicy
extends GatesHolderGraphicalNodeEditPolicy {
    public EditPart getTargetEditPart(Request request) {
        if ("connection end".equals(request.getType()) && this.isCreateConnectionRequest(request, UMLElementTypes.Message_4006)) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }

    public Command getCommand(Request request) {
        if ("connection end".equals(request.getType()) && this.isCreateConnectionRequest(request, UMLElementTypes.Message_4006)) {
            return this.getMessageCreateAndLifelineCommands((CreateConnectionRequest)request);
        }
        if ("connection start".equals(request.getType()) && request instanceof CreateConnectionRequest) {
            request.getExtendedData().put("Location of connection source point", ((CreateConnectionRequest)request).getLocation());
        }
        return super.getCommand(request);
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Command command = super.getConnectionCompleteCommand(request);
        if (command != null && command.canExecute() && "connection end".equals(request.getType()) && this.isCreateConnectionRequest((Request)request, UMLElementTypes.Message_4008)) {
            EditPart sourceEditPart = request.getSourceEditPart();
            EObject source = ViewUtil.resolveSemanticElement((View)((View)sourceEditPart.getModel()));
            if (!(sourceEditPart instanceof CombinedFragment2EditPart) && (source instanceof CombinedFragment || source instanceof Interaction || source instanceof InteractionUse)) {
                IAdaptable elementAdapter;
                CreateRequest realRequest;
                List elementTypes;
                Point location = null;
                IGraphicalEditPart adapter = (IGraphicalEditPart)sourceEditPart.getAdapter(IGraphicalEditPart.class);
                TransactionalEditingDomain editingDomain = null;
                if (adapter != null) {
                    location = GateHelper.computeGateLocation(request.getLocation(), adapter.getFigure(), null);
                    editingDomain = adapter.getEditingDomain();
                }
                CreateConnectionViewRequest.ConnectionViewDescriptor edgeAdaptor = null;
                if (request instanceof CreateConnectionViewRequest) {
                    edgeAdaptor = ((CreateConnectionViewRequest)request).getConnectionViewDescriptor();
                } else if (request instanceof CreateUnspecifiedTypeConnectionRequest && (elementTypes = ((CreateUnspecifiedTypeConnectionRequest)request).getElementTypes()).size() == 1 && (realRequest = ((CreateUnspecifiedTypeConnectionRequest)request).getRequestForType((IElementType)elementTypes.get(0))) instanceof CreateConnectionViewRequest) {
                    edgeAdaptor = ((CreateConnectionViewRequest)realRequest).getConnectionViewDescriptor();
                }
                if (edgeAdaptor != null && (elementAdapter = edgeAdaptor.getElementAdapter()) != null) {
                    CompoundCommand cc = new CompoundCommand("Redirect to Gate");
                    cc.add(command);
                    IAdaptable gateAdaptor = new IAdaptable(){

                        public Object getAdapter(Class adapter) {
                            Message message;
                            MessageEnd sendEvent;
                            if (Gate.class == adapter && (sendEvent = (message = (Message)elementAdapter.getAdapter(Message.class)).getSendEvent()) instanceof Gate) {
                                return sendEvent;
                            }
                            return null;
                        }
                    };
                    CreateGateViewCommand createGateCommand = new CreateGateViewCommand(editingDomain, (IAdaptable)sourceEditPart, location, gateAdaptor);
                    cc.add((Command)new ICommandProxy((ICommand)createGateCommand));
                    SetConnectionEndsCommand resetSourceCommand = new SetConnectionEndsCommand(editingDomain, null);
                    resetSourceCommand.setEdgeAdaptor((IAdaptable)edgeAdaptor);
                    resetSourceCommand.setNewSourceAdaptor(createGateCommand.getResult());
                    cc.add((Command)new ICommandProxy((ICommand)resetSourceCommand));
                    SetConnectionAnchorsCommand resetSourceAnchorsCommand = new SetConnectionAnchorsCommand(editingDomain, null);
                    resetSourceAnchorsCommand.setEdgeAdaptor((IAdaptable)edgeAdaptor);
                    resetSourceAnchorsCommand.setNewSourceTerminal("(1, 0.5)");
                    cc.add((Command)new ICommandProxy((ICommand)resetSourceAnchorsCommand));
                    return cc.unwrap();
                }
            }
        }
        return command;
    }

    protected Command getMessageCreateAndLifelineCommands(CreateConnectionRequest request) {
        InteractionEditPart iep = (InteractionEditPart)this.getHost();
        IGraphicalEditPart container = iep.getChildBySemanticHint("7001");
        CompoundCommand cc = new CompoundCommand(DiagramUIMessages.Command_CreateRelationship_Label);
        CreateViewAndOptionallyElementCommand createOtherEndCmd = new CreateViewAndOptionallyElementCommand((IAdaptable)UMLElementTypes.Lifeline_3001, container, request.getLocation(), iep.getDiagramPreferencesHint());
        cc.add((Command)new ICommandProxy((ICommand)createOtherEndCmd));
        CreateMessageCreateWithLifelineCommand connectionCmd = new CreateMessageCreateWithLifelineCommand((CreateRequest)request, (IAdaptable)UMLElementTypes.Message_4006, (IAdaptable)request.getSourceEditPart(), createOtherEndCmd.getResult(), iep.getViewer());
        cc.add((Command)new ICommandProxy((ICommand)connectionCmd));
        return cc;
    }

    private static class CreateMessageCreateWithLifelineCommand
    extends AbstractCommand {
        private CreateRequest request = null;
        private IAdaptable typeInfoAdapter = null;
        private IAdaptable sourceViewAdapter = null;
        private IAdaptable targetViewAdapter = null;
        private Command command = null;
        private EditPartViewer viewer = null;

        public CreateMessageCreateWithLifelineCommand(CreateRequest request, IAdaptable typeInfoAdapter, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer currentViewer) {
            super(DiagramUIMessages.Commands_CreateCommand_Connection_Label, null);
            Assert.isNotNull((Object)currentViewer, (String)"currentViewer is null");
            this.request = request;
            this.typeInfoAdapter = typeInfoAdapter;
            this.sourceViewAdapter = sourceViewAdapter;
            this.targetViewAdapter = targetViewAdapter;
            this.viewer = currentViewer;
        }

        public List getAffectedFiles() {
            View view;
            EditPart editpart;
            if (this.viewer != null && (editpart = this.viewer.getRootEditPart().getContents()) instanceof IGraphicalEditPart && (view = (View)editpart.getModel()) != null) {
                IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
                return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
            }
            return super.getAffectedFiles();
        }

        public boolean canUndo() {
            return this.command != null && this.command.canUndo();
        }

        public boolean canRedo() {
            return CommandUtilities.canRedo((Command)this.command);
        }

        protected EditPart getSourceEditPart() {
            return (IGraphicalEditPart)this.viewer.getEditPartRegistry().get(this.sourceViewAdapter.getAdapter(View.class));
        }

        protected EditPart getTargetEditPart() {
            return (IGraphicalEditPart)this.viewer.getEditPartRegistry().get(this.targetViewAdapter.getAdapter(View.class));
        }

        public boolean canExecute() {
            if (!(this.request instanceof CreateConnectionViewRequest) && !(this.request instanceof CreateUnspecifiedTypeConnectionRequest)) {
                return false;
            }
            if (this.request instanceof CreateUnspecifiedTypeConnectionRequest) {
                if (this.typeInfoAdapter == null) {
                    return false;
                }
                IElementType typeInfo = (IElementType)this.typeInfoAdapter.getAdapter(IElementType.class);
                if (typeInfo != null && ((CreateUnspecifiedTypeConnectionRequest)this.request).getRequestForType(typeInfo) == null) {
                    return false;
                }
            }
            return true;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            CreateConnectionViewRequest req = null;
            if (this.request != null) {
                if (this.request instanceof CreateConnectionViewRequest) {
                    req = (CreateConnectionViewRequest)this.request;
                }
            } else {
                return CommandResult.newErrorCommandResult((String)this.getLabel());
            }
            if (this.typeInfoAdapter != null) {
                IElementType typeInfo = (IElementType)this.typeInfoAdapter.getAdapter(IElementType.class);
                if (typeInfo == null) {
                    return CommandResult.newErrorCommandResult((String)this.getLabel());
                }
                if (this.request instanceof CreateUnspecifiedTypeConnectionRequest) {
                    req = (CreateConnectionViewRequest)((CreateUnspecifiedTypeConnectionRequest)this.request).getRequestForType(typeInfo);
                }
            }
            if (this.targetViewAdapter.getAdapter(IGraphicalEditPart.class) == null && req instanceof SuppressibleUIRequest) {
                ((SuppressibleUIRequest)req).setSuppressibleUI(true);
            }
            EditPart sourceEP = this.getSourceEditPart();
            EditPart targetEP = this.getTargetEditPart();
            if (sourceEP == null || targetEP == null) {
                return null;
            }
            if (req instanceof CreateConnectionViewAndElementRequest) {
                req.getExtendedData().put("Target model container", SequenceUtil.findInteractionFragmentContainerAt(req.getLocation(), this.getTargetEditPart()));
                this.command = CreateConnectionViewAndElementRequest.getCreateCommand((CreateConnectionViewRequest)req, (EditPart)sourceEP, (EditPart)targetEP);
            } else {
                this.command = CreateConnectionViewRequest.getCreateCommand((CreateConnectionViewRequest)req, (EditPart)sourceEP, (EditPart)targetEP);
            }
            if (this.command != null && this.command.canExecute()) {
                this.command.execute();
            }
            this.viewer = null;
            View view = (View)req.getConnectionViewDescriptor().getAdapter(View.class);
            if (view == null) {
                return CommandResult.newCancelledCommandResult();
            }
            return CommandResult.newOKCommandResult((Object)req.getNewObject());
        }

        public String getLabel() {
            if (this.command != null) {
                return this.command.getLabel();
            }
            return null;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.command != null) {
                this.command.redo();
            }
            return CommandResult.newOKCommandResult();
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.command != null) {
                this.command.undo();
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

