/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineNameEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineLabelHelper;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifelineLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        Lifeline lifeline = this.getUMLElement();
        if (lifeline == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)lifeline, (NotificationListener)this);
        ConnectableElement ce = lifeline.getRepresents();
        if (ce != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)ce, (NotificationListener)this);
            if (ce.getType() != null) {
                this.getDiagramEventBroker().addNotificationListener((EObject)ce.getType(), (NotificationListener)this);
            }
        }
    }

    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        Lifeline lifeline = this.getUMLElement();
        if (lifeline == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)lifeline, (NotificationListener)this);
        ConnectableElement ce = lifeline.getRepresents();
        if (ce != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)ce, (NotificationListener)this);
            if (ce.getType() != null) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)ce.getType(), (NotificationListener)this);
            }
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        if (object == null || this.getUMLElement() == null) {
            return;
        }
        if (notification.getFeature().equals(UMLPackage.eINSTANCE.getNamedElement_Name())) {
            this.refreshDisplay();
        } else if (notification.getFeature().equals(UMLPackage.Literals.LIFELINE__REPRESENTS)) {
            ConnectableElement ce;
            if (notification.getNewValue() instanceof ConnectableElement) {
                ce = (ConnectableElement)notification.getNewValue();
                this.getDiagramEventBroker().addNotificationListener((EObject)ce, (NotificationListener)this);
                if (ce.getType() != null) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)ce.getType(), (NotificationListener)this);
                }
            }
            if (notification.getOldValue() instanceof ConnectableElement) {
                ce = (ConnectableElement)notification.getOldValue();
                this.getDiagramEventBroker().removeNotificationListener((EObject)ce, (NotificationListener)this);
                if (ce.getType() != null) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)ce.getType(), (NotificationListener)this);
                }
            }
            this.refreshDisplay();
        } else if (this.isMaskManagedAnnotation(object) || this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        } else if (object.equals(this.getUMLElement().getRepresents())) {
            if (notification.getNewValue() instanceof Type && notification.getNewValue() instanceof EObject) {
                this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
            }
            if (notification.getOldValue() instanceof Type && notification.getOldValue() instanceof EObject) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
            }
            this.refreshDisplay();
        }
    }

    public void refreshDisplay() {
        LifelineEditPart lp = (LifelineEditPart)this.getHost();
        List children = lp.getChildren();
        for (Object p : children) {
            if (!(p instanceof LifelineNameEditPart)) continue;
            LifelineLabelHelper.getInstance().refreshEditPartDisplay((GraphicalEditPart)p);
        }
    }

    public Collection<String> getDefaultDisplayValue() {
        return LifelineLabelHelper.DEFAULT_LABEL_DISPLAY;
    }

    public Map<String, String> getMasks() {
        return LifelineLabelHelper.getInstance().getMasks();
    }

    public Lifeline getUMLElement() {
        return (Lifeline)this.hostSemanticElement;
    }
}

