/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.MessageLabelHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    private DefaultValueListener defaultValueListener;

    public void refreshDisplay() {
        ConnectionEditPart lp = (ConnectionEditPart)this.getHost();
        List children = lp.getChildren();
        for (Object p : children) {
            if (!(p instanceof ICustomMessageLabel)) continue;
            MessageLabelHelper.getInstance().refreshEditPartDisplay((GraphicalEditPart)p);
        }
    }

    public Collection<String> getDefaultDisplayValue() {
        return MessageLabelHelper.getInstance().getDefaultValue();
    }

    public Map<String, String> getMasks() {
        return MessageLabelHelper.getInstance().getMasks();
    }

    public Message getUMLElement() {
        if (this.hostSemanticElement instanceof Message) {
            return (Message)this.hostSemanticElement;
        }
        return null;
    }

    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        this.defaultValueListener = new DefaultValueListener();
        Message e = this.getUMLElement();
        if (e == null || e.getSignature() == null) {
            return;
        }
        this.hookMessageSignature(e.getSignature());
        EList argments = e.getArguments();
        for (ValueSpecification v : argments) {
            if (!(v instanceof EObject)) continue;
            this.getDiagramEventBroker().addNotificationListener((EObject)v, (NotificationListener)this);
        }
    }

    private void hookMessageSignature(NamedElement sig) {
        block4: {
            block3: {
                if (sig == null) {
                    return;
                }
                if (!(sig instanceof Operation)) break block3;
                Operation operation = (Operation)sig;
                this.getDiagramEventBroker().addNotificationListener((EObject)operation, (NotificationListener)this);
                for (Parameter parameter : operation.getOwnedParameters()) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)parameter, (NotificationListener)this);
                    this.getDiagramEventBroker().addNotificationListener((EObject)parameter.getDefaultValue(), (NotificationListener)this.defaultValueListener);
                    this.getDiagramEventBroker().addNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
                }
                break block4;
            }
            if (!(sig instanceof Signal)) break block4;
            Signal signal = (Signal)sig;
            this.getDiagramEventBroker().addNotificationListener((EObject)signal, (NotificationListener)this);
            for (Property property : signal.getOwnedAttributes()) {
                this.getDiagramEventBroker().addNotificationListener((EObject)property, (NotificationListener)this);
                this.getDiagramEventBroker().addNotificationListener((EObject)property.getDefaultValue(), (NotificationListener)this.defaultValueListener);
                this.getDiagramEventBroker().addNotificationListener((EObject)property.getType(), (NotificationListener)this);
            }
        }
    }

    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        Message e = this.getUMLElement();
        if (e == null || e.getSignature() == null) {
            return;
        }
        this.unhookMessageSignature(e.getSignature());
        EList argments = e.getArguments();
        for (ValueSpecification v : argments) {
            if (!(v instanceof EObject)) continue;
            this.getDiagramEventBroker().removeNotificationListener((EObject)v, (NotificationListener)this);
        }
    }

    private void unhookMessageSignature(NamedElement sig) {
        block4: {
            block3: {
                if (sig == null) {
                    return;
                }
                if (!(sig instanceof Operation)) break block3;
                Operation operation = (Operation)sig;
                this.getDiagramEventBroker().removeNotificationListener((EObject)operation, (NotificationListener)this);
                for (Parameter parameter : operation.getOwnedParameters()) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)parameter, (NotificationListener)this);
                    this.getDiagramEventBroker().removeNotificationListener((EObject)parameter.getDefaultValue(), (NotificationListener)this.defaultValueListener);
                    this.getDiagramEventBroker().removeNotificationListener((EObject)parameter.getType(), (NotificationListener)this);
                }
                break block4;
            }
            if (!(sig instanceof Signal)) break block4;
            Signal signal = (Signal)sig;
            this.getDiagramEventBroker().removeNotificationListener((EObject)signal, (NotificationListener)this);
            for (Property property : signal.getOwnedAttributes()) {
                this.getDiagramEventBroker().removeNotificationListener((EObject)property, (NotificationListener)this);
                this.getDiagramEventBroker().removeNotificationListener((EObject)property.getDefaultValue(), (NotificationListener)this.defaultValueListener);
                this.getDiagramEventBroker().removeNotificationListener((EObject)property.getType(), (NotificationListener)this);
            }
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        Message e = this.getUMLElement();
        if (e == null) {
            return;
        }
        if (UMLPackage.Literals.MESSAGE__ARGUMENT.equals(notification.getFeature())) {
            this.parameterListChange(notification);
            return;
        }
        if (e.getArguments().contains(object)) {
            this.refreshDisplay();
            return;
        }
        NamedElement sig = e.getSignature();
        if (sig instanceof Operation) {
            Operation operation = (Operation)sig;
            if (object.equals(operation)) {
                this.notifyOperationChanged(operation, notification);
            } else if (this.isParameter(object, operation)) {
                this.notifyParameterChanged(notification);
            } else if (this.isParameterType(object, operation)) {
                this.notifyTypeChanged(notification);
            }
        } else if (sig instanceof Signal) {
            Element own;
            Signal signal = (Signal)sig;
            if (object.equals(signal)) {
                this.notifySignalChanged(signal, notification);
            } else if (this.isProperty(object, signal)) {
                this.notifyPropertyChanged(notification);
            } else if (this.isPropertyType(object, signal)) {
                this.notifyTypeChanged(notification);
            } else if (object instanceof ValueSpecification && this.isProperty(own = ((ValueSpecification)object).getOwner(), signal)) {
                this.refreshDisplay();
            }
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        } else if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        } else if (sig == null && object instanceof Message && notification.getFeature().equals(UMLPackage.eINSTANCE.getNamedElement_Name())) {
            this.refreshDisplay();
        } else if (UMLPackage.eINSTANCE.getMessage_Signature() == notification.getFeature()) {
            Object newValue;
            Object oldValue = notification.getOldValue();
            if (oldValue instanceof NamedElement) {
                this.unhookMessageSignature((NamedElement)oldValue);
            }
            if ((newValue = notification.getNewValue()) instanceof NamedElement) {
                this.hookMessageSignature((NamedElement)newValue);
            }
            this.refreshDisplay();
        }
    }

    private void notifyPropertyChanged(Notification notification) {
        switch (notification.getFeatureID(Property.class)) {
            case 35: {
                if (notification.getOldValue() instanceof EObject) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this.defaultValueListener);
                }
                if (notification.getNewValue() instanceof EObject) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this.defaultValueListener);
                }
                this.refreshDisplay();
                break;
            }
            case 5: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.refreshDisplay();
                break;
            }
            case 15: {
                this.parameterListChange(notification);
                break;
            }
        }
    }

    protected void notifyParameterChanged(Notification notification) {
        switch (notification.getFeatureID(Parameter.class)) {
            case 21: {
                if (notification.getOldValue() instanceof EObject) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this.defaultValueListener);
                }
                if (notification.getNewValue() instanceof EObject) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this.defaultValueListener);
                }
                this.refreshDisplay();
                break;
            }
            case 5: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 25: {
                this.refreshDisplay();
                break;
            }
            case 10: {
                this.parameterListChange(notification);
                break;
            }
        }
    }

    protected void parameterListChange(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                this.refreshDisplay();
                break;
            }
            case 5: {
                if (notification.getNewValue() instanceof List) {
                    List addedElements = (List)notification.getNewValue();
                    for (Object addedElement : addedElements) {
                        if (!(addedElement instanceof EObject)) continue;
                        this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                    }
                }
                this.refreshDisplay();
                break;
            }
            case 4: {
                this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                this.refreshDisplay();
                break;
            }
            case 6: {
                if (notification.getOldValue() instanceof List) {
                    List removedElements = (List)notification.getOldValue();
                    for (Object removedElement : removedElements) {
                        if (!(removedElement instanceof EObject)) continue;
                        this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                    }
                }
                this.refreshDisplay();
                break;
            }
            case 1: {
                if (notification.getNewValue() != null) {
                    this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                }
                if (notification.getOldValue() != null) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                }
                this.refreshDisplay();
            }
        }
    }

    protected void notifyTypeChanged(Notification notification) {
        switch (notification.getFeatureID(notification.getNotifier().getClass())) {
            case 5: 
            case 9: 
            case 11: {
                this.refreshDisplay();
                break;
            }
        }
    }

    protected void notifyOperationChanged(Operation operation, Notification notification) {
        switch (notification.getFeatureID(Operation.class)) {
            case 5: 
            case 9: 
            case 20: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 43: {
                this.refreshDisplay();
                break;
            }
            case 24: {
                this.parameterListChange(notification);
                break;
            }
        }
    }

    private void notifySignalChanged(Signal signal, Notification notification) {
        switch (notification.getFeatureID(Signal.class)) {
            case 5: 
            case 9: {
                this.refreshDisplay();
                break;
            }
            case 38: {
                this.parameterListChange(notification);
                break;
            }
        }
    }

    protected boolean isParameterType(Object object, Operation operation) {
        if (!(object instanceof Type)) {
            return false;
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            if (!object.equals(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    protected boolean isParameter(Object object, Operation operation) {
        if (!(object instanceof Parameter)) {
            return false;
        }
        return operation.getOwnedParameters().contains(object);
    }

    private boolean isPropertyType(Object object, Signal signal) {
        if (!(object instanceof Type)) {
            return false;
        }
        for (Property property : signal.getOwnedAttributes()) {
            if (!object.equals(property.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean isProperty(Object object, Signal signal) {
        if (!(object instanceof Property)) {
            return false;
        }
        return signal.getOwnedAttributes().contains(object);
    }

    class DefaultValueListener
    implements NotificationListener {
        DefaultValueListener() {
        }

        public void notifyChanged(Notification notification) {
            MessageLabelEditPolicy.this.refreshDisplay();
        }
    }

    public static interface ICustomMessageLabel {
    }
}

