/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.parser.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.tools.utils.OperationUtil;
import org.eclipse.papyrus.uml.tools.utils.SignalUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageCustomParser
extends MessageFormatParser
implements ISemanticParser {
    public MessageCustomParser(EAttribute[] features) {
        super(features);
    }

    public MessageCustomParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public MessageCustomParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    @Override
    public String getPrintString(IAdaptable adapter, int flags) {
        Object obj = adapter.getAdapter(EObject.class);
        String result = null;
        if (obj instanceof Message) {
            Message message = (Message)obj;
            NamedElement signature = message.getSignature();
            if (signature instanceof Operation) {
                Operation operation = (Operation)signature;
                result = MessageSort.REPLY_LITERAL.equals((Object)message.getMessageSort()) ? OperationUtil.getCustomLabel((Operation)operation, Arrays.asList("name", "returnType")) : (MessageSort.SYNCH_CALL_LITERAL.equals((Object)message.getMessageSort()) ? OperationUtil.getCustomLabel((Operation)operation, Arrays.asList("name", "parametersName", "parametersType")) : OperationUtil.getCustomLabel((Operation)operation, Arrays.asList("name", "parametersName", "parametersType", "returnType")));
            } else if (signature instanceof Signal) {
                result = SignalUtil.getCustomLabel((Signal)((Signal)signature), Arrays.asList("name", "type"));
            } else if (signature != null) {
                result = signature.getName();
            }
            if (result == null || result.equals("")) {
                result = message.getName();
            }
        }
        return result;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }

    public List<Element> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Element> semanticElementsBeingParsed = new ArrayList<Element>();
        if (element instanceof Message) {
            Message message = (Message)element;
            semanticElementsBeingParsed.add((Element)message);
            NamedElement signature = message.getSignature();
            semanticElementsBeingParsed.add((Element)signature);
            if (signature instanceof Operation) {
                for (Parameter parameter : ((Operation)signature).getOwnedParameters()) {
                    semanticElementsBeingParsed.add((Element)parameter);
                }
            }
            if (signature instanceof Signal) {
                for (Property property : ((Signal)signature).getOwnedAttributes()) {
                    semanticElementsBeingParsed.add((Element)property);
                }
            }
        }
        return semanticElementsBeingParsed;
    }
}

