/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.edit.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.uml.diagram.common.editparts.NamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AffixedNodeAlignmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.PapyrusCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.QualifiedNameDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.StateMachineFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.locators.CustomEntryExitPointPositionLocator;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.policies.CustomStateMachineDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.policies.CustomStateMachineLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateEntryPointEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateExitPointEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateMachineCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateMachineNameEditPart;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.policies.StateMachineItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachineEditPart
extends NamedElementEditPart {
    public static final int VISUAL_ID = 2000;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public StateMachineEditPart(View view) {
        super(view);
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof StateMachineNameEditPart) {
            ((StateMachineNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof StateMachineCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getStateMachineCompartmentFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((StateMachineCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PseudostateEntryPointEditPart) {
            CustomEntryExitPointPositionLocator locator = new CustomEntryExitPointPositionLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((PseudostateEntryPointEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        if (childEditPart instanceof PseudostateExitPointEditPart) {
            CustomEntryExitPointPositionLocator locator = new CustomEntryExitPointPositionLocator(this.getMainFigure(), 0);
            this.getBorderedFigure().getBorderItemContainer().add(((PseudostateExitPointEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new PapyrusCreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new StateMachineItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("Qualified_name_editpolicy", (EditPolicy)new QualifiedNameDisplayEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("affixed node alignment editpolicy", (EditPolicy)new AffixedNodeAlignmentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new CustomStateMachineLayoutEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new CustomStateMachineDiagramDragDropEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (UMLVisualIDRegistry.getVisualID(childView)) {
                    case 16000: 
                    case 17000: {
                        return new BorderItemResizableEditPolicy();
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected NodeFigure createNodePlate() {
        String prefElementId = "StateMachine";
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        return result;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new StateMachineFigure();
        return this.primaryShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof StateMachineCompartmentEditPart) {
            return this.getPrimaryShape().getStateMachineCompartmentFigure();
        }
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    public List<IElementType> getMARelTypesOnSource() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.Generalization_19000);
        return types;
    }

    public List<IElementType> getMARelTypesOnSourceAndTarget(IGraphicalEditPart targetEditPart) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (targetEditPart instanceof StateMachineEditPart) {
            types.add(UMLElementTypes.Generalization_19000);
        }
        return types;
    }

    public List<IElementType> getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(3);
        types.add(UMLElementTypes.Generalization_19000);
        types.add(UMLElementTypes.CommentAnnotatedElement_667);
        types.add(UMLElementTypes.ConstraintConstrainedElement_670);
        return types;
    }

    public List<IElementType> getMATypesForSource(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == UMLElementTypes.Generalization_19000) {
            types.add(UMLElementTypes.StateMachine_2000);
        } else if (relationshipType == UMLElementTypes.CommentAnnotatedElement_667) {
            types.add(UMLElementTypes.Comment_666);
        } else if (relationshipType == UMLElementTypes.ConstraintConstrainedElement_670) {
            types.add(UMLElementTypes.Constraint_668);
        }
        return types;
    }

    public List<IElementType> getMATypesForTarget(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == UMLElementTypes.Generalization_19000) {
            types.add(UMLElementTypes.StateMachine_2000);
        }
        return types;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        Object result = null;
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor() || feature == NotationPackage.eINSTANCE.getFontStyle_FontColor() || feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            String prefColor = null;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)"StateMachine", (int)3);
            } else if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)"StateMachine", (int)2);
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)"StateMachine", (int)0);
            }
            result = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)prefColor));
        } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency() || feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
            String prefGradient = PreferencesConstantsHelper.getElementConstant((String)"StateMachine", (int)4);
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(preferenceStore.getString(prefGradient));
            if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
                result = new Integer(gradientPreferenceConverter.getTransparency());
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
                result = gradientPreferenceConverter.getGradientData();
            }
        }
        if (result == null) {
            result = this.getStructuralFeatureValue(feature);
        }
        return result;
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(2001));
    }

    public StateMachineFigure getPrimaryShape() {
        return (StateMachineFigure)this.primaryShape;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof StateMachineNameEditPart) {
            return true;
        }
        if (childEditPart instanceof StateMachineCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getStateMachineCompartmentFigure();
            pane.remove(((StateMachineCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PseudostateEntryPointEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((PseudostateEntryPointEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof PseudostateExitPointEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((PseudostateExitPointEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }
}

