/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.papyrus.uml.diagram.statemachine.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.uml.diagram.statemachine.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLParserProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Region;

public class UMLNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public String getDescription(Object anElement) {
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return UMLDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = UMLDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && UMLElementTypes.isKnownElementType(elementType)) {
            image = UMLElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public Image getImage(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getImage("Navigator?Diagram?http://www.eclipse.org/uml2/4.0.0/UML?Package", UMLElementTypes.Package_1000);
            }
            case 2000: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/uml2/4.0.0/UML?StateMachine", UMLElementTypes.StateMachine_2000);
            }
            case 3000: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?Region", UMLElementTypes.Region_3000);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private String getPackage_1000Text(View view) {
        Package domainModelElement = (Package)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 1000");
        return "";
    }

    private String getRegion_3000Text(View view) {
        Region domainModelElement = (Region)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3000");
        return "";
    }

    private String getStateMachine_2000Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.StateMachine_2000, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(2001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 2001");
        return "";
    }

    public String getText(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getPackage_1000Text(view);
            }
            case 2000: {
                return this.getStateMachine_2000Text(view);
            }
            case 3000: {
                return this.getRegion_3000Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLStateMachineDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof UMLNavigatorItem && !this.isOwnView(((UMLNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }
}

