/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.symbols.provider;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.AbstractShapeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ProviderNotificationManager;
import org.eclipse.papyrus.uml.diagram.symbols.Activator;
import org.eclipse.papyrus.uml.tools.listeners.PapyrusStereotypeListener;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedElementShapeProvider
extends AbstractShapeProvider {
    public List<RenderedImage> getShapes(EObject view) {
        block5: {
            Type type = this.getType(view);
            String path = this.getSymbolPath(type);
            if (path != null && path.length() > 0) {
                try {
                    URL url = new URL(path);
                    return Arrays.asList(RenderedImageFactory.getInstance((URL)url));
                }
                catch (MalformedURLException e) {
                    URI typeResourceURI = type.eResource().getURI();
                    if (typeResourceURI == null) break block5;
                    String workspaceRelativeFolderPath = typeResourceURI.trimSegments(1).toPlatformString(true);
                    try {
                        URL url = new URL("platform:/resource/" + workspaceRelativeFolderPath + File.separatorChar + path);
                        return Arrays.asList(RenderedImageFactory.getInstance((URL)url));
                    }
                    catch (MalformedURLException e1) {
                        Activator.log.error((Throwable)e1);
                    }
                }
            }
        }
        return null;
    }

    public boolean providesShapes(EObject view) {
        Type type = this.getType(view);
        String path = this.getSymbolPath(type);
        return path != null && path.length() > 0;
    }

    protected Type getType(EObject view) {
        if (!(view instanceof View)) {
            return null;
        }
        EObject element = ((View)view).getElement();
        if (element instanceof Type) {
            return (Type)element;
        }
        if (element instanceof TypedElement) {
            return ((TypedElement)element).getType();
        }
        return null;
    }

    protected String getSymbolPath(Type type) {
        if (type == null) {
            return null;
        }
        Stereotype stereotype = type.getAppliedStereotype("PapyrusInternal::Symbols::TypeSymbolDefinition");
        if (stereotype == null) {
            return null;
        }
        Object path = type.getValue(stereotype, "symbolPath");
        if (path instanceof String && ((String)path).length() > 0) {
            return path.toString();
        }
        return null;
    }

    public ProviderNotificationManager createProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
        if (view == null || !(view instanceof View)) {
            return null;
        }
        TypedElementShapeProviderNotificationManager notificationManager = new TypedElementShapeProviderNotificationManager(diagramEventBroker, view, listener);
        return notificationManager;
    }

    public class TypedElementShapeProviderNotificationManager
    extends ProviderNotificationManager
    implements NotificationListener {
        public TypedElementShapeProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
            super(diagramEventBroker, view, listener);
        }

        protected void registerListeners() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            EObject semanticElement = ((View)this.view).getElement();
            if (semanticElement instanceof Type) {
                this.diagramEventBroker.addNotificationListener((EObject)((Type)semanticElement), (NotificationListener)this);
            } else if (semanticElement instanceof TypedElement) {
                this.diagramEventBroker.addNotificationListener((EObject)((TypedElement)semanticElement), (NotificationListener)this);
                Type type = ((TypedElement)semanticElement).getType();
                if (type != null) {
                    this.diagramEventBroker.addNotificationListener((EObject)type, (NotificationListener)this);
                }
            }
        }

        public void dispose() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            EObject semanticElement = ((View)this.view).getElement();
            if (semanticElement instanceof Type) {
                this.diagramEventBroker.removeNotificationListener((EObject)((Type)semanticElement), (NotificationListener)this);
            } else if (semanticElement instanceof TypedElement) {
                this.diagramEventBroker.removeNotificationListener((EObject)((TypedElement)semanticElement), (NotificationListener)this);
                Type type = ((TypedElement)semanticElement).getType();
                if (type != null) {
                    this.diagramEventBroker.removeNotificationListener((EObject)type, (NotificationListener)this);
                }
            }
            super.dispose();
        }

        public void notifyChanged(Notification notification) {
            if (this.listener == null) {
                return;
            }
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(notification.getFeature())) {
                Object newValue;
                this.listener.notifyChanged(notification);
                Object oldValue = notification.getOldValue();
                if (oldValue instanceof Type) {
                    this.diagramEventBroker.removeNotificationListener((EObject)((Type)oldValue), (NotificationListener)this);
                }
                if ((newValue = notification.getNewValue()) instanceof Type) {
                    this.diagramEventBroker.removeNotificationListener((EObject)((Type)newValue), (NotificationListener)this);
                }
            } else if (notification instanceof PapyrusStereotypeListener.StereotypeCustomNotification) {
                this.listener.notifyChanged(notification);
            }
        }
    }
}

