/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parsers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EcoreUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactStateInvariantNameParser
implements ISemanticParser {
    public String getEditString(IAdaptable adaptable, int flags) {
        StateInvariant stateInvariant = CompactStateInvariantNameParser.getStateInvariant(adaptable);
        String name = StateInvariantUtils.getInnerStateInvariantName(stateInvariant);
        if (name == null) {
            return "";
        }
        return name;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable adaptable, final String newString, int flags) {
        final StateInvariant stateInvariant = CompactStateInvariantNameParser.getStateInvariant(adaptable);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)stateInvariant);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new AbstractTransactionalCommand(editingDomain, Messages.CompactStateInvariantNameParser_SetStateInvariantName, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                StateInvariantUtils.setInnerStateInvariantName(stateInvariant, newString);
                stateInvariant.setName(newString);
                for (Lifeline coveredLifeline : stateInvariant.getCovereds()) {
                    LifelineUtils.updateFragmentNames(coveredLifeline, null);
                    StateDefinitionUtils.updateStateDefinitionNamesForCompactLifeline(coveredLifeline);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private static StateInvariant getStateInvariant(IAdaptable adaptable) {
        return (StateInvariant)adaptable.getAdapter(EObject.class);
    }

    public String getPrintString(IAdaptable adaptable, int flags) {
        StateInvariant stateInvariant = CompactStateInvariantNameParser.getStateInvariant(adaptable);
        String name = StateInvariantUtils.getInnerStateInvariantName(stateInvariant);
        if (name == null || name.length() == 0) {
            return Messages.CompactStateInvariantNameParser_Unnamed;
        }
        return name;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return true;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ValueSpecification specification;
        StateInvariant stateInvariant;
        Constraint invariant;
        ArrayList<ValueSpecification> list = new ArrayList<ValueSpecification>();
        if (element instanceof StateInvariant && (invariant = (stateInvariant = (StateInvariant)element).getInvariant()) != null && (specification = invariant.getSpecification()) != null) {
            list.add(specification);
        }
        return list;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = EcoreUtils.getEStructuralFeature(notification);
        return UMLPackage.eINSTANCE.getStateInvariant_Invariant().equals(feature) || UMLPackage.eINSTANCE.getConstraint_Specification().equals(feature) || UMLPackage.eINSTANCE.getOpaqueExpression_Body().equals(feature);
    }
}

