/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.TimingDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.VerticalMarkFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.locator.LabelInCompartmentLocator;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.TickNameEditPart;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class TickEditPart
extends AbstractBorderedShapeEditPart {
    public static final int VISUAL_ID = 26;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public TickEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("SemanticPolicy");
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new TimingDiagramDragDropEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (UMLVisualIDRegistry.getVisualID(childView)) {
                    case 36: {
                        return new BorderItemSelectionEditPolicy(){

                            protected List createSelectionHandles() {
                                MoveHandle mh = new MoveHandle((GraphicalEditPart)this.getHost());
                                mh.setBorder(null);
                                return Collections.singletonList(mh);
                            }
                        };
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new VerticalMarkFigure();
        return this.primaryShape;
    }

    public VerticalMarkFigure getPrimaryShape() {
        return (VerticalMarkFigure)this.primaryShape;
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof TickNameEditPart) {
            LabelInCompartmentLocator locator = new LabelInCompartmentLocator(this.getMainFigure());
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else {
            super.addBorderItem(borderItemContainer, borderItemEditPart);
        }
    }

    protected NodeFigure createNodePlate() {
        String prefElementId = "Tick";
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)"Tick", (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)"Tick", (int)16);
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        return result;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(36));
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        Object result = null;
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor() || feature == NotationPackage.eINSTANCE.getFontStyle_FontColor() || feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            String prefColor = null;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)"Tick", (int)3);
            } else if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)"Tick", (int)2);
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                prefColor = PreferencesConstantsHelper.getElementConstant((String)"Tick", (int)0);
            }
            result = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)prefColor));
        } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency() || feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
            String prefGradient = PreferencesConstantsHelper.getElementConstant((String)"Tick", (int)4);
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(preferenceStore.getString(prefGradient));
            if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
                result = new Integer(gradientPreferenceConverter.getTransparency());
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
                result = gradientPreferenceConverter.getGradientData();
            }
        }
        if (result == null) {
            result = this.getStructuralFeatureValue(feature);
        }
        return result;
    }
}

