/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.commands.ICreationCommand;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.extension.commands.IModelCreationCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.INewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.NewModelStorageProviderRegistry;
import org.eclipse.papyrus.uml.diagram.wizards.SettingsHelper;
import org.eclipse.papyrus.uml.diagram.wizards.WorkspaceNewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryDescriptor;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryRegistry;
import org.eclipse.papyrus.uml.diagram.wizards.category.NewPapyrusModelCommand;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectDiagramCategoryPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectDiagramKindPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectStorageProviderPage;
import org.eclipse.papyrus.uml.diagram.wizards.template.InitFromTemplateCommand;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.services.IEvaluationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateModelWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "org.eclipse.papyrus.uml.diagram.wizards.createmodel";
    public static final String NEW_MODEL_SETTINGS = "NewModelWizard";
    private SelectStorageProviderPage selectStorageProviderPage;
    private SelectDiagramKindPage selectDiagramKindPage;
    private SelectDiagramCategoryPage selectDiagramCategoryPage;
    private IWorkbench workbench;
    private NewModelStorageProviderRegistry storageProviderRegistry;
    private INewModelStorageProvider selectedStorageProvider;
    private Map<INewModelStorageProvider, List<IWizardPage>> providerPages = new HashMap<INewModelStorageProvider, List<IWizardPage>>();
    private Map<IWizardPage, INewModelStorageProvider> providersByPage = new HashMap<IWizardPage, INewModelStorageProvider>();
    private int startProviderPageIndex;
    private int endProviderPageIndex;

    public CreateModelWizard() {
        this.setWindowTitle(Messages.CreateModelWizard_new_papyrus_model_title);
    }

    public void addPages() {
        this.addPageIfNotNull((IWizardPage)this.selectStorageProviderPage);
        this.startProviderPageIndex = this.getPageCount() - 1;
        for (INewModelStorageProvider iNewModelStorageProvider : this.getStorageProviders()) {
            ArrayList<IWizardPage> pageList = new ArrayList<IWizardPage>(3);
            for (IWizardPage iWizardPage : iNewModelStorageProvider.createPages()) {
                if (iWizardPage == null) continue;
                pageList.add(iWizardPage);
                this.providersByPage.put(iWizardPage, iNewModelStorageProvider);
                this.addPage(iWizardPage);
            }
            this.providerPages.put(iNewModelStorageProvider, pageList);
        }
        this.endProviderPageIndex = this.getPageCount();
        this.addPageIfNotNull((IWizardPage)this.selectDiagramCategoryPage);
        this.addPageIfNotNull((IWizardPage)this.selectDiagramKindPage);
    }

    protected final void addPageIfNotNull(IWizardPage page) {
        if (page != null) {
            this.addPage(page);
        }
    }

    public boolean isInitModelWizard() {
        return false;
    }

    public boolean isCreateProjectWizard() {
        return false;
    }

    public boolean isCreateMultipleModelsWizard() {
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.initStorageProvider(workbench, selection);
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(NEW_MODEL_SETTINGS);
        if (section == null) {
            section = workbenchSettings.addNewSection(NEW_MODEL_SETTINGS);
        }
        this.setDialogSettings(section);
        this.selectStorageProviderPage = this.createSelectStorageProviderPage();
        for (INewModelStorageProvider iNewModelStorageProvider : this.getStorageProviders()) {
            iNewModelStorageProvider.init(this, selection);
        }
        this.selectDiagramCategoryPage = this.createSelectDiagramCategoryPage();
        this.selectDiagramKindPage = this.createSelectDiagramKindPage();
    }

    public boolean performFinish() {
        String[] diagramCategoryIds = this.getDiagramCategoryIds();
        if (diagramCategoryIds.length == 0) {
            return false;
        }
        String diagramCategoryId = diagramCategoryIds[0];
        URI newURI = this.createNewModelURI(diagramCategoryId);
        this.createAndOpenPapyrusModel(newURI, diagramCategoryId);
        this.saveDiagramCategorySettings();
        this.saveDiagramKindSettings();
        return true;
    }

    protected URI createNewModelURI(String diagramCategoryID) {
        return this.getSelectedStorageProvider().createNewModelURI(diagramCategoryID);
    }

    protected boolean createAndOpenPapyrusModel(URI newURI, String diagramCategoryId) {
        if (newURI == null) {
            return false;
        }
        ServicesRegistry registry = this.createServicesRegistry();
        if (registry == null) {
            return false;
        }
        try {
            try {
                ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
                this.createPapyrusModels(modelSet, newURI);
                this.initServicesRegistry(registry);
                this.initDomainModel(modelSet, newURI, diagramCategoryId);
                this.initDiagramModel(modelSet, diagramCategoryId);
                this.openDiagram(newURI);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                try {
                    registry.disposeRegistry();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                registry.disposeRegistry();
            }
            catch (ServiceException serviceException) {}
        }
        return true;
    }

    protected ServicesRegistry createServicesRegistry() {
        ExtensionServicesRegistry result = null;
        try {
            result = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        try {
            result.startServicesByClassKeys(new Class[]{ModelSet.class});
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }

    protected void initServicesRegistry(ServicesRegistry registry) throws ServiceException {
        try {
            registry.startRegistry();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        registry.getService(IPageManager.class);
    }

    protected String[] getDiagramCategoryIds() {
        if (this.selectDiagramCategoryPage != null) {
            return this.selectDiagramCategoryPage.getDiagramCategories();
        }
        return null;
    }

    public String getDiagramFileExtension(String diagramCategoryId) {
        return this.getDiagramFileExtension(diagramCategoryId, "di");
    }

    public String getDiagramFileExtension(String categoryId, String defaultExtension) {
        DiagramCategoryDescriptor diagramCategory = this.getDiagramCategoryMap().get(categoryId);
        String extensionPrefix = diagramCategory != null ? diagramCategory.getExtensionPrefix() : null;
        return extensionPrefix != null ? String.valueOf(extensionPrefix) + "." + defaultExtension : defaultExtension;
    }

    protected SelectDiagramCategoryPage createSelectDiagramCategoryPage() {
        return new SelectDiagramCategoryPage();
    }

    protected SelectDiagramKindPage createSelectDiagramKindPage() {
        return new SelectDiagramKindPage(new SelectDiagramKindPage.CategoryProvider(){

            public String[] getCurrentCategories() {
                return CreateModelWizard.this.getDiagramCategoryIds();
            }
        });
    }

    protected void initDomainModel(ModelSet modelSet, URI newURI, String diagramCategoryId) {
        boolean isToInitFromTemplate;
        boolean bl = isToInitFromTemplate = this.selectDiagramKindPage.getTemplatePath() != null;
        if (isToInitFromTemplate) {
            this.initDomainModelFromTemplate(modelSet);
        } else {
            this.createEmptyDomainModel(modelSet, diagramCategoryId);
        }
    }

    protected void initDomainModelFromTemplate(ModelSet modelSet) {
        this.getCommandStack(modelSet).execute((Command)new InitFromTemplateCommand(modelSet.getTransactionalEditingDomain(), modelSet, this.selectDiagramKindPage.getTemplatePluginId(), this.selectDiagramKindPage.getTemplatePath(), this.selectDiagramKindPage.getNotationTemplatePath(), this.selectDiagramKindPage.getDiTemplatePath()));
    }

    protected void createEmptyDomainModel(ModelSet modelSet, String diagramCategoryId) {
        try {
            IModelCreationCommand creationCommand = this.getDiagramCategoryMap().get(diagramCategoryId).getCommand();
            creationCommand.createModel(modelSet);
        }
        catch (BackboneException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void createPapyrusModels(ModelSet modelSet, URI newURI) {
        NewPapyrusModelCommand command = new NewPapyrusModelCommand(modelSet, newURI);
        this.getCommandStack(modelSet).execute((Command)command);
    }

    protected void saveDiagramCategorySettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            SettingsHelper settingsHelper = new SettingsHelper(settings);
            settingsHelper.saveDefaultDiagramCategory(this.getDiagramCategoryIds());
        }
    }

    protected void saveDiagramKindSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings == null) {
            return;
        }
        SettingsHelper settingsHelper = new SettingsHelper(settings);
        String[] stringArray = this.getDiagramCategoryIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            if (this.selectDiagramKindPage.isRememberCurrentSelection()) {
                this.saveDefaultDiagramKinds(settingsHelper, category);
                this.saveDefaultTemplates(settingsHelper, category);
            } else {
                settingsHelper.saveDefaultDiagramKinds(category, Collections.<String>emptyList());
                settingsHelper.saveDefaultTemplates(category, Collections.<String>emptyList());
            }
            ++n2;
        }
        settingsHelper.saveRememberCurrentSelection(this.selectDiagramKindPage.isRememberCurrentSelection());
    }

    private void saveDefaultDiagramKinds(SettingsHelper settingsHelper, String category) {
        String[] selected = this.selectDiagramKindPage.getSelectedDiagramKinds(category);
        settingsHelper.saveDefaultDiagramKinds(category, Arrays.asList(selected));
    }

    private void saveDefaultTemplates(SettingsHelper settingsHelper, String category) {
        if (!this.selectDiagramKindPage.templatesEnabled()) {
            return;
        }
        String path = this.selectDiagramKindPage.getTemplatePath();
        settingsHelper.saveDefaultTemplates(category, Collections.singletonList(path));
    }

    protected void openDiagram(URI newURI) {
        IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            try {
                IEditorInput editorInput = this.createEditorInput(newURI);
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)this.getPreferredEditorID(editorInput), (boolean)true);
            }
            catch (PartInitException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected IEditorInput createEditorInput(URI uri) {
        return this.getSelectedStorageProvider().createEditorInput(uri);
    }

    protected String getPreferredEditorID(IEditorInput input) throws PartInitException {
        IEditorDescriptor desc;
        if (input instanceof IFileEditorInput) {
            desc = IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile());
        } else {
            URI uri = null;
            if (input instanceof IURIEditorInput) {
                uri = URI.createURI((String)((IURIEditorInput)input).getURI().toString(), (boolean)true);
            } else if (input instanceof URIEditorInput) {
                uri = ((URIEditorInput)input).getURI();
            }
            desc = uri != null ? IDE.getEditorDescriptor((String)uri.lastSegment()) : IDE.getEditorDescriptor((String)input.getName());
        }
        return desc == null ? "org.eclipse.papyrus.infra.core.papyrusEditor" : desc.getId();
    }

    protected void initDiagramModel(ModelSet modelSet, String categoryId) {
        this.initDiagrams(modelSet, categoryId);
        this.saveDiagram(modelSet);
    }

    private void saveDiagram(ModelSet modelSet) {
        try {
            modelSet.save((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void initDiagrams(ModelSet modelSet, String categoryId) {
        this.initDiagrams(modelSet, null, categoryId);
    }

    protected void initDiagrams(ModelSet resourceSet, EObject root, String categoryId) {
        List<ICreationCommand> creationCommands = this.getDiagramKindsFor(categoryId);
        String diagramName = this.selectDiagramKindPage.getDiagramName();
        if (creationCommands.isEmpty()) {
            this.createEmptyDiagramEditor(resourceSet);
        } else {
            int i = 0;
            while (i < creationCommands.size()) {
                creationCommands.get(i).createDiagram(resourceSet, root, diagramName);
                ++i;
            }
        }
    }

    protected List<ICreationCommand> getDiagramKindsFor(String categoryId) {
        return this.selectDiagramKindPage.getCreationCommands(categoryId);
    }

    private void createEmptyDiagramEditor(ModelSet modelSet) {
        EditorUtils.getTransactionalIPageMngr((Resource)DiModelUtils.getDiResource((ModelSet)modelSet), (TransactionalEditingDomain)modelSet.getTransactionalEditingDomain());
    }

    protected final CommandStack getCommandStack(ModelSet modelSet) {
        return modelSet.getTransactionalEditingDomain().getCommandStack();
    }

    protected Map<String, DiagramCategoryDescriptor> getDiagramCategoryMap() {
        return DiagramCategoryRegistry.getInstance().getDiagramCategoryMap();
    }

    public IStatus diagramCategoryChanged(String ... newCategories) {
        return this.getSelectedStorageProvider().validateDiagramCategories(newCategories);
    }

    protected void initStorageProvider(IWorkbench workbench, IStructuredSelection selection) {
        NewModelStorageProviderRegistry registry = new NewModelStorageProviderRegistry((IEvaluationService)workbench.getService(IEvaluationService.class));
        if (this.isCreateProjectWizard()) {
            this.selectedStorageProvider = new WorkspaceNewModelStorageProvider();
        } else {
            INewModelStorageProvider firstProvider = null;
            for (INewModelStorageProvider next : registry) {
                if (firstProvider == null) {
                    firstProvider = next;
                }
                if (selection.isEmpty() || !next.canHandle(selection)) continue;
                this.selectedStorageProvider = next;
                break;
            }
            if (this.selectedStorageProvider == null) {
                this.selectedStorageProvider = firstProvider;
                if (registry.size() > 1) {
                    this.storageProviderRegistry = registry;
                }
            }
        }
    }

    protected SelectStorageProviderPage createSelectStorageProviderPage() {
        SelectStorageProviderPage result;
        SelectStorageProviderPage selectStorageProviderPage = result = this.storageProviderRegistry == null ? null : new SelectStorageProviderPage(this.storageProviderRegistry);
        if (result != null) {
            result.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    INewModelStorageProvider provider = (INewModelStorageProvider)((IStructuredSelection)event.getSelection()).getFirstElement();
                    CreateModelWizard.this.setSelectedStorageProvider(provider);
                }
            });
        }
        return result;
    }

    protected Iterable<? extends INewModelStorageProvider> getStorageProviders() {
        Iterable<NewModelStorageProviderRegistry.Descriptor> result = this.storageProviderRegistry != null ? this.storageProviderRegistry : (this.selectedStorageProvider != null ? Collections.singletonList(this.selectedStorageProvider) : Collections.emptyList());
        return result;
    }

    protected INewModelStorageProvider getSelectedStorageProvider() {
        return this.selectedStorageProvider;
    }

    private void setSelectedStorageProvider(INewModelStorageProvider provider) {
        this.selectedStorageProvider = provider;
        this.getContainer().updateButtons();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        List<IWizardPage> allPages = Arrays.asList(this.getPages());
        IWizardPage result = null;
        INewModelStorageProvider provider = this.providersByPage.get(page);
        if (provider != null) {
            List<IWizardPage> pages = this.providerPages.get(provider);
            int index = pages.indexOf(page);
            if (index >= 0 && index < pages.size() - 1) {
                result = pages.get(index + 1);
            } else if (this.endProviderPageIndex < allPages.size()) {
                result = allPages.get(this.endProviderPageIndex);
            }
        } else if (allPages.indexOf(page) == this.startProviderPageIndex) {
            List<IWizardPage> pages = this.providerPages.get(this.getSelectedStorageProvider());
            if (!pages.isEmpty()) {
                result = pages.get(0);
            } else if (this.endProviderPageIndex < allPages.size()) {
                result = allPages.get(this.endProviderPageIndex);
            }
        } else {
            result = super.getNextPage(page);
        }
        return result;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        List<IWizardPage> allPages = Arrays.asList(this.getPages());
        IWizardPage result = null;
        INewModelStorageProvider provider = this.providersByPage.get(page);
        if (provider != null) {
            List<IWizardPage> pages = this.providerPages.get(provider);
            int index = pages.indexOf(page);
            if (index > 0) {
                result = pages.get(index - 1);
            } else if (this.startProviderPageIndex >= 0) {
                result = allPages.get(this.startProviderPageIndex);
            }
        } else if (allPages.indexOf(page) == this.endProviderPageIndex) {
            List<IWizardPage> pages = this.providerPages.get(this.getSelectedStorageProvider());
            if (!pages.isEmpty()) {
                result = pages.get(pages.size() - 1);
            } else if (this.startProviderPageIndex >= 0) {
                result = allPages.get(this.startProviderPageIndex);
            }
        } else {
            result = super.getPreviousPage(page);
        }
        return result;
    }

    public boolean canFinish() {
        boolean result = true;
        IWizardPage[] allPages = this.getPages();
        int i = 0;
        while (result && i <= this.startProviderPageIndex) {
            result = allPages[i].isPageComplete();
            ++i;
        }
        if (result) {
            for (IWizardPage next : this.providerPages.get(this.selectedStorageProvider)) {
                if (next.isPageComplete()) continue;
                result = false;
                break;
            }
        }
        i = this.endProviderPageIndex;
        while (result && i < allPages.length) {
            result = allPages[i].isPageComplete();
            ++i;
        }
        return result;
    }

    public String getModelKindName() {
        return "Papyrus";
    }
}

