/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.uml.diagram.wizards.AbstractNewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.INewModelStorageProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.services.IEvaluationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewModelStorageProviderRegistry
implements Iterable<Descriptor> {
    private static final String EXTPT_ID = "org.eclipse.papyrus.uml.diagram.wizards.newModelStorageProviders";
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private final IEvaluationService evaluationService;

    public NewModelStorageProviderRegistry(IEvaluationService evaluationService) {
        this.evaluationService = evaluationService;
        for (IConfigurationElement config : this.sort(Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPT_ID))) {
            if (!"provider".equals(config.getName())) continue;
            this.descriptors.add(new Descriptor(config));
        }
    }

    @Override
    public Iterator<Descriptor> iterator() {
        return this.descriptors.iterator();
    }

    public int size() {
        return this.descriptors.size();
    }

    private List<IConfigurationElement> sort(IConfigurationElement[] providerElements) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>(Arrays.asList(providerElements));
        Collections.sort(result, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                String plugin2;
                String plugin1 = o1.getContributor().getName();
                int result = plugin1.equals(plugin2 = o2.getContributor().getName()) ? 0 : ("org.eclipse.papyrus.uml.diagram.wizards".equals(plugin1) ? -1 : ("org.eclipse.papyrus.uml.diagram.wizards".equals(plugin2) ? 1 : 0));
                return result;
            }
        });
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Descriptor
    implements INewModelStorageProvider {
        private final IConfigurationElement config;
        private String label;
        private Expression matchSelection;
        private INewModelStorageProvider instance;

        Descriptor(IConfigurationElement config) {
            this.config = config;
            this.label = config.getAttribute("name");
            this.initMatchExpression(config);
        }

        public String getLabel() {
            return this.label;
        }

        INewModelStorageProvider getInstance() {
            if (this.instance == null) {
                try {
                    this.instance = (INewModelStorageProvider)this.config.createExecutableExtension("class");
                }
                catch (ClassCastException e) {
                    Activator.log.error("Storage provider does not implement INewModelStorageProvider interface.", (Throwable)e);
                }
                catch (Exception e) {
                    Activator.log.error("Could not instantiate storage provider.", (Throwable)e);
                }
                if (this.instance == null) {
                    this.instance = new NullProvider();
                }
            }
            return this.instance;
        }

        @Override
        public boolean canHandle(IStructuredSelection initialSelection) {
            boolean result;
            if (this.matchSelection != null) {
                List selection = initialSelection.toList();
                EvaluationContext ctx = new EvaluationContext(NewModelStorageProviderRegistry.this.evaluationService.getCurrentState(), (Object)selection);
                ctx.addVariable("selection", (Object)selection);
                EvaluationResult evalResult = EvaluationResult.FALSE;
                try {
                    evalResult = this.matchSelection.evaluate((IEvaluationContext)ctx);
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
                result = EvaluationResult.TRUE.equals(evalResult);
            } else {
                result = this.getInstance().canHandle(initialSelection);
            }
            return result;
        }

        @Override
        public void init(CreateModelWizard wizard, IStructuredSelection selection) {
            this.getInstance().init(wizard, selection);
        }

        @Override
        public List<? extends IWizardPage> createPages() {
            return this.getInstance().createPages();
        }

        @Override
        public URI createNewModelURI(String diagramCategoryID) {
            return this.getInstance().createNewModelURI(diagramCategoryID);
        }

        @Override
        public IEditorInput createEditorInput(URI uri) {
            return this.getInstance().createEditorInput(uri);
        }

        @Override
        public IStatus validateDiagramCategories(String ... newCategories) {
            return this.getInstance().validateDiagramCategories(newCategories);
        }

        @Override
        public INewModelStorageProvider.ISelectProviderPart createSelectProviderPart() {
            return this.getInstance().createSelectProviderPart();
        }

        private void initMatchExpression(IConfigurationElement parentConfig) {
            IConfigurationElement[] configs = parentConfig.getChildren("enablement");
            if (configs.length > 0) {
                try {
                    this.matchSelection = ExpressionConverter.getDefault().perform(configs[0]);
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullProvider
    extends AbstractNewModelStorageProvider {
        private NullProvider() {
        }

        @Override
        public boolean canHandle(IStructuredSelection initialSelection) {
            return false;
        }

        @Override
        public List<? extends IWizardPage> createPages() {
            return Collections.emptyList();
        }

        @Override
        public URI createNewModelURI(String diagramCategoryID) {
            return null;
        }
    }
}

