/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.uml.diagram.wizards.AbstractNewModelStorageProvider;
import org.eclipse.papyrus.uml.diagram.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.InitModelWizard;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;
import org.eclipse.papyrus.uml.diagram.wizards.utils.WizardsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceNewModelStorageProvider
extends AbstractNewModelStorageProvider {
    private CreateModelWizard wizard;
    private NewModelFilePage newModelFilePage;

    @Override
    public boolean canHandle(IStructuredSelection initialSelection) {
        boolean result = false;
        for (Object next : initialSelection.toList()) {
            if (WizardsHelper.adapt(next, IResource.class) == null) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void init(CreateModelWizard wizard, IStructuredSelection selection) {
        super.init(wizard, selection);
        this.wizard = wizard;
        this.newModelFilePage = this.createNewModelFilePage(selection);
    }

    @Override
    public List<? extends IWizardPage> createPages() {
        if (this.newModelFilePage == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.newModelFilePage);
    }

    @Override
    public IStatus validateDiagramCategories(String ... newCategories) {
        if (this.newModelFilePage != null) {
            String firstCategory;
            String string = firstCategory = newCategories.length > 0 ? newCategories[0] : null;
            if (newCategories.length > 0) {
                return this.newModelFilePage.diagramExtensionChanged(this.wizard.getDiagramFileExtension(firstCategory));
            }
        }
        return super.validateDiagramCategories(newCategories);
    }

    protected NewModelFilePage createNewModelFilePage(IStructuredSelection selection) {
        if (this.wizard.isCreateProjectWizard() || this.wizard.isCreateMultipleModelsWizard()) {
            return null;
        }
        URI selectedResourceURI = WizardsHelper.getSelectedResourceURI(selection);
        if (this.isCreateFromExistingDomainModel() && selectedResourceURI != null) {
            return new InitModelWizard.NewDiagramForExistingModelPage(selection, this.wizard.getModelKindName(), String.valueOf(this.getDiagramFileName(selectedResourceURI)) + "." + this.wizard.getDiagramFileExtension(null), this.wizard.getDiagramFileExtension(null));
        }
        return new NewModelFilePage(selection, this.wizard.getModelKindName());
    }

    protected String getDiagramFileName(URI domainModelURI) {
        return domainModelURI.trimFileExtension().lastSegment();
    }

    protected boolean isCreateFromExistingDomainModel() {
        return this.wizard.isInitModelWizard() && ((InitModelWizard)this.wizard).isCreateFromExistingDomainModel();
    }

    @Override
    public URI createNewModelURI(String categoryId) {
        IFile newFile = this.newModelFilePage.createNewFile();
        return newFile == null ? null : URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
    }
}

