/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.databinding.ElementCustomizationObservableValue;
import org.eclipse.papyrus.uml.properties.databinding.MaskValueObservableList;
import org.eclipse.papyrus.uml.properties.messages.Messages;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.papyrus.views.properties.modelelement.AbstractModelElement;
import org.eclipse.uml2.uml.NamedElement;

public class UMLNotationModelElement
extends AbstractModelElement {
    public static final String LabelCustomization = "labelCustomization";
    public static final String StereotypeDisplay = "stereotypeDisplay";
    public static final String ElementIcon = "elementIcon";
    public static final String Shadow = "shadow";
    public static final String QualifiedName = "qualifiedName";
    private EditPart sourceElement;

    public UMLNotationModelElement(EditPart sourceElement) {
        this.sourceElement = sourceElement;
    }

    public IObservable doGetObservable(String propertyPath) {
        if (propertyPath.equals(LabelCustomization)) {
            EditingDomain editingDomain = EMFHelper.resolveEditingDomain((Object)this.sourceElement);
            return new MaskValueObservableList(this.sourceElement, editingDomain);
        }
        if (propertyPath.equals(StereotypeDisplay)) {
            return null;
        }
        if (propertyPath.equals(ElementIcon)) {
            return new ElementCustomizationObservableValue(this.sourceElement, ElementCustomizationObservableValue.Property.ELEMENT_ICON);
        }
        if (propertyPath.equals(Shadow)) {
            return new ElementCustomizationObservableValue(this.sourceElement, ElementCustomizationObservableValue.Property.SHADOW);
        }
        if (propertyPath.equals(QualifiedName)) {
            return new ElementCustomizationObservableValue(this.sourceElement, ElementCustomizationObservableValue.Property.QUALIFIED_NAME);
        }
        Activator.log.warn("Unknown property : " + propertyPath);
        return null;
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals(QualifiedName)) {
            return new AbstractStaticContentProvider(){

                public Object[] getElements() {
                    int maxDepth = NamedElementUtil.getQualifiedNameMaxDepth((NamedElement)((NamedElement)UMLUtil.resolveUMLElement((Object)UMLNotationModelElement.this.sourceElement)));
                    if (maxDepth == 0) {
                        return new Integer[]{0};
                    }
                    Object[] result = new Integer[maxDepth + 1];
                    result[0] = maxDepth;
                    result[1] = 0;
                    int i = 1;
                    while (i < maxDepth) {
                        result[i + 1] = i;
                        ++i;
                    }
                    return result;
                }
            };
        }
        return null;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        int depth = NamedElementUtil.getQualifiedNameMaxDepth((NamedElement)((NamedElement)UMLUtil.resolveUMLElement((Object)this.sourceElement)));
        final int maxDepth = depth == 0 ? 1 : depth;
        return new LabelProvider(){

            public String getText(Object value) {
                if (value instanceof Integer) {
                    Integer intValue = (Integer)value;
                    if (intValue == maxDepth) {
                        return Messages.UMLNotationModelElement_DepthNone;
                    }
                    if (intValue == 0) {
                        return Messages.UMLNotationModelElement_DepthFull;
                    }
                    return "-" + intValue;
                }
                Activator.log.warn("Unknown value : " + value);
                return "";
            }
        };
    }

    public EModelElement getEModelElement() {
        return (EModelElement)this.sourceElement.getModel();
    }

    public EditPart getEditPart() {
        return this.sourceElement;
    }

    public boolean isMandatory(String propertyPath) {
        if (QualifiedName.equals(propertyPath)) {
            return true;
        }
        return super.isMandatory(propertyPath);
    }
}

